/*
 * Decompiled with CFR 0.152.
 */
package edu.utexas.cs.nn.logs;

import cz.cuni.amis.pogamut.base.communication.messages.InfoMessage;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.AddInventoryMsg;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotDamaged;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ItemPickedUp;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerDamaged;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerKilled;

public class LogEntry {
    private double time;
    private String id;
    private String name;
    private InfoMessage message;
    private String actor = null;
    private String target = null;

    public LogEntry(double time, String id, String name) {
        this.time = time;
        this.id = id;
        this.name = name;
    }

    public LogEntry(double time, String id, String name, InfoMessage message) {
        this(time, id, name);
        this.message = message;
    }

    public void setMessage(InfoMessage message) {
        this.message = message;
    }

    public double getTime() {
        return this.time;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public InfoMessage getMessage() {
        return this.message;
    }

    public String getEventType() {
        String header = this.message.toString().split(" \\| ")[0];
        int p1 = header.indexOf(91);
        int p2 = header.indexOf(93);
        if (p2 > p1 + 1 && p1 > 0) {
            return header.substring(p1 + 1, p2);
        }
        return header;
    }

    public String getEventBody() {
        String body = this.message.toString();
        int i = body.indexOf(" | ");
        if (i > 0) {
            return body.substring(i);
        }
        return body;
    }

    public String getActor() {
        UnrealId instigator;
        if (this.actor != null) {
            return this.actor;
        }
        if (this.message instanceof BotKilled) {
            UnrealId killer = ((BotKilled)this.message).getKiller();
            if (killer != null) {
                this.actor = killer.getStringId();
            }
        } else if (this.message instanceof PlayerKilled) {
            UnrealId killer = ((PlayerKilled)this.message).getKiller();
            if (killer != null) {
                this.actor = killer.getStringId();
            }
        } else if (this.message instanceof BotDamaged && (instigator = ((BotDamaged)this.message).getInstigator()) != null) {
            this.actor = instigator.getStringId();
        }
        return this.actor;
    }

    public String getTarget() {
        UnrealId playerDamaged;
        if (this.target != null) {
            return this.target;
        }
        if (this.message instanceof PlayerKilled) {
            UnrealId playerKilled = ((PlayerKilled)this.message).getId();
            if (playerKilled != null) {
                this.target = playerKilled.getStringId();
            }
        } else if (this.message instanceof ItemPickedUp) {
            UnrealId itemPickedUp = ((ItemPickedUp)this.message).getId();
            if (itemPickedUp != null) {
                this.target = itemPickedUp.getStringId();
            }
        } else if (this.message instanceof AddInventoryMsg) {
            UnrealId inventoryId = ((AddInventoryMsg)this.message).getId();
            if (inventoryId != null) {
                this.target = inventoryId.getStringId();
            }
        } else if (this.message instanceof PlayerDamaged && (playerDamaged = ((PlayerDamaged)this.message).getId()) != null) {
            this.target = playerDamaged.getStringId();
        }
        return this.target;
    }

    public String getLevel() {
        return this.id.split("\\.")[0];
    }

    public String toString() {
        return "LogEntry | " + this.time + " | " + this.id + " | " + this.name + " | " + this.getEventType() + " by " + this.getActor() + " on " + this.getTarget();
    }
}

