/*
 * Decompiled with CFR 0.152.
 */
package edu.utexas.cs.nn.logs;

import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.agent.impl.AgentId;
import cz.cuni.amis.pogamut.base.communication.connection.IWorldReaderProvider;
import cz.cuni.amis.pogamut.base.communication.messages.InfoMessage;
import cz.cuni.amis.pogamut.base.communication.parser.exception.ParserEOFException;
import cz.cuni.amis.pogamut.base.communication.parser.impl.yylex.IYylexObserver;
import cz.cuni.amis.pogamut.base.component.bus.ComponentBus;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.ut2004.communication.messages.UnrealIdTranslator;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Yylex;
import cz.cuni.amis.pogamut.ut2004.communication.parser.IUT2004Yylex;
import cz.cuni.amis.pogamut.ut2004.communication.parser.UT2004Parser;
import cz.cuni.amis.pogamut.ut2004.communication.translator.itemdescriptor.ItemTranslator;
import edu.utexas.cs.nn.logs.LogEntry;
import edu.utexas.cs.nn.logs.LogReaderProvider;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Pattern;

public class LogProcessor {
    public static Pattern logLinePattern = Pattern.compile("ScriptLog: nnrgAPI@([^:]+):([^:]+):([^:]+):(.*)");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LogEntry> parseLogEntries(BufferedReader reader) throws IOException {
        AgentId agentId = new AgentId(LogProcessor.class.getName() + ".parseLogEntries");
        AgentLogger logger = new AgentLogger((IAgentId)agentId);
        logger.setLevel(Level.ALL);
        ComponentBus bus = new ComponentBus((IAgentLogger)logger);
        LinkedList<LogEntry> events = new LinkedList<LogEntry>();
        LogReaderProvider readerProvider = new LogReaderProvider((IAgentLogger)logger, (IComponentBus)bus, reader);
        YylexObserver yylexObserver = new YylexObserver();
        Yylex yylex = new Yylex();
        ItemTranslator itemTranslator = new ItemTranslator();
        UnrealIdTranslator uidTranslator = new UnrealIdTranslator();
        UT2004Parser parser = new UT2004Parser(uidTranslator, itemTranslator, (IWorldReaderProvider)readerProvider, (IUT2004Yylex)yylex, (IYylexObserver)yylexObserver, (IComponentBus)bus, (IAgentLogger)logger);
        readerProvider.getController().manualStart("Manual start...");
        try {
            InfoMessage message = parser.parse();
            while (message != null) {
                LogEntry entry = readerProvider.getNextEntry();
                entry.setMessage(message);
                events.add(entry);
                message = parser.parse();
            }
        }
        catch (ParserEOFException eof) {
            System.out.println("EOF reached");
        }
        finally {
            readerProvider.getController().manualStop("Manual stop...");
        }
        return events;
    }

    public class YylexObserver
    implements IYylexObserver {
        public void exception(Exception e, String info) {
            System.err.println(info);
            e.printStackTrace(System.err);
        }

        public void warning(String info) {
        }
    }
}

