/*
 * Decompiled with CFR 0.152.
 */
package edu.utexas.cs.nn.logs;

import cz.cuni.amis.pogamut.base.communication.connection.WorldReader;
import cz.cuni.amis.pogamut.base.component.bus.exception.ComponentNotRunningException;
import cz.cuni.amis.pogamut.base.component.bus.exception.ComponentPausedException;
import cz.cuni.amis.utils.exception.PogamutIOException;
import edu.utexas.cs.nn.logs.LogEntry;
import edu.utexas.cs.nn.logs.LogProcessor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.Queue;
import java.util.regex.Matcher;

public class LogReader
extends WorldReader {
    private BufferedReader lineReader;
    private StringBuffer stringBuffer = new StringBuffer();
    private Queue<LogEntry> logEntryQueue = new LinkedList<LogEntry>();

    public LogReader(BufferedReader lineReader) throws IOException {
        this.lineReader = lineReader;
    }

    public void close() throws PogamutIOException {
        try {
            this.lineReader.close();
        }
        catch (IOException ex) {
            throw new PogamutIOException((Throwable)ex, (Object)this);
        }
    }

    public int read(char[] buffer, int off, int len) throws PogamutIOException, ComponentNotRunningException, ComponentPausedException {
        try {
            while (this.stringBuffer.length() < len) {
                String line = this.lineReader.readLine();
                if (line == null) {
                    return -1;
                }
                Matcher matcher = LogProcessor.logLinePattern.matcher(line);
                if (!matcher.matches()) continue;
                double time = Double.valueOf(matcher.group(1));
                String id = matcher.group(2).trim();
                String name = matcher.group(3).trim();
                this.logEntryQueue.add(new LogEntry(time, id, name));
                String message = matcher.group(4).trim();
                this.stringBuffer.append(message);
                this.stringBuffer.append("\n");
            }
            StringReader stringReader = new StringReader(this.stringBuffer.toString());
            int read = stringReader.read(buffer, off, len);
            if (read > 0) {
                this.stringBuffer.delete(0, read);
            }
            return read;
        }
        catch (IOException ex) {
            throw new PogamutIOException((Throwable)ex, (Object)this);
        }
    }

    public LogEntry getNextEntry() {
        return this.logEntryQueue.poll();
    }
}

