/*
 * Decompiled with CFR 0.152.
 */
package edu.utexas.cs.nn.retrace;

import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.utils.UT2004BotRunner;
import cz.cuni.amis.utils.exception.PogamutException;
import edu.utexas.cs.nn.Constants;
import edu.utexas.cs.nn.Point;
import edu.utexas.cs.nn.bots.HumanRetraceBot;
import edu.utexas.cs.nn.retrace.NavpointRetraceLink;
import edu.utexas.cs.nn.retrace.PoseSequence;
import edu.utexas.cs.nn.retrace.SimpleNavPointIndex;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import mockcz.cuni.pogamut.Client.AgentMemory;
import utopia.agentmodel.actions.Action;
import utopia.agentmodel.actions.MoveAlongAction;
import utopia.controllers.scripted.NeedyController;

public class HumanRetraceController
extends NeedyController {
    Future<SimpleNavPointIndex> theIndex = null;
    PoseSequence sequence = null;
    double lastTime = 0.0;
    double timeEstimate = 0.2;
    boolean firstStep = true;
    double distanceEstimate = 100.0;
    private boolean discontinuityOccurred = false;

    public HumanRetraceController() {
        this.register("Index Not Ready");
        this.register("Null Sequence");
        this.register("Path Depleted");
        this.register("First Step");
        this.register("Distance Progress");
        this.register("Time Progress");
        this.register("Trace Failure");
        this.register("Discontinuity");
        this.register("Null Points");
        this.register("Restart Failed");
    }

    @Override
    public void onBotInitialized(AgentMemory memory) {
        final String level = memory.game.getMapName();
        ExecutorService executor = Executors.newSingleThreadExecutor();
        this.theIndex = executor.submit(new Callable<SimpleNavPointIndex>(){

            @Override
            public SimpleNavPointIndex call() throws Exception {
                return new SimpleNavPointIndex(level);
            }
        });
    }

    private void updateEstimates(AgentMemory memory) {
        if (this.lastTime > 0.0) {
            double timeSinceLast = memory.game.getTime() - this.lastTime;
            this.timeEstimate = Constants.ESTIMATE_DECAY.getDouble() * this.timeEstimate + (1.0 - Constants.ESTIMATE_DECAY.getDouble()) * timeSinceLast;
        }
        if (memory.lastPosition != null) {
            double distance = memory.body.info.getLocation().getDistance(memory.lastPosition);
            this.distanceEstimate = Constants.ESTIMATE_DECAY.getDouble() * this.distanceEstimate + (1.0 - Constants.ESTIMATE_DECAY.getDouble()) * distance;
            if (Constants.VIEW_HRTC_MESSAGES.getBoolean()) {
                System.out.println("HRC: actually moved " + distance + " from " + memory.lastPosition + " to " + memory.body.info.getLocation());
            }
        }
        this.lastTime = memory.game.getTime();
    }

    @Override
    public void tick(AgentMemory memory) {
    }

    @Override
    public boolean isStillInterested(AgentMemory memory) {
        return this.sequence != null && this.sequence.hasNext();
    }

    @Override
    public void onBotShutdown(AgentMemory memory) {
    }

    public boolean ready() {
        return this.theIndex.isDone();
    }

    public Location setTarget(Location a, Location b) {
        if (!this.theIndex.isDone()) {
            return null;
        }
        try {
            NavpointRetraceLink link = this.theIndex.get().getLink(a, b);
            if (link == null) {
                return null;
            }
            this.sequence = link.getPath();
            this.firstStep = true;
            this.theIndex.get().resetTimeout();
            return link.getEndPoint().getLocation();
        }
        catch (InterruptedException ex) {
            Logger.getLogger(HumanRetraceController.class.getName()).log(Level.SEVERE, "HRC get index exception", ex);
            return null;
        }
        catch (ExecutionException ex) {
            Logger.getLogger(HumanRetraceController.class.getName()).log(Level.SEVERE, "HRC get index exception", ex);
            return null;
        }
    }

    @Override
    public Action control(AgentMemory memory) {
        this.updateEstimates(memory);
        try {
            double cdist;
            double bdist;
            Point C;
            Point B;
            if (!this.theIndex.isDone()) {
                this.takeAction("Index Not Ready");
                return null;
            }
            Location O = memory.body.info.getLocation();
            if (this.sequence == null) {
                this.sequence = this.theIndex.get().getClosestPath(O);
                this.firstStep = true;
            }
            if (this.sequence == null) {
                this.takeAction("Null Sequence");
                return null;
            }
            if (!this.sequence.hasNext()) {
                if (Constants.VIEW_HRTC_MESSAGES.getBoolean()) {
                    System.out.println("HRC: sequence depleted: " + this.sequence);
                }
                this.theIndex.get().putInTimeout(this.sequence, Constants.TRACE_TIME_OUT_DURATION.getInt());
                this.sequence = null;
                this.lastTime = 0.0;
                this.takeAction("Path Depleted");
                return null;
            }
            Point A = this.sequence.getCurrent();
            double adist = A.getLocation().getDistance(O.getLocation());
            if (this.firstStep) {
                B = this.sequence.nextByTime(0.0);
                C = this.sequence.peekByTime(this.timeEstimate);
                this.takeAction("First Step");
                this.firstStep = false;
                if (B != null && C != null && Constants.VIEW_HRTC_MESSAGES.getBoolean()) {
                    bdist = B.getLocation().getDistance(O.getLocation());
                    cdist = C.getLocation().getDistance(O.getLocation());
                    System.out.println("HRC:nextByTime(0) O:" + O + " A:" + adist + " B:" + bdist + " C:" + cdist);
                }
            } else if (this.distanceEstimate > Constants.MIN_DISTANCE_SKIP.getDouble()) {
                B = this.sequence.nextByDistance(Constants.HRTC_DISTANCE_FACTOR.getDouble() * this.distanceEstimate);
                C = this.sequence.peekByDistance(Constants.HRTC_DISTANCE_FACTOR.getDouble() * this.distanceEstimate * 1.5);
                this.takeAction("Distance Progress");
                if (B != null && C != null && Constants.VIEW_HRTC_MESSAGES.getBoolean()) {
                    bdist = B.getLocation().getDistance(O.getLocation());
                    cdist = C.getLocation().getDistance(O.getLocation());
                    System.out.println("HRC:nextByDistance(" + this.distanceEstimate + ") O:" + O + " A:" + adist + " B:" + bdist + " C:" + cdist);
                }
            } else if (this.timeEstimate > Constants.MIN_TIME_SKIP.getDouble()) {
                B = this.sequence.nextByTime(this.timeEstimate);
                C = this.sequence.peekByTime(this.timeEstimate);
                this.takeAction("Time Progress");
                if (B != null && C != null && Constants.VIEW_HRTC_MESSAGES.getBoolean()) {
                    bdist = B.getLocation().getDistance(O.getLocation());
                    cdist = C.getLocation().getDistance(O.getLocation());
                    if (Constants.VIEW_HRTC_MESSAGES.getBoolean()) {
                        System.out.println("HRC:nextByTime(" + this.timeEstimate + ") O:" + O + " A:" + adist + " B:" + bdist + " C:" + cdist);
                    }
                }
            } else {
                System.err.println("not first and estimates are bad");
                this.takeAction("Trace Failure");
                return null;
            }
            if (A != null && B != null && C != null) {
                double OA = O.getDistance(A.getLocation());
                double OB = O.getDistance(B.getLocation());
                double BC = B.getLocation().getDistance(C.getLocation());
                double OC = O.getDistance(C.getLocation());
                if (Constants.VIEW_HRTC_MESSAGES.getBoolean()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("HRC:DISTANCES:");
                    sb.append(OA).append(" ");
                    sb.append(OB).append(" ");
                    sb.append(BC).append(" ");
                    sb.append(OC).append(" ");
                    System.out.println(sb.toString());
                    sb = new StringBuilder();
                    sb.append("HRC:POINTS: ");
                    sb.append(O).append(" ");
                    sb.append(A.getLocation()).append(" ");
                    sb.append(B.getLocation()).append(" ");
                    sb.append(C.getLocation()).append(" ");
                    System.out.println(sb.toString());
                }
                if (OB > 250.0 && OC > OB) {
                    this.sequence = this.theIndex.get().recalibratePath(this.sequence, O);
                    if (this.sequence == null || this.discontinuityOccurred) {
                        this.takeAction("Restart Failed");
                        return null;
                    }
                    B = this.sequence.nextByTime(0.0);
                    C = this.sequence.peekByTime(this.timeEstimate);
                    this.takeAction("Discontinuity");
                    this.discontinuityOccurred = true;
                    if (B == null || C == null) {
                        return null;
                    }
                } else {
                    this.discontinuityOccurred = false;
                }
                MoveAlongAction a = new MoveAlongAction((ILocated)B.getLocation(), (ILocated)C.getLocation(), this.sequence.getJumpFlag() && B.getLocation().z - A.getLocation().z > 5.0);
                this.sequence.resetJumpFlag();
                return a;
            }
            if (Constants.VIEW_HRTC_MESSAGES.getBoolean()) {
                System.out.println("HRC: point(s) are null");
            }
            this.sequence = null;
            this.lastTime = 0.0;
            this.takeAction("Null Points");
            return null;
        }
        catch (Exception ex) {
            Logger.getLogger(HumanRetraceController.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public void reset() {
        if (this.theIndex.isDone() && this.sequence != null) {
            try {
                this.theIndex.get().putInTimeout(this.sequence, Constants.TRACE_TIME_OUT_DURATION.getInt());
            }
            catch (InterruptedException ex) {
                Logger.getLogger(HumanRetraceController.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(HumanRetraceController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.lastTime = 0.0;
        this.sequence = null;
    }

    public static void main(String[] args) throws PogamutException {
        new UT2004BotRunner(HumanRetraceBot.class, "HumanRetraceBot").startAgent();
    }
}

