/*
 * Decompiled with CFR 0.152.
 */
package edu.utexas.cs.nn.retrace;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import edu.utexas.cs.nn.Constants;
import edu.utexas.cs.nn.Point;
import edu.utexas.cs.nn.db.DbLogger;
import edu.utexas.cs.nn.retrace.NavpointRetraceLink;
import edu.utexas.cs.nn.retrace.PoseSequence;
import edu.utexas.cs.nn.retrace.VoronoiRegion;
import edu.wlu.cs.levy.CG.KDTree;
import edu.wlu.cs.levy.CG.KeyDuplicateException;
import edu.wlu.cs.levy.CG.KeySizeException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class SimpleNavPointIndex
extends DbLogger {
    List<PoseSequence> sequences = new LinkedList<PoseSequence>();
    KDTree<VoronoiRegion> kdRegions = new KDTree(3);
    Map<Integer, VoronoiRegion> idRegions = new HashMap<Integer, VoronoiRegion>();
    Map<Integer, NavpointRetraceLink> links = new HashMap<Integer, NavpointRetraceLink>();
    Map<PoseSequence, Integer> timeoutCorner = new HashMap<PoseSequence, Integer>();
    int size = 0;

    public SimpleNavPointIndex(String level) {
        level = level.toLowerCase();
        this.loadNavpoints(level);
        this.loadPose(level);
    }

    private int getLinkIndex(VoronoiRegion from, VoronoiRegion to) {
        return from.getId() * this.idRegions.size() + to.getId();
    }

    public NavpointRetraceLink getLink(Location a, Location b) {
        VoronoiRegion to;
        VoronoiRegion from = this.getNearestRegion(a);
        int linkIndex = this.getLinkIndex(from, to = this.getNearestRegion(b));
        if (this.links.containsKey(linkIndex)) {
            return this.links.get(linkIndex);
        }
        return null;
    }

    private void loadNavpoints(String level) {
        try {
            Class.forName("org.sqlite.JDBC");
            Connection navpointsConnection = DriverManager.getConnection("jdbc:sqlite:DATA/navpoints.db");
            Statement selectNavpoint = navpointsConnection.createStatement();
            selectNavpoint.execute("SELECT id, unreal_id, level, x, y, z FROM navpoint WHERE lower(level) = '" + level + "'");
            ResultSet rs = selectNavpoint.getResultSet();
            while (rs.next()) {
                int id = rs.getInt("id");
                String unreal_id = rs.getString("unreal_id");
                double x = rs.getDouble("x");
                double y = rs.getDouble("y");
                double z = rs.getDouble("z");
                this.idRegions.put(id, new VoronoiRegion(new Location(x, y, z), unreal_id, id));
            }
            navpointsConnection.close();
        }
        catch (ClassNotFoundException cnfe) {
            SimpleNavPointIndex.logException("Could not create SQLite DbRecoder: {0}", cnfe);
        }
        catch (SQLException sqle) {
            SimpleNavPointIndex.logException("Could not create SQLite DbRecorder", sqle);
        }
    }

    private void loadPose(final String level) {
        File traceHome = new File(Constants.HUMAN_DATA_PATH.get());
        File[] levelDirs = traceHome.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().toLowerCase().startsWith(level) && pathname.isDirectory();
            }
        });
        if (levelDirs == null) {
            System.err.println("Could not find any data in " + traceHome);
            SimpleNavPointIndex.getLogger().log(Level.SEVERE, "Could not find any data in {0}", traceHome);
        }
        for (File levelDir : levelDirs) {
            File[] dataFiles = levelDir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.getName().startsWith("segment") && pathname.getName().endsWith(".indexed.dat");
                }
            });
            if (dataFiles != null) {
                for (File dataFile : dataFiles) {
                    if (Constants.VIEW_HRTC_MESSAGES.getBoolean()) {
                        System.out.println(dataFile.getName());
                    }
                    try {
                        BufferedReader reader = new BufferedReader(new FileReader(dataFile));
                        this.sequences.addAll(PoseSequence.readSequences(reader));
                    }
                    catch (FileNotFoundException ex) {
                        SimpleNavPointIndex.getLogger().log(Level.SEVERE, "Data file not found", ex);
                    }
                    catch (IOException ioe) {
                        SimpleNavPointIndex.getLogger().log(Level.SEVERE, "Error while reading pose data file", ioe);
                    }
                }
            }
            if (!Constants.VIEW_HRTC_MESSAGES.getBoolean()) continue;
            System.out.println("done reading sequences: " + this.sequences.size() + " in dir " + levelDir);
        }
        for (PoseSequence seq : this.sequences) {
            if (seq.navpointIds.size() <= 1) continue;
            this.size += seq.size();
            for (Integer navpointId : seq.navpointIds.keySet()) {
                if (!this.idRegions.containsKey(navpointId)) continue;
                VoronoiRegion region = this.idRegions.get(navpointId);
                region.getPaths().add(seq);
            }
            if (!Constants.HUMAN_TRACE_PATH_CONTROLLER.getBoolean()) continue;
            for (int i = 0; i < seq.orderOfNavpoints.size() - 1; ++i) {
                int from = seq.orderOfNavpoints.get(i);
                int fromEntryPoint = seq.entryPoints.get(i);
                int fromExitPoint = seq.exitPoints.get(i);
                int startPoint = (fromEntryPoint + fromExitPoint) / 2;
                for (int j = i + 1; j < seq.orderOfNavpoints.size() - 1; ++j) {
                    NavpointRetraceLink oldLink;
                    int to = seq.orderOfNavpoints.get(j);
                    int toEntryPoint = seq.entryPoints.get(j);
                    int toExitPoint = seq.exitPoints.get(j);
                    int endPoint = (toEntryPoint + toExitPoint) / 2;
                    if (!this.idRegions.containsKey(from) || !this.idRegions.containsKey(to)) continue;
                    VoronoiRegion fromRegion = this.idRegions.get(from);
                    VoronoiRegion toRegion = this.idRegions.get(to);
                    NavpointRetraceLink link = NavpointRetraceLink.CreateLink(fromRegion, toRegion, seq, startPoint, endPoint);
                    int linkIndex = this.getLinkIndex(fromRegion, toRegion);
                    if (this.links.containsKey(linkIndex) && (oldLink = this.links.get(linkIndex)).getLength() <= link.getLength()) {
                        link = oldLink;
                    }
                    this.links.put(linkIndex, link);
                }
            }
            System.err.println("HRC:LINKS_ADDED: " + this.links.size());
        }
        for (VoronoiRegion region : this.idRegions.values()) {
            try {
                this.kdRegions.insert(region.getKey(), region);
            }
            catch (KeySizeException ex) {
                SimpleNavPointIndex.logException("KeySizeException", ex);
            }
            catch (KeyDuplicateException ex) {
                SimpleNavPointIndex.logException("KeyDuplicateException", ex);
            }
        }
    }

    public void printVoronoiCounts(PrintStream writer) {
        for (VoronoiRegion region : this.idRegions.values()) {
            writer.println("Voronoi region around " + region.getName() + " with id " + region.getId() + " intersects " + region.getPathCount() + " paths and " + region.getPointCount() + " points");
        }
    }

    private VoronoiRegion getNearestRegion(Location loc) {
        try {
            return this.kdRegions.nearest(new double[]{loc.x, loc.y, loc.z});
        }
        catch (KeySizeException ex) {
            return null;
        }
    }

    List<PoseSequence> getNearbyPaths(Location loc) {
        VoronoiRegion region = this.getNearestRegion(loc);
        if (region != null) {
            return region.getPaths();
        }
        return new LinkedList<PoseSequence>();
    }

    private void tickTimeoutCorner() {
        Iterator<Map.Entry<PoseSequence, Integer>> iterator = this.timeoutCorner.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<PoseSequence, Integer> entry = iterator.next();
            int countdown = entry.getValue() - 1;
            if (countdown < 1) {
                iterator.remove();
                continue;
            }
            entry.setValue(countdown);
        }
    }

    public void putInTimeout(PoseSequence seq, int timeout) {
        this.timeoutCorner.put(seq, timeout);
    }

    public void resetTimeout() {
        this.timeoutCorner.clear();
    }

    PoseSequence getClosestPath(Location loc) {
        this.tickTimeoutCorner();
        try {
            if (this.size() == 0) {
                System.err.println("Empty index!");
                return null;
            }
            if (this.kdRegions.size() == 0) {
                System.err.println("empty kdRegion");
                return null;
            }
            double[] key = new double[]{loc.x, loc.y, loc.z};
            VoronoiRegion region = this.kdRegions.nearest(key);
            PoseSequence bestPath = null;
            Point overallBestPoint = null;
            for (PoseSequence seq : region.getPaths()) {
                if (!this.timeoutCorner.containsKey(seq)) {
                    KDTree<Point> points = seq.getPointsInRegion(region.getId());
                    Point bestPoint = points.nearest(key);
                    if (bestPoint.getIndex() + 1 >= this.size()) continue;
                    if (overallBestPoint == null) {
                        overallBestPoint = bestPoint;
                        bestPath = seq;
                        continue;
                    }
                    if (!(overallBestPoint.getLocation().getDistance(loc) > bestPoint.getLocation().getDistance(loc)) || bestPoint.getIndex() >= seq.size() - 1) continue;
                    overallBestPoint = bestPoint;
                    bestPath = seq;
                    continue;
                }
                System.err.println("timeout: " + seq);
            }
            if (bestPath != null && overallBestPoint != null) {
                if (Constants.VIEW_HRTC_MESSAGES.getBoolean()) {
                    System.out.println("best path through " + overallBestPoint + " of length " + bestPath.size());
                }
                bestPath.jump(overallBestPoint.getIndex());
                return bestPath;
            }
            System.err.println("empty region: " + region.getName() + ", " + region.getPaths().size());
            return null;
        }
        catch (KeySizeException ex) {
            SimpleNavPointIndex.logException("Could not get closest path!", ex);
            return null;
        }
    }

    PoseSequence recalibratePath(PoseSequence seq, Location loc) {
        try {
            if (this.size() == 0) {
                return seq;
            }
            if (this.kdRegions.size() == 0) {
                return seq;
            }
            double[] key = new double[]{loc.x, loc.y, loc.z};
            VoronoiRegion region = this.kdRegions.nearest(key);
            KDTree<Point> points = seq.getPointsInRegion(region.getId());
            if (points.size() == 0) {
                return this.getClosestPath(loc);
            }
            Point bestPoint = points.nearest(key);
            if (bestPoint != null) {
                seq.jump(bestPoint.getIndex());
            }
            return seq;
        }
        catch (KeySizeException ex) {
            SimpleNavPointIndex.logException("Could not get closest path!", ex);
            return null;
        }
    }

    public int size() {
        return this.size;
    }

    public static void main(String[] args) {
        SimpleNavPointIndex index = new SimpleNavPointIndex("DM-Antalus");
        PoseSequence seq = index.sequences.get(Constants.random.nextInt(index.sequences.size()));
        Point p1 = seq.nextByTime(0.0);
        while (seq.hasNext()) {
            if (Constants.VIEW_HRTC_MESSAGES.getBoolean()) {
                System.out.println(p1);
            }
            Point p2a = seq.peekByDistance(100.0);
            Point p2b = seq.nextByDistance(100.0);
            if (Constants.VIEW_HRTC_MESSAGES.getBoolean()) {
                System.out.println(p2a + " :: " + p2b);
            }
            if (p2a != p2b) {
                throw new RuntimeException("peek and next ByDistance are not the same!");
            }
            Point p3a = seq.peekByTime(0.3);
            Point p3b = seq.nextByTime(0.3);
            if (Constants.VIEW_HRTC_MESSAGES.getBoolean()) {
                System.out.println(p3a + " :: " + p3b);
            }
            if (p3a == p3b) continue;
            throw new RuntimeException("peek and next ByTime are not the same!");
        }
    }
}

