/*
 * Decompiled with CFR 0.152.
 */
package edu.wlu.cs.levy.CG;

import edu.wlu.cs.levy.CG.Checker;
import edu.wlu.cs.levy.CG.DistanceMetric;
import edu.wlu.cs.levy.CG.Editor;
import edu.wlu.cs.levy.CG.EuclideanDistance;
import edu.wlu.cs.levy.CG.HPoint;
import edu.wlu.cs.levy.CG.HRect;
import edu.wlu.cs.levy.CG.HammingDistance;
import edu.wlu.cs.levy.CG.KDNode;
import edu.wlu.cs.levy.CG.KeyDuplicateException;
import edu.wlu.cs.levy.CG.KeyMissingException;
import edu.wlu.cs.levy.CG.KeySizeException;
import edu.wlu.cs.levy.CG.NearestNeighborList;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;

public class KDTree<T> {
    final long m_timeout;
    private final int m_K;
    private KDNode<T> m_root;
    private int m_count;

    public KDTree(int k) {
        this(k, 0L);
    }

    public KDTree(int k, long timeout) {
        this.m_timeout = timeout;
        this.m_K = k;
        this.m_root = null;
    }

    public void insert(double[] key, T value) throws KeySizeException, KeyDuplicateException {
        this.edit(key, new Editor.Inserter<T>(value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void edit(double[] key, Editor<T> editor) throws KeySizeException, KeyDuplicateException {
        if (key.length != this.m_K) {
            throw new KeySizeException();
        }
        KDTree kDTree = this;
        synchronized (kDTree) {
            if (null == this.m_root) {
                this.m_root = KDNode.create(new HPoint(key), editor);
                this.m_count = this.m_root.deleted ? 0 : 1;
                return;
            }
        }
        this.m_count += KDNode.edit(new HPoint(key), editor, this.m_root, 0, this.m_K);
    }

    public T search(double[] key) throws KeySizeException {
        if (key.length != this.m_K) {
            throw new KeySizeException();
        }
        KDNode<T> kd = KDNode.srch(new HPoint(key), this.m_root, this.m_K);
        return kd == null ? null : (T)kd.v;
    }

    public void delete(double[] key) throws KeySizeException, KeyMissingException {
        this.delete(key, false);
    }

    public void delete(double[] key, boolean optional) throws KeySizeException, KeyMissingException {
        if (key.length != this.m_K) {
            throw new KeySizeException();
        }
        KDNode<T> t = KDNode.srch(new HPoint(key), this.m_root, this.m_K);
        if (t == null) {
            if (!optional) {
                throw new KeyMissingException();
            }
        } else if (KDNode.del(t)) {
            --this.m_count;
        }
    }

    public T nearest(double[] key) throws KeySizeException {
        List<T> nbrs = this.nearest(key, 1, null);
        return nbrs.get(0);
    }

    public List<T> nearest(double[] key, int n) throws KeySizeException, IllegalArgumentException {
        return this.nearest(key, n, null);
    }

    public List<T> nearestEuclidean(double[] key, double dist) throws KeySizeException {
        return this.nearestDistance(key, dist, new EuclideanDistance());
    }

    public List<T> nearestHamming(double[] key, double dist) throws KeySizeException {
        return this.nearestDistance(key, dist, new HammingDistance());
    }

    public List<T> nearest(double[] key, int n, Checker<T> checker) throws KeySizeException, IllegalArgumentException {
        if (n <= 0) {
            return new LinkedList();
        }
        NearestNeighborList<KDNode<T>> nnl = this.getnbrs(key, n, checker);
        n = nnl.getSize();
        Stack nbrs = new Stack();
        for (int i = 0; i < n; ++i) {
            KDNode<T> kd = nnl.removeHighest();
            nbrs.push(kd.v);
        }
        return nbrs;
    }

    public List<T> range(double[] lowk, double[] uppk) throws KeySizeException {
        if (lowk.length != uppk.length) {
            throw new KeySizeException();
        }
        if (lowk.length != this.m_K) {
            throw new KeySizeException();
        }
        LinkedList found = new LinkedList();
        KDNode.rsearch(new HPoint(lowk), new HPoint(uppk), this.m_root, 0, this.m_K, found);
        LinkedList o = new LinkedList();
        for (KDNode kDNode : found) {
            o.add(kDNode.v);
        }
        return o;
    }

    public int size() {
        return this.m_count;
    }

    public String toString() {
        return this.m_root.toString(0);
    }

    private NearestNeighborList<KDNode<T>> getnbrs(double[] key) throws KeySizeException {
        return this.getnbrs(key, this.m_count, null);
    }

    private NearestNeighborList<KDNode<T>> getnbrs(double[] key, int n, Checker<T> checker) throws KeySizeException {
        if (key.length != this.m_K) {
            throw new KeySizeException();
        }
        NearestNeighborList<KDNode<T>> nnl = new NearestNeighborList<KDNode<T>>(n);
        HRect hr = HRect.infiniteHRect(key.length);
        double max_dist_sqd = Double.MAX_VALUE;
        HPoint keyp = new HPoint(key);
        if (this.m_count > 0) {
            long timeout = this.m_timeout > 0L ? System.currentTimeMillis() + this.m_timeout : 0L;
            KDNode.nnbr(this.m_root, keyp, hr, max_dist_sqd, 0, this.m_K, nnl, checker, timeout);
        }
        return nnl;
    }

    private List<T> nearestDistance(double[] key, double dist, DistanceMetric metric) throws KeySizeException {
        NearestNeighborList<KDNode<T>> nnl = this.getnbrs(key);
        int n = nnl.getSize();
        Stack nbrs = new Stack();
        for (int i = 0; i < n; ++i) {
            KDNode<T> kd = nnl.removeHighest();
            HPoint p = kd.k;
            if (!(metric.distance(kd.k.coord, key) < dist)) continue;
            nbrs.push(kd.v);
        }
        return nbrs;
    }
}

