/*
 * Decompiled with CFR 0.152.
 */
package machinelearning.networks;

import java.io.Serializable;
import java.util.Random;
import machinelearning.evolution.evolvables.Evolvable;
import machinelearning.networks.FunctionApproximator;

public class MLP
implements Evolvable,
Serializable,
FunctionApproximator {
    protected double[][] firstConnectionLayer;
    protected double[][] secondConnectionLayer;
    protected double[] hiddenNeurons;
    protected double[] inputs;
    protected double[] outputs;
    protected double mutationMagnitude = 0.1;
    public double learningRate = 0.1;
    private final Random random = new Random();

    public MLP(int numberOfInputs, int numberOfHidden, int numberOfOutputs) {
        this.inputs = new double[numberOfInputs];
        this.firstConnectionLayer = new double[numberOfInputs][numberOfHidden];
        this.secondConnectionLayer = new double[numberOfHidden][numberOfOutputs];
        this.hiddenNeurons = new double[numberOfHidden];
        this.outputs = new double[numberOfOutputs];
    }

    public MLP(double[][] firstConnectionLayer, double[][] secondConnectionLayer, int numberOfHidden, int numberOfOutputs) {
        this.inputs = new double[firstConnectionLayer.length];
        this.firstConnectionLayer = firstConnectionLayer;
        this.secondConnectionLayer = secondConnectionLayer;
        this.hiddenNeurons = new double[numberOfHidden];
        this.outputs = new double[numberOfOutputs];
    }

    @Override
    public double[] propagate(double[] inputIn) {
        if (this.inputs == null) {
            this.inputs = new double[inputIn.length];
        }
        if (this.inputs != inputIn) {
            if (inputIn.length > this.inputs.length) {
                System.out.println("MLP given " + inputIn.length + " inputs, but only intialized for " + this.inputs.length);
            }
            System.arraycopy(inputIn, 0, this.inputs, 0, inputIn.length);
        }
        if (inputIn.length < this.inputs.length) {
            System.out.println("NOTE: only " + inputIn.length + " inputs out of " + this.inputs.length + " are used in the network");
        }
        this.clear(this.hiddenNeurons);
        this.clear(this.outputs);
        this.propagateOneStep(this.inputs, this.hiddenNeurons, this.firstConnectionLayer);
        this.tanh(this.hiddenNeurons);
        this.propagateOneStep(this.hiddenNeurons, this.outputs, this.secondConnectionLayer);
        this.tanh(this.outputs);
        return this.outputs;
    }

    @Override
    public Evolvable getNewInstance() {
        MLP newRMLP = new MLP(this.firstConnectionLayer.length, this.hiddenNeurons.length, this.outputs.length);
        newRMLP.initializeAllLayersRandom();
        return newRMLP;
    }

    public void initializeAllLayersRandom() {
        this.initializeRandom(this.firstConnectionLayer);
        this.initializeRandom(this.secondConnectionLayer);
    }

    private void initializeRandom(double[][] layer) {
        for (int i = 0; i < layer.length; ++i) {
            for (int j = 0; j < layer[i].length; ++j) {
                layer[i][j] = this.random.nextDouble() * 2.0 - 1.0;
            }
        }
    }

    @Override
    public MLP copy() {
        return new MLP(this.copy(this.firstConnectionLayer), this.copy(this.secondConnectionLayer), this.hiddenNeurons.length, this.outputs.length);
    }

    @Override
    public void mutate() {
        this.mutate(this.firstConnectionLayer);
        this.mutate(this.secondConnectionLayer);
    }

    @Override
    public void reset() {
    }

    protected double[][] copy(double[][] original) {
        double[][] copy = new double[original.length][original[0].length];
        for (int i = 0; i < original.length; ++i) {
            System.arraycopy(original[i], 0, copy[i], 0, original[i].length);
        }
        return copy;
    }

    protected void mutate(double[] array) {
        int i = 0;
        while (i < array.length) {
            int n = i++;
            array[n] = array[n] + this.random.nextGaussian() * this.mutationMagnitude;
        }
    }

    protected void mutate(double[][] array) {
        for (int i = 0; i < array.length; ++i) {
            this.mutate(array[i]);
        }
    }

    protected void propagateOneStep(double[] fromLayer, double[] toLayer, double[][] connections) {
        for (int from = 0; from < fromLayer.length; ++from) {
            for (int to = 0; to < toLayer.length; ++to) {
                int n = to;
                toLayer[n] = toLayer[n] + fromLayer[from] * connections[from][to];
            }
        }
    }

    protected void clear(double[] array) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = 0.0;
        }
    }

    protected void tanh(double[] array) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = Math.tanh(array[i]);
        }
    }

    public double sum() {
        int j;
        int i;
        double sum = 0.0;
        for (i = 0; i < this.firstConnectionLayer.length; ++i) {
            for (j = 0; j < this.firstConnectionLayer[i].length; ++j) {
                sum += this.firstConnectionLayer[i][j];
            }
        }
        for (i = 0; i < this.secondConnectionLayer.length; ++i) {
            for (j = 0; j < this.secondConnectionLayer[i].length; ++j) {
                sum += this.secondConnectionLayer[i][j];
            }
        }
        return sum;
    }

    public void println() {
        int j;
        int i;
        System.out.print("\n\n---------------------------------------------------------------------------------------\n");
        for (i = 0; i < this.firstConnectionLayer.length; ++i) {
            System.out.print("|");
            for (j = 0; j < this.firstConnectionLayer[i].length; ++j) {
                System.out.print(" " + this.firstConnectionLayer[i][j]);
            }
            System.out.print(" |\n");
        }
        System.out.print("---------------------------------------------------------------------------------------\n");
        for (i = 0; i < this.secondConnectionLayer.length; ++i) {
            System.out.print("|");
            for (j = 0; j < this.secondConnectionLayer[i].length; ++j) {
                System.out.print(" " + this.secondConnectionLayer[i][j]);
            }
            System.out.print(" |\n");
        }
        System.out.print("---------------------------------------------------------------------------------------\n");
    }

    private double dtanh(double num) {
        return 1.0 - num * num;
    }

    public double backPropagate(double[] targetOutputs) {
        double saveAway;
        int hidden;
        double[] outputError = new double[this.outputs.length];
        for (int i = 0; i < this.outputs.length; ++i) {
            outputError[i] = this.dtanh(this.outputs[i]) * (targetOutputs[i] - this.outputs[i]);
            if (!Double.isNaN(outputError[i])) continue;
            System.out.println("Problem at output " + i);
            System.out.println(this.outputs[i] + " " + targetOutputs[i]);
            System.exit(0);
        }
        double[] hiddenError = new double[this.hiddenNeurons.length];
        for (hidden = 0; hidden < this.hiddenNeurons.length; ++hidden) {
            double contributionToOutputError = 0.0;
            for (int toOutput = 0; toOutput < this.outputs.length; ++toOutput) {
                contributionToOutputError += this.secondConnectionLayer[hidden][toOutput] * outputError[toOutput];
            }
            hiddenError[hidden] = this.dtanh(this.hiddenNeurons[hidden]) * contributionToOutputError;
        }
        for (int input = 0; input < this.inputs.length; ++input) {
            for (int hidden2 = 0; hidden2 < this.hiddenNeurons.length; ++hidden2) {
                saveAway = this.firstConnectionLayer[input][hidden2];
                double[] dArray = this.firstConnectionLayer[input];
                int n = hidden2;
                dArray[n] = dArray[n] + this.learningRate * hiddenError[hidden2] * this.inputs[input];
                if (!Double.isNaN(this.firstConnectionLayer[input][hidden2])) continue;
                System.out.println("Late weight error! hiddenError " + hiddenError[hidden2] + " input " + this.inputs[input] + " was " + saveAway);
            }
        }
        for (hidden = 0; hidden < this.hiddenNeurons.length; ++hidden) {
            for (int output = 0; output < this.outputs.length; ++output) {
                saveAway = this.secondConnectionLayer[hidden][output];
                double[] dArray = this.secondConnectionLayer[hidden];
                int n = output;
                dArray[n] = dArray[n] + this.learningRate * outputError[output] * this.hiddenNeurons[hidden];
                if (!Double.isNaN(this.secondConnectionLayer[hidden][output])) continue;
                System.out.println("target: " + targetOutputs[output] + " outputs: " + this.outputs[output] + " error:" + outputError[output] + "\n" + "hidden: " + this.hiddenNeurons[hidden] + "\nnew conn weight: " + this.secondConnectionLayer[hidden][output] + " was: " + saveAway + "\n");
            }
        }
        double summedOutputError = 0.0;
        for (int k = 0; k < this.outputs.length; ++k) {
            summedOutputError += Math.abs(targetOutputs[k] - this.outputs[k]);
        }
        return summedOutputError /= (double)this.outputs.length;
    }

    public String info() {
        int numberOfConnections = this.firstConnectionLayer.length * this.firstConnectionLayer[0].length + this.secondConnectionLayer.length * this.secondConnectionLayer[0].length;
        return "Straight mlp, mean connection weight " + this.sum() / (double)numberOfConnections;
    }

    @Override
    public String toString() {
        return "MLP:" + this.firstConnectionLayer.length + "/" + this.secondConnectionLayer.length + "/" + this.outputs.length;
    }

    @Override
    public int getNumberOfInputs() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getNumberOfOutputs() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

