/*
 * Decompiled with CFR 0.152.
 */
package machinelearning.networks;

import java.util.Hashtable;
import java.util.Vector;
import machinelearning.evolution.evolvables.Evolvable;
import machinelearning.networks.MultiModalTWEANN;
import machinelearning.networks.TWEANN;

public class MultiWeaponTWEANN
extends MultiModalTWEANN {
    private Hashtable<String, Integer> weaponToModeMap;
    private transient String currentWeapon;

    @Override
    public Evolvable getNewInstance() {
        TWEANN net = (TWEANN)super.getNewInstance();
        Hashtable<String, Integer> onlyWeaponMode = new Hashtable<String, Integer>();
        onlyWeaponMode.put("XWeapons.AssaultRiflePickup", 0);
        return new MultiWeaponTWEANN(net, net.getNumberOfOutputs(), 1, onlyWeaponMode);
    }

    private MultiWeaponTWEANN(TWEANN net, int outputWidth, int numModes, Hashtable<String, Integer> weaponToModeMap) {
        this(net.allnodes, net.genes, net.net_id, outputWidth, numModes, weaponToModeMap);
    }

    public MultiWeaponTWEANN(int numInputs, int numOutputs, boolean featureSelective, String firstWeapon) {
        super(numInputs, numOutputs, featureSelective);
        this.weaponToModeMap = new Hashtable();
        this.weaponToModeMap.put(firstWeapon, 0);
    }

    public MultiWeaponTWEANN(Vector<TWEANN.NNode> in, Vector<TWEANN.NNode> out, Vector<TWEANN.NNode> all, int xnet_id, Vector<TWEANN.Gene> _genes, int outputWidth, int numModes, Hashtable<String, Integer> weaponToModeMap) {
        super(in, out, all, xnet_id, _genes, outputWidth, numModes);
        this.weaponToModeMap = (Hashtable)weaponToModeMap.clone();
    }

    public MultiWeaponTWEANN(Vector<TWEANN.NNode> all, Vector<TWEANN.Gene> _genes, int xnet_id, int outputWidth, int numModes, Hashtable<String, Integer> weaponToModeMap) {
        super(all, _genes, xnet_id, outputWidth, numModes);
        this.weaponToModeMap = (Hashtable)weaponToModeMap.clone();
    }

    @Override
    public TWEANN duplicateWithNewID() {
        return new MultiWeaponTWEANN(super.duplicateWithNewID(), this.outputWidth, this.numModes, this.weaponToModeMap);
    }

    public void setCurrentWeapon(String currentWeapon) {
        this.currentWeapon = currentWeapon;
    }

    @Override
    public double[] propagate(double[] doubles) {
        int bestMode = 0;
        boolean known = this.weaponToModeMap.containsKey(this.currentWeapon);
        if (!known) {
            bestMode = this.add_output_mode();
            this.weaponToModeMap.put(this.currentWeapon, bestMode);
        } else {
            bestMode = this.weaponToModeMap.get(this.currentWeapon);
        }
        double[] fullOutput = this.processInputsToOutputs(doubles);
        double[] modeOutput = new double[this.outputWidth];
        for (int x = 0; x < this.outputWidth; ++x) {
            modeOutput[x] = fullOutput[bestMode * this.outputWidth + x];
        }
        this.modeHistory.set(bestMode, (Integer)this.modeHistory.get(bestMode) + 1);
        return modeOutput;
    }

    public int add_output_mode() {
        for (int i = 0; i < this.outputWidth; ++i) {
            this.addOutputNode();
        }
        int result = this.numModes++;
        this.modeHistory.add(0);
        return result;
    }

    @Override
    public boolean deleteOutputMode(int mode) {
        int start = this.firstOutputOfMode(mode);
        boolean result = true;
        for (int i = this.outputWidth - 1; i >= 0; --i) {
            int id = ((TWEANN.NNode)this.outputs.get((int)(start + i))).node_id;
            result = result && this.deleteOutputNode(id);
        }
        return result;
    }

    private int firstOutputOfMode(int mode) {
        return mode * this.outputWidth;
    }

    @Override
    public void mutate() {
        super.mutate(false);
    }
}

