/*
 * Decompiled with CFR 0.152.
 */
package machinelearning.networks;

import java.io.Serializable;
import java.util.Random;
import machinelearning.Tools;
import machinelearning.evolution.evolvables.Evolvable;
import machinelearning.networks.FunctionApproximator;
import utopia.Utils;

public class RMLP
implements Evolvable,
Serializable,
FunctionApproximator {
    protected double[][] firstConnectionLayer;
    protected double[][] recurrentConnectionLayer;
    protected double[][] secondConnectionLayer;
    protected double[] hiddenNeurons;
    protected double[] hiddenNeuronsCopy;
    protected double[] outputs;
    protected double mutationMagnitude = 0.01;
    private final Random random = new Random();

    public RMLP(int numberOfInputs, int numberOfHidden, int numberOfOutputs) {
        this.firstConnectionLayer = new double[numberOfInputs][numberOfHidden];
        this.recurrentConnectionLayer = new double[numberOfHidden][numberOfHidden];
        this.secondConnectionLayer = new double[numberOfHidden][numberOfOutputs];
        this.hiddenNeurons = new double[numberOfHidden];
        this.hiddenNeuronsCopy = new double[numberOfHidden];
        this.outputs = new double[numberOfOutputs];
    }

    public RMLP(int numberOfInputs, int numberOfHidden, int numberOfOutputs, double mutationMagnitude) {
        this(numberOfInputs, numberOfHidden, numberOfOutputs);
        this.mutationMagnitude = mutationMagnitude;
    }

    public RMLP(double[][] firstConnectionLayer, double[][] recurrentConnectionLayer, double[][] secondConnectionLayer, int numberOfHidden, int numberOfOutputs) {
        this.firstConnectionLayer = firstConnectionLayer;
        this.recurrentConnectionLayer = recurrentConnectionLayer;
        this.secondConnectionLayer = secondConnectionLayer;
        this.hiddenNeurons = new double[numberOfHidden];
        this.hiddenNeuronsCopy = new double[numberOfHidden];
        this.outputs = new double[numberOfOutputs];
    }

    @Override
    public double[] propagate(double[] inputs) {
        System.arraycopy(this.hiddenNeurons, 0, this.hiddenNeuronsCopy, 0, this.hiddenNeurons.length);
        this.clear(this.hiddenNeurons);
        this.clear(this.outputs);
        this.propagateOneStep(inputs, this.hiddenNeurons, this.firstConnectionLayer);
        this.propagateOneStep(this.hiddenNeuronsCopy, this.hiddenNeurons, this.recurrentConnectionLayer);
        this.tanh(this.hiddenNeurons);
        this.propagateOneStep(this.hiddenNeurons, this.outputs, this.secondConnectionLayer);
        this.tanh(this.outputs);
        return this.outputs;
    }

    @Override
    public RMLP copy() {
        RMLP mlpcopy = new RMLP(Tools.copyArray(this.firstConnectionLayer), Tools.copyArray(this.recurrentConnectionLayer), Tools.copyArray(this.secondConnectionLayer), this.hiddenNeurons.length, this.outputs.length);
        return mlpcopy;
    }

    @Override
    public void mutate() {
        this.mutate(this.firstConnectionLayer);
        this.mutate(this.recurrentConnectionLayer);
        this.mutate(this.secondConnectionLayer);
    }

    @Override
    public void reset() {
        this.clear(this.hiddenNeurons);
        this.clear(this.hiddenNeuronsCopy);
    }

    protected void mutate(double[] array) {
        int i = 0;
        while (i < array.length) {
            int n = i++;
            array[n] = array[n] + Utils.randomCauchy(this.mutationMagnitude);
        }
    }

    protected void mutate(double[][] array) {
        for (int i = 0; i < array.length; ++i) {
            this.mutate(array[i]);
        }
    }

    protected void propagateOneStep(double[] fromLayer, double[] toLayer, double[][] connections) {
        for (int from = 0; from < fromLayer.length; ++from) {
            for (int to = 0; to < toLayer.length; ++to) {
                int n = to;
                toLayer[n] = toLayer[n] + fromLayer[from] * connections[from][to];
            }
        }
    }

    protected void clear(double[] array) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = 0.0;
        }
    }

    protected void tanh(double[] array) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = Math.tanh(array[i]);
        }
    }

    public double sum() {
        int j;
        int i;
        double sum = 0.0;
        for (i = 0; i < this.firstConnectionLayer.length; ++i) {
            for (j = 0; j < this.firstConnectionLayer[i].length; ++j) {
                sum += this.firstConnectionLayer[i][j];
            }
        }
        for (i = 0; i < this.recurrentConnectionLayer.length; ++i) {
            for (j = 0; j < this.recurrentConnectionLayer[i].length; ++j) {
                sum += this.recurrentConnectionLayer[i][j];
            }
        }
        for (i = 0; i < this.secondConnectionLayer.length; ++i) {
            for (j = 0; j < this.secondConnectionLayer[i].length; ++j) {
                sum += this.secondConnectionLayer[i][j];
            }
        }
        return sum;
    }

    public String info() {
        int numberOfConnections = this.firstConnectionLayer.length * this.firstConnectionLayer[0].length + this.recurrentConnectionLayer.length * this.recurrentConnectionLayer[0].length + this.secondConnectionLayer.length * this.secondConnectionLayer[0].length;
        return "Recurrent mlp, mean connection weight " + this.sum() / (double)numberOfConnections;
    }

    public void show(String title, String[][] s) {
    }

    @Override
    public String toString() {
        return "RecurrentMLP:" + this.firstConnectionLayer.length + "/" + this.secondConnectionLayer.length + "/" + this.outputs.length;
    }

    @Override
    public Evolvable getNewInstance() {
        RMLP newRMLP = new RMLP(this.firstConnectionLayer.length, this.hiddenNeurons.length, this.outputs.length);
        newRMLP.initializeAllLayersRandom();
        return newRMLP;
    }

    public void initializeAllLayersRandom() {
        this.initializeRandom(this.firstConnectionLayer);
        this.initializeRandom(this.recurrentConnectionLayer);
        this.initializeRandom(this.secondConnectionLayer);
    }

    private void initializeRandom(double[][] layer) {
        for (int i = 0; i < layer.length; ++i) {
            for (int j = 0; j < layer[i].length; ++j) {
                layer[i][j] = this.random.nextDouble() * 2.0 - 1.0;
            }
        }
    }

    @Override
    public int getNumberOfInputs() {
        return this.firstConnectionLayer.length;
    }

    public double getMutationMagnitude() {
        return this.mutationMagnitude;
    }

    public void setMutationMagnitude(double mutationMagnitude) {
        this.mutationMagnitude = mutationMagnitude;
    }

    @Override
    public int getNumberOfOutputs() {
        return this.outputs.length;
    }
}

