/*
 * Decompiled with CFR 0.152.
 */
package mockcz.cuni.amis.pogamut.base.agent.navigation;

import cz.cuni.amis.pogamut.base.agent.navigation.IPathFuture;
import cz.cuni.amis.pogamut.base.agent.navigation.IPathPlanner;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.floydwarshall.FloydWarshallMap;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import mockcz.cuni.pogamut.Client.AgentBody;

public class PathPlanner
implements IPathPlanner<ILocated> {
    private IPathPlanner<ILocated> planner;
    private final AgentBody body;
    private final FloydWarshallMap fwMap;
    public static final double SAFE_FLOYD_WARSHALL_START_DISTANCE = 200.0;

    public PathPlanner(IPathPlanner<ILocated> planner, FloydWarshallMap fwMap, AgentBody body) {
        this.planner = planner;
        this.fwMap = fwMap;
        this.body = body;
    }

    public IPathFuture<ILocated> computePath(ILocated to) {
        Location start = this.body.info.getLocation();
        if (start != null) {
            return this.computePath((ILocated)start, to);
        }
        return null;
    }

    public IPathFuture<NavPoint> computePath(NavPoint to) {
        NavPoint nearest = this.body.info.getNearestVisibleNavPoint();
        Location start = this.body.info.getLocation();
        if (nearest != null && start != null && start.getDistance(nearest.getLocation()) < 200.0) {
            return this.computePath(nearest, to);
        }
        return null;
    }

    public IPathFuture<NavPoint> computePath(NavPoint from, NavPoint to) {
        return this.fwMap.computePath(from, to);
    }

    public IPathFuture<ILocated> computePath(ILocated from, ILocated to) {
        return this.planner.computePath((Object)from, (Object)to);
    }
}

