/*
 * Decompiled with CFR 0.152.
 */
package mockcz.cuni.pogamut.Client;

import cz.cuni.amis.pogamut.base.communication.command.IAct;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base3d.worldview.IVisionWorldView;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.base3d.worldview.object.Velocity;
import cz.cuni.amis.pogamut.ut2004.agent.module.logic.SyncUT2004BotLogic;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.Raycasting;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.Weapon;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.Weaponry;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.Game;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.Items;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.Senses;
import cz.cuni.amis.pogamut.ut2004.bot.command.CompleteBotCommandsWrapper;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Configuration;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.RemoveRay;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.AutoTraceRay;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.utils.flag.FlagListener;
import java.util.ArrayList;
import java.util.Map;
import javax.vecmath.Vector3d;
import mockcz.cuni.pogamut.MessageObjects.Triple;
import utopia.Utils;

public class AgentBody {
    public static final double MAX_DISTANCE_NOISE = 5.0;
    public final CompleteBotCommandsWrapper body;
    public final Raycasting raycasting;
    public ArrayList<String> autoTraceIds;
    public ArrayList<AutoTraceRay> rays;
    public final IAct act;
    private boolean pendingAutoTraceEnable;
    public final SyncUT2004BotLogic logic;
    public final AgentInfo info;
    public final Senses senses;
    public final Game game;
    public final IVisionWorldView world;
    public final Items items;
    public final Weaponry weaponry;
    private int shockOrbsToBeams = 0;
    public static final double CLOSE_WALL_DISTANCE = 150.0;
    public double lastDodgeTime = 0.0;
    private Integer leftRayID = null;
    private Integer rightRayID = null;
    private Integer backRayID = null;
    private Integer frontRayID = null;
    protected ArrayList<Integer> levelRays = new ArrayList();

    public AgentBody(CompleteBotCommandsWrapper body, Raycasting raycasting, IAct act, SyncUT2004BotLogic logic, AgentInfo info, Senses senses, Game game, IVisionWorldView world, Items items, Weaponry weaponry) {
        this.body = body;
        this.raycasting = raycasting;
        this.act = act;
        this.autoTraceIds = new ArrayList();
        this.rays = new ArrayList();
        this.pendingAutoTraceEnable = false;
        this.logic = logic;
        this.info = info;
        this.senses = senses;
        this.game = game;
        this.world = world;
        this.items = items;
        this.weaponry = weaponry;
    }

    public boolean isGetCloseWeapon(Weapon w) {
        return w != null && (w.getType().equals((Object)ItemType.ASSAULT_RIFLE) || w.getType().equals((Object)ItemType.FLAK_CANNON) || w.getType().equals((Object)ItemType.BIO_RIFLE));
    }

    public boolean isSecondaryChargingWeapon(Weapon w) {
        return w != null && (w.getType().equals((Object)ItemType.ASSAULT_RIFLE) || w.getType().equals((Object)ItemType.ROCKET_LAUNCHER) || w.getType().equals((Object)ItemType.BIO_RIFLE));
    }

    public boolean isAutomaticWeaponShooting(Weapon w) {
        return w != null && (w.getType().equals((Object)ItemType.ASSAULT_RIFLE) && this.info.isPrimaryShooting() != false || w.getType().equals((Object)ItemType.MINIGUN) && this.info.isShooting() != false);
    }

    public boolean usingSnipingWeapon() {
        return this.isSnipingWeapon(this.weaponry.getCurrentWeapon());
    }

    public boolean isSnipingWeapon(Weapon w) {
        return w != null && this.isSnipingWeapon(w.getType());
    }

    boolean isSnipingWeapon(ItemType type) {
        return type != null && (type.equals((Object)ItemType.SNIPER_RIFLE) || type.equals((Object)ItemType.LIGHTNING_GUN));
    }

    public boolean isSplashDamageWeapon(Weapon w) {
        return w != null && (w.getType().equals((Object)ItemType.ROCKET_LAUNCHER) || w.getType().equals((Object)ItemType.FLAK_CANNON) || w.getType().equals((Object)ItemType.SHOCK_RIFLE) || w.getType().equals((Object)ItemType.BIO_RIFLE));
    }

    public boolean usingSplashDamageWeapon() {
        return this.isSplashDamageWeapon(this.weaponry.getCurrentWeapon());
    }

    public void shootAlternate(Triple shootTarget) {
        this.body.getShooting().shootSecondary((ILocated)shootTarget);
    }

    public void shootAlternate(Player enemy, boolean perfect, Triple adjust, double chargeTime, double aimVelDiffDistortion, double aimRandomDistortion) {
        Weapon w = this.weaponry.getCurrentWeapon();
        if (w != null && w.getType().equals((Object)ItemType.SHOCK_RIFLE)) {
            ++this.shockOrbsToBeams;
        }
        if (this.isSecondaryChargingWeapon(w)) {
            if (this.info.isSecondaryShooting().booleanValue()) {
                return;
            }
            this.body.getShooting().shootSecondaryCharged(enemy, chargeTime);
        }
        this.targetCheck(enemy);
        if (perfect) {
            this.body.getShooting().shootSecondary(enemy);
        } else if (adjust == null) {
            this.shootAlternate(this.getImperfectTarget(enemy, aimVelDiffDistortion, aimRandomDistortion));
        } else {
            Triple target = Triple.locationToTriple(enemy.getLocation());
            this.shootAlternate(Triple.add(target, adjust));
        }
    }

    public double verticalAngleToTarget(Location target) {
        Location bot = this.info.getLocation();
        Location toTarget = target.sub(bot);
        Vector3d vectorToTarget = new Vector3d(toTarget.x, toTarget.y, toTarget.z);
        Location targetLevel = new Location(target.x, target.y, bot.z);
        Location toLevel = targetLevel.sub(bot);
        Vector3d vectorToLevel = new Vector3d(toLevel.x, toLevel.y, toLevel.z);
        return vectorToLevel.angle(vectorToTarget);
    }

    public void shoot(Triple shootTarget) {
        this.body.getShooting().shootPrimary((ILocated)shootTarget);
    }

    public void shoot(Player enemy, boolean perfect, Triple adjust, double aimVelDiffDistortion, double aimRandomDistortion) {
        Weapon w = this.weaponry.getCurrentWeapon();
        if (w != null && w.getType().equals((Object)ItemType.SHOCK_RIFLE)) {
            --this.shockOrbsToBeams;
        }
        if (this.isSecondaryChargingWeapon(w) && this.info.isSecondaryShooting().booleanValue()) {
            return;
        }
        this.targetCheck(enemy);
        if (perfect) {
            this.body.getShooting().shootPrimary(enemy);
        } else if (adjust == null) {
            this.shoot(this.getImperfectTarget(enemy, aimVelDiffDistortion, aimRandomDistortion));
        } else {
            Triple target = this.getImperfectTarget(enemy, aimVelDiffDistortion, aimRandomDistortion);
            this.shoot(Triple.add(target, adjust));
        }
    }

    private Triple getImperfectTarget(Player enemy, double aimVelDiffDistortion, double aimRandomDistortion) {
        Triple agent = Triple.locationToTriple(this.info.getLocation());
        Triple target = Triple.locationToTriple(enemy.getLocation());
        double distance = agent == null ? 2501.0 : Triple.distanceInSpace(agent, target);
        Velocity enemyVelocity = enemy.getVelocity();
        Velocity myVelocity = this.info.getVelocity();
        if (enemyVelocity != null && myVelocity != null && !enemyVelocity.isZero(5.0)) {
            double distanceNoiseMultiplier = this.noiseForDistance(distance);
            target.x += aimRandomDistortion * (double)Utils.randposneg() * Utils.randomFloat() * distanceNoiseMultiplier + (double)Utils.randposneg() * Utils.randomFloat() * distanceNoiseMultiplier * (Math.abs(enemyVelocity.x - myVelocity.x) / aimVelDiffDistortion);
            target.y += aimRandomDistortion * (double)Utils.randposneg() * Utils.randomFloat() * distanceNoiseMultiplier + (double)Utils.randposneg() * Utils.randomFloat() * distanceNoiseMultiplier * (Math.abs(enemyVelocity.y - myVelocity.y) / aimVelDiffDistortion);
            if (!this.usingSplashDamageWeapon()) {
                target.z += aimRandomDistortion * Utils.randomFloat() * distanceNoiseMultiplier + (double)Utils.randposneg() * Utils.randomFloat() * distanceNoiseMultiplier * (Math.abs(enemyVelocity.z - myVelocity.z) / aimVelDiffDistortion);
            }
        }
        return target;
    }

    private double noiseForDistance(double distance) {
        if (distance > 2500.0) {
            return 5.0;
        }
        return distance * distance / 6250000.0 * 5.0;
    }

    public void stopShoot() {
        this.stopShoot(false);
    }

    public void stopShoot(boolean force) {
        Weapon w = this.weaponry.getCurrentWeapon();
        if (force || !this.isSecondaryChargingWeapon(w) || !this.info.isSecondaryShooting().booleanValue() || this.weaponry.getCurrentAlternateAmmo() <= 1) {
            this.body.getShooting().stopShoot();
        }
    }

    public void stop() {
        this.body.getLocomotion().stopMovement();
    }

    public void turnHorizontal(int i) {
        this.body.getLocomotion().turnHorizontal(i);
    }

    public void strafeToLocation(Triple target, Triple lookAt, double DUMMY) {
        this.body.getLocomotion().strafeTo((ILocated)target, (ILocated)lookAt);
    }

    public void contMove() {
        this.contMove(0.0f);
    }

    public void contMove(float DUMMY) {
        this.body.getLocomotion().moveContinuos();
    }

    public void removeAllRaysFromAutoTrace() {
        this.act.act((CommandMessage)new RemoveRay("All"));
    }

    public boolean sideWallClose(boolean left) {
        if (this.leftRayID == null || this.rightRayID == null) {
            return false;
        }
        int id = left ? this.leftRayID : this.rightRayID;
        return this.closeWallAlongRay(id);
    }

    public boolean backWallClose() {
        if (this.backRayID == null) {
            return false;
        }
        return this.closeWallAlongRay(this.backRayID);
    }

    public boolean frontWallClose() {
        if (this.frontRayID == null) {
            return false;
        }
        return this.closeWallAlongRay(this.frontRayID);
    }

    public boolean veryCloseFrontWall() {
        if (this.frontRayID == null) {
            return false;
        }
        return this.closeWallAlongRay(this.frontRayID, 50.0);
    }

    private boolean closeWallAlongRay(int id) {
        return this.closeWallAlongRay(id, 150.0);
    }

    public AutoTraceRay frontRayTrace() {
        if (this.frontRayID == null) {
            return null;
        }
        if (!((Boolean)this.raycasting.getAllRaysInitialized().getFlag()).booleanValue()) {
            return null;
        }
        return this.rays.get(this.frontRayID);
    }

    private boolean closeWallAlongRay(int id, double distance) {
        if (!((Boolean)this.raycasting.getAllRaysInitialized().getFlag()).booleanValue()) {
            return false;
        }
        AutoTraceRay trace = this.rays.get(id);
        if (!trace.isResult()) {
            return false;
        }
        double result = Triple.distanceInSpace(Triple.locationToTriple(this.info.getLocation()), Triple.locationToTriple(trace.getHitLocation()));
        return result < distance;
    }

    public void addRayToAutoTrace(int id, Triple triple, double rayLength, boolean bFastTrace, boolean bTraceActors) {
        if (triple.z == 0.0) {
            this.levelRays.add(id);
            if (triple.epsilonEquals(new Triple(1.0, 0.0, 0.0), 1.0E-4)) {
                this.frontRayID = id;
            } else if (triple.epsilonEquals(new Triple(0.0, 1.0, 0.0), 1.0E-4)) {
                this.rightRayID = id;
            } else if (triple.epsilonEquals(new Triple(-1.0, 0.0, 0.0), 1.0E-4)) {
                this.backRayID = id;
            } else if (triple.epsilonEquals(new Triple(0.0, -1.0, 0.0), 1.0E-4)) {
                this.leftRayID = id;
            }
        }
        boolean bFloorCorrection = false;
        String stringID = id + "";
        this.autoTraceIds.add(stringID);
        this.rays.add(null);
        this.raycasting.createRay(stringID, triple.getVector3d(), (int)rayLength, bFastTrace, bFloorCorrection, bTraceActors);
    }

    public void setAutoTrace(boolean bEnable) {
        this.pendingAutoTraceEnable = bEnable;
    }

    public void finalAutoTraceDecision() {
        if (this.pendingAutoTraceEnable) {
            this.raycasting.createRay("DUMMY", new Vector3d(0.0, 0.0, 0.0), 0, false, false, false);
            this.raycasting.getAllRaysInitialized().addListener((FlagListener)new FlagListener<Boolean>(){

                public void flagChanged(Boolean changedValue) {
                    for (int i = 0; i < AgentBody.this.autoTraceIds.size(); ++i) {
                        AgentBody.this.rays.set(i, AgentBody.this.raycasting.getRay(AgentBody.this.autoTraceIds.get(i)));
                    }
                }
            });
            this.raycasting.endRayInitSequence();
            this.act.act((CommandMessage)new Configuration().setDrawTraceLines(Boolean.valueOf(true)).setAutoTrace(Boolean.valueOf(true)));
        } else {
            this.act.act((CommandMessage)new Configuration().setAutoTrace(Boolean.valueOf(false)));
        }
    }

    public void dodge(Triple triple) {
        this.dodge(triple, false);
    }

    public void dodge(Triple triple, boolean force) {
        if (force || this.game.getTime() - this.lastDodgeTime > 0.08) {
            this.lastDodgeTime = this.game.getTime();
            this.body.getLocomotion().dodge(triple.getLocation(), false);
        }
    }

    public void runToTarget(Player enemy) {
        this.body.getLocomotion().moveTo((ILocated)enemy);
    }

    public boolean isMoving() {
        try {
            Velocity v = this.info.getVelocity();
            return v.size() > 50.0 && !v.isPlanarZero();
        }
        catch (NullPointerException npe) {
            return false;
        }
    }

    public void jump(boolean doubleJump, double delay, double force) {
        if (this.isMoving()) {
            this.body.getLocomotion().jump(doubleJump, delay, force);
        }
    }

    public void jump() {
        if (this.isMoving()) {
            this.body.getLocomotion().jump();
        }
    }

    public void doubleJump() {
        if (this.isMoving()) {
            this.body.getLocomotion().doubleJump();
        }
    }

    public void doubleJump(double delay, double jumpZ) {
        if (this.isMoving()) {
            this.body.getLocomotion().doubleJump(delay, jumpZ);
        }
    }

    public NavPoint getNearbyNav(Location loc) {
        double nearestDistance = Double.MAX_VALUE;
        NavPoint bestNav = null;
        Map navPoints = this.world.getAll(NavPoint.class);
        for (NavPoint np : navPoints.values()) {
            double navDis = np.getLocation().getDistance(loc);
            if (!(navDis > 100.0) || !(navDis < nearestDistance)) continue;
            nearestDistance = navDis;
            bestNav = np;
        }
        return bestNav;
    }

    private void targetCheck(Player enemy) {
        if (!enemy.isVisible() && (this.info.isShooting().booleanValue() || this.info.isSecondaryShooting().booleanValue() || this.info.isPrimaryShooting().booleanValue())) {
            System.out.println("Stop shoot target check");
            this.stopShoot();
        }
    }

    public boolean forceShockBeam() {
        return this.shockOrbsToBeams >= 2;
    }

    public Triple getAgentLocation() {
        return Triple.locationToTriple(this.info.getLocation());
    }
}

