/*
 * Decompiled with CFR 0.152.
 */
package mockcz.cuni.pogamut.Client;

import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.base.utils.math.DistanceUtils;
import cz.cuni.amis.pogamut.base3d.worldview.IVisionWorldView;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.base3d.worldview.object.Rotation;
import cz.cuni.amis.pogamut.base3d.worldview.object.Velocity;
import cz.cuni.amis.pogamut.base3d.worldview.object.event.WorldObjectAppearedEvent;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.Raycasting;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.Weapon;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.Weaponry;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.Game;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.Items;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.Players;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.Senses;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.AutoTraceRay;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotDamaged;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.IncomingProjectile;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Item;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerDamaged;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.VolumeChanged;
import edu.utexas.cs.nn.Constants;
import edu.utexas.cs.nn.bots.UT2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.vecmath.Matrix3d;
import javax.vecmath.Vector3d;
import mockcz.cuni.amis.pogamut.base.agent.navigation.PathPlanner;
import mockcz.cuni.amis.pogamut.ut2004.agent.navigation.MyUTPathExecutor;
import mockcz.cuni.pogamut.Client.AgentBody;
import mockcz.cuni.pogamut.MessageObjects.Triple;

public class AgentMemory {
    public static final double FACING_TO_SHOOT_DEGREES = 20.0;
    public static final double FACING_ANGLE_DEGREES_THRESHOLD = 45.0;
    public static final double TIME_UNTIL_SAFE = 5.0;
    public static final double CLOSE_PROJECTILE_DISTANCE = 500.0;
    public static final double CLOSE_ENEMY_DISTANCE = 500.0;
    public static final double HIGH_GROUND_Z_DISTANCE = 200.0;
    public static final double MIN_CONTEXT_SWITCH_TIME = 3.0;
    public static final double CONTEXT_FORGET_TIME = 15.0;
    public static final double JUST_LOST_PLAYER_TIME = 3.0;
    public final AgentInfo info;
    public final Senses senses;
    public final Players players;
    public final Items items;
    public final PathPlanner pathPlanner;
    public final Weaponry weaponry;
    public final AgentBody body;
    public final Raycasting raycasting;
    public final IVisionWorldView world;
    public final MyUTPathExecutor itemPathExecutor;
    public final MyUTPathExecutor playerPathExecutor;
    public final Game game;
    public UnrealId lastPlayerDamaged = null;
    private Player judgeTarget = null;
    public double lastCombatJumpTime = 0.0;
    public static final double MIN_TIME_BETWEEN_JUMPS = 0.08;
    public static final double MIN_TIME_BETWEEN_DODGES = 0.08;
    public Player lastCombatTarget;
    public Location lastPosition;
    public HashMap<UnrealId, Double> playerAppearedTimes;
    public HashMap<UnrealId, Double> playerDisappearedTimes;
    public double linkGunSwitchTime = 0.0;
    public double weaponSwitchTime = 0.0;
    public double lastQuickTurn = 0.0;
    public Player lastEnemySpotting = null;
    public int consecutiveJudgeActions = 0;
    public static final int GOATSWOOD_WATER_LEVEL = -185;
    private VolumeChanged lastVolumeChanged = null;
    private Double lastTimeInWater = null;
    IWorldEventListener<VolumeChanged> volumeChangedHandler = new IWorldEventListener<VolumeChanged>(){

        public void notify(VolumeChanged vol) {
            AgentMemory.this.lastVolumeChanged = vol;
            if (vol.isWaterVolume()) {
                AgentMemory.this.lastTimeInWater = AgentMemory.this.game.getTime();
                System.out.println("In water at time: " + AgentMemory.this.lastTimeInWater);
            }
        }
    };
    Boolean inGoatswood = null;
    IWorldEventListener<PlayerDamaged> playerDamagedHandler = new IWorldEventListener<PlayerDamaged>(){

        public void notify(PlayerDamaged pd) {
            AgentMemory.this.lastPlayerDamaged = pd.getId();
        }
    };
    IWorldObjectEventListener<Player, WorldObjectAppearedEvent<Player>> playerAppeared = new IWorldObjectEventListener<Player, WorldObjectAppearedEvent<Player>>(){

        public void notify(WorldObjectAppearedEvent<Player> event) {
            Player p;
            if (event != null && (p = (Player)event.getObject()) != null) {
                AgentMemory.this.playerAppearedTimes.put(p.getId(), AgentMemory.this.game.getTime());
            }
        }
    };

    public void resetWaterMemory() {
        this.lastVolumeChanged = null;
        this.lastTimeInWater = null;
    }

    public boolean inWater() {
        return this.levelGoatswood() && this.info.getFloorLocation() != null && this.info.getFloorLocation().z < -185.0 || this.lastVolumeChanged != null && this.lastVolumeChanged.isWaterVolume() && this.info.isCurrentVolumeWater() != false;
    }

    public boolean levelGoatswood() {
        if (this.inGoatswood != null) {
            return this.inGoatswood;
        }
        String map = this.game.getMapName();
        if (map != null) {
            this.inGoatswood = map.toLowerCase().equals("DM-GoatswoodPlay".toLowerCase());
            return this.inGoatswood;
        }
        return false;
    }

    public boolean inWater(double timeframe) {
        return this.timeSinceLastInWater() < timeframe || this.inWater();
    }

    private double timeSinceLastInWater() {
        double time = this.game.getTime();
        if (this.lastTimeInWater != null) {
            return time - this.lastTimeInWater;
        }
        return Double.MAX_VALUE;
    }

    public void seeEnemy() {
        if (this.players.canSeeEnemies()) {
            this.lastEnemySpotting = this.players.getNearestVisibleEnemy();
        }
    }

    public AgentMemory(AgentBody body, AgentInfo info, Senses senses, Players players, PathPlanner pathPlanner, MyUTPathExecutor itemPathExecutor, MyUTPathExecutor playerPathExecutor, Items items, Weaponry weaponry, IVisionWorldView world, Game game) {
        this.body = body;
        this.info = info;
        this.senses = senses;
        this.players = players;
        this.pathPlanner = pathPlanner;
        this.itemPathExecutor = itemPathExecutor;
        this.playerPathExecutor = playerPathExecutor;
        this.items = items;
        this.weaponry = weaponry;
        this.raycasting = body.raycasting;
        this.world = world;
        this.game = game;
        this.playerAppearedTimes = new HashMap();
        this.playerDisappearedTimes = new HashMap();
        this.world.addEventListener(PlayerDamaged.class, this.playerDamagedHandler);
        this.world.addObjectListener(Player.class, WorldObjectAppearedEvent.class, this.playerAppeared);
    }

    public static double getContextSwitchDelay() {
        return 3.0 + Math.random() * 1.0;
    }

    public boolean justLostOpponent(Player p) {
        if (p == null) {
            return false;
        }
        Double disappearedTime = this.playerDisappearedTimes.get(p.getId());
        System.out.println("Disappear time: " + disappearedTime);
        System.out.println("Current time: " + this.game.getTime());
        boolean result = disappearedTime != null && this.game.getTime() - disappearedTime < 3.0;
        System.out.println(this.info.getName() + ":Just lost " + p.getName() + " = " + result);
        return result;
    }

    public boolean canFocusOn(Player p) {
        double lastDamagedTime;
        double currentTime;
        double diff;
        if (p == null) {
            return false;
        }
        BotDamaged damaged = this.senses.getLastDamage();
        if (damaged != null && damaged.getInstigator() != null && damaged.getInstigator().equals((Object)p.getId()) && (diff = (currentTime = this.info.getTime()) - (lastDamagedTime = (double)damaged.getSimTime())) < 5.0 && diff > 1.0) {
            return true;
        }
        Location playerLocation = p.getLocation();
        double delayMult = 1.0;
        if (playerLocation != null && this.info.getLocation() != null) {
            double distance = playerLocation.getDistance(this.info.getLocation());
            if (distance < 300.0) {
                return true;
            }
            delayMult += distance / 2500.0;
        }
        Double appearedTime = this.playerAppearedTimes.get(p.getId());
        Double disappearedTime = this.playerDisappearedTimes.get(p.getId());
        boolean result = false;
        if (appearedTime != null && (this.game.getTime() - appearedTime > AgentMemory.getContextSwitchDelay() * Math.pow(delayMult, 2.0) || disappearedTime != null && this.game.getTime() - disappearedTime < 15.0)) {
            result = true;
        }
        if (!result) {
            System.out.println(this.info.getName() + ":Context Switching");
        }
        return result;
    }

    public boolean judgingGunReady() {
        return this.game.getTime() - this.linkGunSwitchTime > 1.5;
    }

    public boolean gunReady() {
        return this.game.getTime() - this.weaponSwitchTime > 1.5;
    }

    public Player getCombatTarget() {
        Player target = this.pickCombatTarget();
        if (target != null) {
            this.lastCombatTarget = target;
        }
        return target;
    }

    private Player pickCombatTarget() {
        if (!UT2.evolving && this.weaponry.getCurrentWeapon() != null && this.weaponry.getCurrentWeapon().getType().equals((Object)ItemType.LINK_GUN) && this.judgeTarget != null) {
            return this.judgeTarget;
        }
        Player result = null;
        Player nearest = this.getSeeEnemy();
        int numberOpponentsVisible = this.numVisibleOpponents();
        if (this.lastPlayerDamaged != null && nearest != null) {
            Player lastEnemy = this.players.getVisiblePlayer(this.lastPlayerDamaged);
            Location agent = this.info.getLocation();
            if (lastEnemy != null && agent != null && !this.lastPlayerDamaged.equals((Object)nearest.getId())) {
                double lastEnemyDistance = agent.getDistance(lastEnemy.getLocation());
                double nearestEnemyDistance = agent.getDistance(nearest.getLocation());
                result = lastEnemyDistance > 2500.0 && nearestEnemyDistance < 2500.0 || lastEnemyDistance > 300.0 && nearestEnemyDistance < 300.0 || numberOpponentsVisible > 2 && nearestEnemyDistance < 900.0 ? nearest : lastEnemy;
            }
        }
        if (result == null) {
            result = nearest;
        }
        return result;
    }

    public boolean onElevator() {
        NavPoint nearest = this.info.getNearestNavPoint();
        return nearest != null && nearest.isLiftCenter();
    }

    public double getAgentHealth() {
        return this.info.getHealth().doubleValue();
    }

    public boolean isBeingDamaged() {
        return this.senses.isBeingDamaged();
    }

    public boolean getHearNoise() {
        return this.senses.isHearingNoise();
    }

    public ArrayList<Player> seenPlayers(int secondsHistory) {
        Map seenPlayers = this.players.getPlayers();
        ArrayList<Player> returnResult = new ArrayList<Player>();
        for (Player p : seenPlayers.values()) {
            if (this.info.getSelf().getSimTime() - p.getSimTime() > (long)secondsHistory) continue;
            returnResult.add(p);
        }
        return returnResult;
    }

    public ArrayList<Player> getKnownPlayers() {
        return this.seenPlayers(Integer.MAX_VALUE);
    }

    public Triple getAgentLocation() {
        return this.body.getAgentLocation();
    }

    public Triple getAgentRotation() {
        return Triple.rotationToTriple(this.info.getRotation());
    }

    public AutoTraceRay getAutoTrace(int id) {
        return this.raycasting.getRay(id + "");
    }

    public ArrayList<Item> getKnownHealths() {
        Map candidates = this.items.getKnownPickups(ItemType.Category.HEALTH);
        ArrayList<Item> result = new ArrayList<Item>();
        for (Item i : candidates.values()) {
            result.add(i);
        }
        return result;
    }

    public Weapon getCurrentWeapon() {
        return this.weaponry.getCurrentWeapon();
    }

    public ArrayList<Item> getKnownItems() {
        Map candidates = this.items.getKnownPickups();
        ArrayList<Item> result = new ArrayList<Item>();
        for (Item i : candidates.values()) {
            result.add(i);
        }
        return result;
    }

    public boolean sideWallClose(boolean left) {
        return this.body.sideWallClose(left);
    }

    public boolean backWallClose() {
        return this.body.backWallClose();
    }

    public boolean frontWallClose() {
        return this.body.frontWallClose();
    }

    public boolean hasWeaponOfType(ItemType weaponType) {
        return this.weaponry.hasWeapon(weaponType);
    }

    public ArrayList<AutoTraceRay> getAutoTraces() {
        if (((Boolean)this.raycasting.getAllRaysInitialized().getFlag()).booleanValue()) {
            return this.body.rays;
        }
        return new ArrayList<AutoTraceRay>();
    }

    public AutoTraceRay frontRayTrace() {
        return this.body.frontRayTrace();
    }

    public Player getSeeEnemy() {
        Player result;
        try {
            result = this.players.getNearestVisibleEnemy();
        }
        catch (NullPointerException e) {
            result = null;
        }
        return result;
    }

    public Double distanceToNearestEnemy() {
        Player e = this.getSeeEnemy();
        Location agent = this.info.getLocation();
        if (e != null && e.getLocation() != null && agent != null) {
            return agent.getDistance(e.getLocation());
        }
        return null;
    }

    public ArrayList<Item> seenHealths(int secondsHistory) {
        ArrayList<Item> candidates = this.getKnownHealths();
        ArrayList<Item> result = new ArrayList<Item>();
        for (Item h : candidates) {
            if (this.info.getSelf().getSimTime() - h.getSimTime() > (long)secondsHistory) continue;
            result.add(h);
        }
        return result;
    }

    public UnrealId getAgentID() {
        return this.info.getId();
    }

    public Item getNearestWeapon() {
        return this.getNearestWeapon(new Triple(0.0, 0.0, 0.0));
    }

    public Item getNearestWeapon(Triple offset) {
        Map weapons = this.items.getVisibleItems(ItemType.Category.WEAPON);
        if (weapons == null || weapons.isEmpty()) {
            weapons = this.items.getSpawnedItems(ItemType.Category.WEAPON);
        }
        double distance = Double.MAX_VALUE;
        Item closest = null;
        if (weapons != null) {
            for (Item weapon : weapons.values()) {
                double thisDistance;
                if (weapon.isDropped()) {
                    closest = weapon;
                    break;
                }
                if (weapon.getType().equals((Object)ItemType.ONS_GRENADE_LAUNCHER) || weapon.getType().equals((Object)ItemType.LINK_GUN) || this.weaponry.hasWeapon(weapon.getType()) || weapon.getType().getCategory().equals((Object)ItemType.Category.AMMO) || weapon.getLocation() == null || this.info.getLocation() == null || !((thisDistance = Triple.distanceInSpace(Triple.add(Triple.locationToTriple(weapon.getLocation()), offset), this.info.getLocation())) < distance)) continue;
                distance = thisDistance;
                closest = weapon;
            }
            return closest;
        }
        return null;
    }

    public Item getNearestUsableAmmo() {
        return this.getNearestUsableAmmo(new Triple(0.0, 0.0, 0.0));
    }

    public boolean isAboveMe(ILocated loc) {
        Location agent = this.info.getLocation();
        if (agent != null && loc != null && loc.getLocation() != null) {
            return loc.getLocation().z - agent.getLocation().z > 200.0;
        }
        return false;
    }

    public Player highestVisibleOpponent() {
        Collection enemies = this.players.getVisibleEnemies().values();
        Iterator itr = enemies.iterator();
        Player highest = null;
        while (itr.hasNext()) {
            Player current = (Player)itr.next();
            if (highest != null && (current.getLocation() == null || highest.getLocation() == null || !(current.getLocation().z > highest.getLocation().z))) continue;
            highest = current;
        }
        return highest;
    }

    public boolean opponentHasHighGround() {
        Player highest = this.highestVisibleOpponent();
        if (highest == null) {
            return false;
        }
        return this.isAboveMe((ILocated)highest.getLocation());
    }

    public boolean botHasHighGround() {
        Player highest = this.highestVisibleOpponent();
        Location agentLoc = this.info.getLocation();
        return agentLoc != null && highest != null && highest.getLocation() != null && agentLoc.z - highest.getLocation().z > 200.0;
    }

    public Item getNearestUsableAmmo(Triple offset) {
        Map ammos = this.items.getVisibleItems(ItemType.Category.AMMO);
        if (ammos == null || ammos.isEmpty()) {
            ammos = this.items.getSpawnedItems(ItemType.Category.AMMO);
        }
        double distance = Double.MAX_VALUE;
        Item closest = null;
        if (ammos != null) {
            for (Item ammo : ammos.values()) {
                if (ammo.getType().equals((Object)ItemType.LINK_GUN_AMMO)) continue;
                Map weapons = this.weaponry.getWeapons();
                for (Weapon w : weapons.values()) {
                    double thisDistance;
                    ItemType type = w.getDescriptor().getPriAmmoItemType();
                    if (!type.equals((Object)ammo.getType()) || ammo.getLocation() == null || this.info.getLocation() == null || !((thisDistance = Triple.distanceInSpace(Triple.add(Triple.locationToTriple(ammo.getLocation()), offset), this.info.getLocation())) < distance)) continue;
                    distance = thisDistance;
                    closest = ammo;
                }
            }
            return closest;
        }
        return null;
    }

    public boolean isMoving() {
        return this.body.isMoving();
    }

    public double angleBetweenBotRotationAndVectorToLocation(ILocated loc) {
        Rotation rot = this.info.getRotation();
        return AgentMemory.angleBetweenBotRotationAndVectorToLocation((ILocated)this.info.getLocation(), rot, loc);
    }

    public static double angleBetweenBotRotationAndVectorToLocation(ILocated source, Rotation rot, ILocated loc) {
        Location locFromRot = rot.toLocation();
        double angle = Math.acos(loc.getLocation().sub(source.getLocation()).getNormalized().dot(locFromRot.getNormalized()));
        return angle;
    }

    public static boolean sourceIsFacingLocation(ILocated source, Rotation rot, ILocated loc) {
        return AgentMemory.angleBetweenBotRotationAndVectorToLocation(source, rot, loc) < Math.toRadians(45.0);
    }

    public double signedAngleBetweenEnemyVelocityAndRouteToBot(Player p) {
        Location enemy = p.getLocation();
        Location bot = this.info.getLocation();
        Velocity vel = p.getVelocity();
        if (enemy != null && bot != null && vel != null) {
            Vector3d enemyToBot = Triple.locationToTriple(bot.sub(enemy)).normalize().getVector3d();
            Vector3d enemyMovement = Triple.velocityToTriple(vel).normalize().getVector3d();
            double angleDifference = enemyToBot.angle(enemyMovement);
            Vector3d positiveTurn = AgentMemory.multMatrixVector(AgentMemory.getTurnMatrix(angleDifference), enemyToBot);
            Vector3d negativeTurn = AgentMemory.multMatrixVector(AgentMemory.getTurnMatrix(-angleDifference), enemyToBot);
            if (enemyMovement.angle(positiveTurn) < enemyMovement.angle(negativeTurn)) {
                return -angleDifference;
            }
            return angleDifference;
        }
        return Math.PI;
    }

    public static Vector3d multMatrixVector(Matrix3d m, Vector3d v) {
        return new Vector3d(m.getM00() * v.x + m.getM10() * v.y + m.getM20() * v.z, m.getM01() * v.x + m.getM11() * v.y + m.getM21() * v.z, m.getM02() * v.x + m.getM12() * v.y + m.getM22() * v.z);
    }

    public static Matrix3d getTurnMatrix(double angle) {
        double c = Math.cos(angle);
        double s = Math.sin(angle);
        Matrix3d matrix = new Matrix3d();
        matrix.setM00(c);
        matrix.setM01(0.0);
        matrix.setM02(-s);
        matrix.setM10(0.0);
        matrix.setM11(1.0);
        matrix.setM12(0.0);
        matrix.setM20(s);
        matrix.setM21(0.0);
        matrix.setM22(c);
        return matrix;
    }

    public boolean isAdvancing(Player p) {
        if (!AgentMemory.isMovingInPlane(p) || this.isAboveMe((ILocated)p.getLocation())) {
            return false;
        }
        double angle = Math.abs(this.signedAngleBetweenEnemyVelocityAndRouteToBot(p));
        return angle < 0.7853981633974483;
    }

    public boolean isRetreating(Player p) {
        if (!AgentMemory.isMovingInPlane(p) || this.isAboveMe((ILocated)p.getLocation())) {
            return false;
        }
        double angle = Math.abs(this.signedAngleBetweenEnemyVelocityAndRouteToBot(p));
        return angle > 2.356194490192345;
    }

    public boolean isStrafing(Player p, boolean left) {
        if (!AgentMemory.isMovingInPlane(p) || this.isAboveMe((ILocated)p.getLocation())) {
            return false;
        }
        double angle = this.signedAngleBetweenEnemyVelocityAndRouteToBot(p);
        return left && angle > 0.7853981633974483 && angle < 2.356194490192345 || !left && angle < -0.7853981633974483 && angle > -2.356194490192345;
    }

    public static boolean isStill(Player p) {
        return p.getVelocity() != null ? p.getVelocity().isZero() : true;
    }

    public static boolean isJumping(Player p) {
        Velocity v = p.getVelocity();
        if (v != null) {
            return Math.abs(v.z) > 50.0;
        }
        return false;
    }

    public static boolean isMovingInPlane(Player p) {
        Velocity v = p.getVelocity();
        return v != null && Math.abs(v.x) > 1.0 && Math.abs(v.y) > 1.0;
    }

    public void setJudgingTarget(Player judgeTarget) {
        this.judgeTarget = judgeTarget;
    }

    public Boolean isToMyRight(Location otherLoc) {
        Location bot = this.info.getLocation();
        Rotation rot = this.info.getRotation();
        if (otherLoc != null && bot != null) {
            Vector3d botToEnemy = Triple.locationToTriple(otherLoc.sub(bot)).normalize().getVector3d();
            Vector3d botFacing = Triple.locationToTriple(rot.toLocation()).normalize().getVector3d();
            double angleDifference = botFacing.angle(botToEnemy);
            if (Math.toRadians(6.0) > angleDifference) {
                return null;
            }
            Vector3d positiveTurn = AgentMemory.multMatrixVector(AgentMemory.getTurnMatrix(angleDifference), botFacing);
            Vector3d negativeTurn = AgentMemory.multMatrixVector(AgentMemory.getTurnMatrix(-angleDifference), botFacing);
            return botToEnemy.angle(positiveTurn) < botToEnemy.angle(negativeTurn);
        }
        return null;
    }

    public Boolean isFacingMe(Player enemy) {
        return this.isFacingMe(enemy, 6.0);
    }

    public Boolean isFacingMe(Player enemy, double degrees) {
        Location agentFaceVector;
        if (enemy == null || enemy.getLocation() == null || enemy.getRotation() == null) {
            return null;
        }
        Location directionVector = this.info.getLocation().sub(enemy.getLocation()).getNormalized();
        if (Math.acos(directionVector.dot(agentFaceVector = enemy.getRotation().toLocation().getNormalized())) <= Math.toRadians(degrees)) {
            return true;
        }
        return false;
    }

    public boolean isThreatening(Player enemy) {
        return this.isThreatening(enemy, 20.0);
    }

    public boolean isThreatening(Player enemy, double facingDegrees) {
        double lastDamagedTime;
        double currentTime;
        if (enemy == null) {
            return false;
        }
        BotDamaged damaged = this.senses.getLastDamage();
        if (damaged != null && damaged.getInstigator() != null && damaged.getInstigator().equals((Object)enemy.getId()) && (currentTime = this.info.getTime()) - (lastDamagedTime = (double)damaged.getSimTime()) < 5.0) {
            System.out.println(enemy.getName() + " damaged me " + (currentTime - lastDamagedTime) + " ago");
            return true;
        }
        if (!enemy.isVisible()) {
            return false;
        }
        return this.isShootingAtMe(enemy, facingDegrees);
    }

    public boolean isShootingAtMe(Player enemy) {
        return this.isShootingAtMe(enemy, 20.0);
    }

    public boolean isShootingAtMe(Player enemy, double facingDegrees) {
        boolean isShooting = enemy.getFiring() != 0;
        boolean isFacingMe = this.isFacingMe(enemy, facingDegrees);
        return isShooting && isFacingMe;
    }

    public boolean isMoving(Player enemy) {
        Velocity enemyVol = enemy.getVelocity();
        return enemyVol == null ? false : !enemyVol.isPlanarZero() && !enemyVol.equals(new Velocity(0.0, 0.0, 0.0), 20.0);
    }

    public boolean isThreatened() {
        if (this.senses.seeIncomingProjectile()) {
            IncomingProjectile ip = this.senses.getLastIncomingProjectile();
            if (this.info.getLocation().getDistance(ip.getLocation()) < 500.0) {
                return true;
            }
        }
        double currentTime = this.info.getTime();
        BotDamaged damage = this.senses.getLastDamage();
        if (damage == null || damage.getInstigator() != null && damage.getInstigator().equals((Object)this.info.getId())) {
            return false;
        }
        double lastDamagedTime = damage.getSimTime();
        return currentTime - lastDamagedTime < 5.0;
    }

    public static boolean isBeneath(ILocated lower, ILocated higher) {
        if (higher != null && higher.getLocation() != null && lower != null && lower.getLocation() != null) {
            return higher.getLocation().z - lower.getLocation().z > (double)Constants.NEAR_ITEM_HEIGHT.getInt();
        }
        return false;
    }

    public boolean isBeneathMe(ILocated loc) {
        return AgentMemory.isBeneath(loc, (ILocated)this.info.getFloorLocation());
    }

    public Triple getLongestTraceToWall() {
        double maxDistance = 0.0;
        Triple direction = null;
        Location agent = this.info.getLocation();
        if (agent == null) {
            return null;
        }
        for (Integer rayID : this.body.levelRays) {
            AutoTraceRay ray = this.body.rays.get(rayID);
            double d = ray == null || !ray.isResult() ? 0.0 : agent.getDistance(ray.getHitLocation());
            double distance = d;
            if (!(distance > maxDistance)) continue;
            maxDistance = distance;
            direction = Triple.locationToTriple(ray.getTo().sub(ray.getFrom())).normalize();
        }
        return direction;
    }

    public double getShortestTraceToWallDistance() {
        double minDistance = Double.MAX_VALUE;
        Location agent = this.info.getLocation();
        if (agent == null) {
            return 0.0;
        }
        for (Integer rayID : this.body.levelRays) {
            AutoTraceRay ray = this.body.rays.get(rayID);
            double d = ray == null || !ray.isResult() ? 0.0 : agent.getDistance(ray.getHitLocation());
            double distance = d;
            if (!(distance < minDistance)) continue;
            minDistance = distance;
        }
        return minDistance;
    }

    public boolean changeWeapon(ItemType weaponType) {
        Weapon current = this.weaponry.getCurrentWeapon();
        if (current == null || !current.getType().equals((Object)weaponType)) {
            this.weaponry.changeWeapon(weaponType);
            return true;
        }
        return false;
    }

    private Vector<NavPoint> getLiftCenters() {
        Map navs = this.world.getAll(NavPoint.class);
        Vector<NavPoint> result = new Vector<NavPoint>();
        for (NavPoint np : navs.values()) {
            if (!np.isLiftCenter()) continue;
            result.add(np);
        }
        return result;
    }

    private Vector<NavPoint> getLiftExits() {
        Map navs = this.world.getAll(NavPoint.class);
        Vector<NavPoint> result = new Vector<NavPoint>();
        for (NavPoint np : navs.values()) {
            if (!np.isLiftExit()) continue;
            result.add(np);
        }
        return result;
    }

    public boolean underElevator() {
        String map = this.game.getMapName();
        Location bot = this.info.getLocation();
        if (map.toUpperCase().equals("DM-CURSE4") && bot != null && 950.0 < bot.x && bot.x < 1215.0 && -1252.0 < bot.y && bot.y < -1085.0 && -126.0 < bot.z && bot.z < -90.0) {
            System.out.println("In Curse4 Elevator Box");
            return true;
        }
        Vector<NavPoint> navs = this.getLiftCenters();
        if (navs.isEmpty()) {
            return false;
        }
        if (bot != null) {
            NavPoint nearest = (NavPoint)DistanceUtils.getNearest(navs, (ILocated)bot);
            return this.elevatorAbove(bot, nearest.getLocation());
        }
        return false;
    }

    public boolean nearElevator() {
        Location bot = this.info.getLocation();
        Vector<NavPoint> navs = this.getLiftCenters();
        Vector<NavPoint> exits = this.getLiftExits();
        navs.addAll(exits);
        if (navs.isEmpty()) {
            return false;
        }
        if (bot != null) {
            boolean result;
            NavPoint nearest = (NavPoint)DistanceUtils.getNearest(navs, (ILocated)bot);
            boolean bl = result = nearest.getLocation().getDistance(bot) < 300.0;
            if (result) {
                System.out.println("\tToo close to elevator to RETRACE");
            }
            return result;
        }
        return false;
    }

    public boolean elevatorAbove(Location lower, Location upper) {
        if (lower != null && upper != null) {
            return upper.z - lower.z > 30.0 && lower.getDistance2D(upper) < 300.0;
        }
        return false;
    }

    public NavPoint nearestLiftExit() {
        Collection original = this.world.getAll(NavPoint.class).values();
        ArrayList navs = new ArrayList();
        navs.addAll(original);
        Iterator itr = navs.iterator();
        while (itr.hasNext()) {
            if (((NavPoint)itr.next()).isLiftExit()) continue;
            itr.remove();
        }
        Location bot = this.info.getLocation();
        if (!navs.isEmpty() && bot != null) {
            return (NavPoint)DistanceUtils.getNearest(navs, (ILocated)bot);
        }
        return null;
    }

    public void updatePosition() {
        this.lastPosition = this.info.getLocation();
    }

    public void stopPathExecutors() {
        this.itemPathExecutor.stop();
        this.playerPathExecutor.stop();
    }

    public synchronized void targetDies(UnrealId dead) {
        if (dead != null) {
            if (this.lastCombatTarget != null && dead.equals((Object)this.lastCombatTarget.getId())) {
                this.lastCombatTarget = null;
            }
            if (this.judgeTarget != null && dead.equals((Object)this.judgeTarget.getId())) {
                this.judgeTarget = null;
            }
        }
    }

    public ItemType enemyWeaponType(Player target) {
        if (target == null) {
            return null;
        }
        String weapon = target.getWeapon() + "Pickup";
        ItemType enemyWeaponType = ItemType.getItemType((String)weapon);
        return enemyWeaponType;
    }

    public boolean enemyIsSniping(Player p) {
        if (p == null) {
            return false;
        }
        return this.body.isSnipingWeapon(this.enemyWeaponType(p));
    }

    public int numVisibleOpponents() {
        Map map = this.players.getVisibleEnemies();
        if (map == null) {
            return 0;
        }
        return map.size();
    }

    public boolean facingNavPoint(String id, double angle) {
        NavPoint navTarget = this.getNavPoint(id);
        if (navTarget == null) {
            return false;
        }
        return this.info.isFacing((ILocated)navTarget.getLocation(), angle);
    }

    public NavPoint getNavPoint(String id) {
        Map navs = this.world.getAll(NavPoint.class);
        return (NavPoint)navs.get(UnrealId.get((String)id));
    }
}

