/*
 * Decompiled with CFR 0.152.
 */
package utopia;

import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.base3d.worldview.object.Rotation;
import java.util.Collection;
import java.util.Random;
import mockcz.cuni.pogamut.MessageObjects.Triple;

public class Utils {
    public static Random myRandom = new Random();
    public static int controllerCount = 0;
    public static int agentCount = 0;
    public static int removedControllerCount = 0;
    public static int removedAgentCount = 0;

    public static boolean isBetween(double value, double delta) {
        return Utils.isBetween(value, -delta, delta);
    }

    public static boolean isBetween(double value, double lowValue, double highValue) {
        return lowValue < value && value < highValue;
    }

    public static double limitBetween(double value, double delta) {
        return Utils.limitBetween(value, -delta, delta);
    }

    public static double limitBetween(double value, double lowestValue, double highestValue) {
        if (lowestValue > highestValue) {
            return value;
        }
        return Math.max(lowestValue, Math.min(highestValue, value));
    }

    public static double relativeAngleToTarget(Triple agentLocation, Triple agentRotation, Triple targetLocation) {
        Triple vectorToTarget = Triple.subtract(targetLocation, agentLocation);
        Triple rotationVector = Triple.rotationAsVectorUTUnits(agentRotation);
        double angle = Math.atan2(rotationVector.y, rotationVector.x) - Math.atan2(vectorToTarget.y, vectorToTarget.x);
        angle = angle > Math.PI ? Math.PI * -2 + angle : angle;
        angle = angle < -Math.PI ? Math.PI * 2 + angle : angle;
        return angle;
    }

    public static double relativeAngleToTarget(Location agentLocation, Rotation agentRotation, Location targetLocation) {
        return Utils.relativeAngleToTarget(Triple.locationToTriple(agentLocation), Triple.rotationToTriple(agentRotation), Triple.locationToTriple(targetLocation));
    }

    public static boolean insideCube(Location point, Location lowerLeft, Location upperRight) {
        return (lowerLeft.x < upperRight.x && lowerLeft.x < point.x && point.x < upperRight.x || lowerLeft.x > upperRight.x && lowerLeft.x > point.x && point.x > upperRight.x) && (lowerLeft.y < upperRight.y && lowerLeft.y < point.y && point.y < upperRight.y || lowerLeft.y > upperRight.y && lowerLeft.y > point.y && point.y > upperRight.y) && (lowerLeft.z < upperRight.z && lowerLeft.z < point.z && point.z < upperRight.z || lowerLeft.z > upperRight.z && lowerLeft.z > point.z && point.z > upperRight.z);
    }

    public static double sumArray(double[] array) {
        double sum = 0.0;
        for (double value : array) {
            sum += value;
        }
        return sum;
    }

    public static double[] sumArrays(double[] array1, double[] array2) {
        if (array1.length != array2.length) {
            throw new IllegalArgumentException("Arrays not of the same size");
        }
        double[] result = new double[array1.length];
        for (int i = 0; i < array1.length; ++i) {
            result[i] = array1[i] + array2[i];
        }
        return result;
    }

    public static void printArray(double[] ds) {
        if (ds.length == 0) {
            System.out.print("[ ]");
            return;
        }
        System.out.print("[" + ds[0]);
        for (int i = 1; i < ds.length; ++i) {
            System.out.printf(", %.3f", ds[i]);
        }
        System.out.print("]");
    }

    public static void printArray(double[][] ds) {
        if (ds.length == 0) {
            System.out.print("{ }");
            return;
        }
        System.out.print("{");
        Utils.printArray(ds[0]);
        for (int i = 1; i < ds.length; ++i) {
            System.out.print(",");
            Utils.printArray(ds[i]);
        }
        System.out.print("}");
    }

    public static double randomCauchy(double wtrange) {
        double u = 0.5;
        double Cauchy_cut = 10.0;
        while (u == 0.5) {
            u = Math.random();
        }
        if (Math.abs(u = wtrange * Math.tan(u * Math.PI)) > Cauchy_cut) {
            return Utils.randomCauchy(wtrange);
        }
        return u;
    }

    public static double randomFloat() {
        return myRandom.nextDouble();
    }

    public static int randomInt(int x, int y) {
        int n = myRandom.nextInt(y - x + 1);
        return n + x;
    }

    public static int randposneg() {
        int n = myRandom.nextInt();
        if (n % 2 == 0) {
            return -1;
        }
        return 1;
    }

    public static boolean randomBool() {
        return myRandom.nextBoolean();
    }

    public static <T extends ILocated> T getFarthest(Collection<T> locations, ILocated target) {
        ILocated farthest = null;
        Location targetLoc = target.getLocation();
        if (targetLoc == null) {
            return null;
        }
        double maxDistance = Double.MIN_VALUE;
        for (ILocated l : locations) {
            double d;
            if (l.getLocation() == null || !((d = l.getLocation().getDistance(targetLoc)) > maxDistance)) continue;
            maxDistance = d;
            farthest = l;
        }
        return (T)farthest;
    }
}

