/*
 * Decompiled with CFR 0.152.
 */
package utopia.agentmodel;

import edu.utexas.cs.nn.Constants;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;

public class ActionLog {
    private PrintWriter log = null;
    private boolean fresh = true;
    private String name;
    private String lastActionLabel = null;
    private HashMap<String, Integer> actionCounts;
    private static final int MAX_LABEL_LENGTH = 20;

    public ActionLog(String name) {
        this.name = name;
        this.actionCounts = new HashMap();
        this.lastActionLabel = "";
        if (Constants.LOG_CONTROLLER_EVALUATIONS.getBoolean()) {
            try {
                File f = new File(Constants.CONTROLLER_EVALUATIONS_NAME.get() + "/" + name + ".txt");
                if (f.exists()) {
                    this.fresh = false;
                }
                this.log = new PrintWriter(new FileWriter(f, true));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void log_println(String txt) {
        if (this.log != null) {
            this.log.println(txt);
        }
    }

    private void log_print(String txt) {
        if (this.log != null) {
            this.log.print(txt);
        }
    }

    private HashMap<String, Integer> getActionCounts() {
        if (this.actionCounts == null) {
            this.actionCounts = new HashMap();
        }
        return this.actionCounts;
    }

    public void logActionChoices(PrintWriter actionLog) {
        actionLog.println(this.name + " Counts");
        int totalCounts = 0;
        StringBuilder sb = new StringBuilder();
        for (String key : this.getActionCounts().keySet()) {
            sb.append(key).append(":count\t").append(key).append(":total\t").append(key).append(":percent\t");
            totalCounts += this.getActionCounts().get(key).intValue();
        }
        if (this.fresh) {
            this.log_println(sb.substring(0));
            this.fresh = false;
        }
        actionLog.println("Total " + this.name + " Actions: " + totalCounts);
        for (String key : this.getActionCounts().keySet()) {
            actionLog.println(this.actionLogLine(key + ActionLog.blanks(20 - key.length()), this.getActionCounts().get(key), totalCounts));
        }
        this.log_println("");
        actionLog.println();
        if (this.log != null) {
            this.log.close();
        }
    }

    private static String blanks(int x) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < x; ++i) {
            result.append(" ");
        }
        return result.substring(0);
    }

    public String actionLogLine(String label, int count, int total) {
        return ActionLog.actionLogLine(this, label, count, total);
    }

    public static String actionLogLine(ActionLog evalLog, String label, int count, int total) {
        if (evalLog != null) {
            evalLog.log_print(count + "\t" + total + "\t" + 100.0 * (double)count / (double)total + "\t");
        }
        return label + ": " + count + "/" + total + ": " + 100.0 * (double)count / (double)total + "%";
    }

    public void takeAction(String key) {
        this.lastActionLabel = key;
        Integer x = this.getActionCounts().get(key);
        this.getActionCounts().put(key, x + 1);
    }

    public String lastActionLabel() {
        return this.lastActionLabel;
    }

    public void register(String key) {
        this.getActionCounts().put(key, 0);
    }
}

