/*
 * Decompiled with CFR 0.152.
 */
package utopia.agentmodel;

import java.io.PrintWriter;
import java.io.Serializable;
import mockcz.cuni.pogamut.Client.AgentBody;
import mockcz.cuni.pogamut.Client.AgentMemory;
import utopia.Utils;
import utopia.agentmodel.ActionLog;
import utopia.agentmodel.actions.Action;
import utopia.agentmodel.sensormodel.SensorModel;

public abstract class Controller
implements Cloneable,
Serializable {
    public boolean wasStuck = false;
    protected SensorModel model;
    private transient ActionLog actionLog = null;

    public Controller() {
        ++Utils.controllerCount;
    }

    public Controller(SensorModel model) {
        this();
        this.model = model;
    }

    public ActionLog getActionLog() {
        if (this.actionLog == null) {
            this.actionLog = new ActionLog(this.getClass().getSimpleName());
            this.registerActions();
        }
        return this.actionLog;
    }

    public void logActionChoices(PrintWriter pw) {
        this.getActionLog().logActionChoices(pw);
    }

    public void takeAction(String key) {
        this.getActionLog().takeAction(key);
    }

    public String lastActionLabel() {
        return this.getActionLog().lastActionLabel();
    }

    public void register(String key) {
        this.getActionLog().register(key);
    }

    public abstract Action control(AgentMemory var1);

    public abstract void reset();

    public Controller clone() {
        try {
            return (Controller)super.clone();
        }
        catch (CloneNotSupportedException e) {
            System.out.println("Object not clonable!");
            e.printStackTrace();
            return null;
        }
    }

    public void prepareSensorModel(AgentBody body) {
        if (this.model != null) {
            body.removeAllRaysFromAutoTrace();
            this.model.prepareSensors(body);
        }
    }

    public void registerActions() {
    }

    public SensorModel getSensorModel() {
        return this.model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            ++Utils.removedControllerCount;
        }
        finally {
            super.finalize();
        }
    }
}

