/*
 * Decompiled with CFR 0.152.
 */
package utopia.agentmodel.actions;

import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import edu.utexas.cs.nn.Constants;
import mockcz.cuni.pogamut.Client.AgentBody;
import mockcz.cuni.pogamut.Client.AgentMemory;
import mockcz.cuni.pogamut.MessageObjects.Triple;
import utopia.Utils;
import utopia.agentmodel.actions.OpponentRelativeAction;

public class ApproachEnemyAction
extends OpponentRelativeAction {
    protected boolean forcePath;

    public String toString() {
        return "Approach" + (this.shoot ? ":Shoot:" + (this.secondary ? "Alt" : "Pri") : "") + (this.jump ? ":Jump" : "") + (this.forcePath ? ":ForcePath" : "");
    }

    public ApproachEnemyAction(AgentMemory memory, boolean shoot, boolean secondary, boolean jump, boolean forcePath) {
        super(memory, shoot, secondary, jump);
        this.forcePath = forcePath;
    }

    @Override
    public void execute(AgentBody body) {
        Player enemy = this.memory.getCombatTarget();
        if (enemy != null && enemy.getLocation() != null) {
            super.shootDecision(enemy);
            this.runToOrPath(body, enemy);
            if (enemy.getLocation().getDistance(this.memory.info.getLocation()) > 900.0) {
                this.jumpDecision(body);
            }
        } else {
            enemy = this.memory.lastCombatTarget;
            if (enemy == null) {
                try {
                    enemy = this.memory.players.getNearestEnemy(Constants.MEMORY_TIME.getDouble());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
            if (enemy == null && (enemy = this.memory.lastEnemySpotting) != null) {
                System.out.println("\tLast enemy seen of any kind: " + enemy.getName());
            }
            if (enemy != null) {
                System.out.println("\tEnemy:" + enemy.getName() + ":loc:" + enemy.getLocation());
                this.runToOrPath(body, enemy);
            } else {
                System.out.println("\tContinuous Move");
                body.contMove();
            }
        }
    }

    private void runToOrPath(AgentBody body, Player enemy) {
        double distance;
        Location agent = this.memory.info.getLocation();
        double d = distance = agent != null && enemy.getLocation() != null ? enemy.getLocation().getDistance(agent) : Double.MAX_VALUE;
        if (!this.forcePath && distance < (double)Constants.MAX_BATTLE_DISTANCE.getInt() && !this.memory.isAboveMe((ILocated)enemy)) {
            double half = Constants.MAX_BATTLE_DISTANCE.getInt() / 2;
            Triple agentLocation = this.memory.getAgentLocation();
            Triple agentRotation = this.memory.getAgentRotation();
            if (agentLocation != null && agentRotation != null && distance < half && distance / half < Math.random()) {
                boolean left = Utils.myRandom.nextBoolean();
                System.out.println(body.info.getName() + ":ZIGZAG:" + (left ? "Left" : "Right"));
                Triple lookAt = Triple.locationToTriple(enemy.getLocation());
                double range = 250.0;
                double rotation = Triple.utAngleToRad(agentRotation.y);
                Triple vectorToEnemy = Triple.subtract(lookAt, agentLocation);
                double y = (double)(left ? -1 : 1) * range * Math.cos(rotation -= Triple.utAngleToRad(Triple.angle(vectorToEnemy, new Triple(1.0, 0.0, 0.0))));
                double x = (double)(left ? 1 : -1) * range * Math.sin(rotation);
                Triple target = Triple.add(Triple.locationToTriple(enemy.getLocation()), new Triple(x, y, 0.0));
                body.body.getLocomotion().strafeTo((ILocated)target, enemy.getId());
            } else {
                body.runToTarget(enemy);
            }
        } else {
            this.memory.playerPathExecutor.followPath(this.memory.pathPlanner.computePath((ILocated)enemy));
        }
    }
}

