/*
 * Decompiled with CFR 0.152.
 */
package utopia.agentmodel.actions;

import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import mockcz.cuni.pogamut.Client.AgentBody;
import mockcz.cuni.pogamut.Client.AgentMemory;
import mockcz.cuni.pogamut.MessageObjects.Triple;
import utopia.agentmodel.actions.OpponentRelativeAction;

public class EnemyRelativeStrafeAction
extends OpponentRelativeAction {
    private final boolean left;
    private final boolean allowDodge;

    public String toString() {
        return "Strafe:" + (this.left ? "Left" : "Right") + (this.shoot ? ":Shoot:" + (this.secondary ? "Alt" : "Pri") : "") + (this.jump ? ":Jump" : "");
    }

    public EnemyRelativeStrafeAction(AgentMemory memory, boolean shoot, boolean secondary, boolean left, boolean jump, boolean allowDodge) {
        super(memory, shoot, secondary, jump);
        this.left = left;
        this.allowDodge = allowDodge;
    }

    public EnemyRelativeStrafeAction(AgentMemory memory, boolean shoot, boolean secondary, boolean left, boolean jump) {
        this(memory, shoot, secondary, left, jump, true);
    }

    public EnemyRelativeStrafeAction(AgentMemory memory, boolean shoot, boolean secondary, boolean left) {
        this(memory, shoot, secondary, left, false);
    }

    @Override
    public void execute(AgentBody body) {
        Player enemy = this.memory.getCombatTarget();
        Triple agentLocation = this.memory.getAgentLocation();
        Triple agentRotation = this.memory.getAgentRotation();
        if (enemy != null && enemy.getLocation() != null && agentLocation != null && agentRotation != null) {
            super.shootDecision(enemy);
            Triple lookAt = Triple.locationToTriple(enemy.getLocation());
            double range = 300.0;
            double rotation = Triple.utAngleToRad(agentRotation.y);
            Triple vectorToEnemy = Triple.subtract(lookAt, agentLocation);
            double y = (double)(this.left ? -1 : 1) * range * Math.cos(rotation -= Triple.utAngleToRad(Triple.angle(vectorToEnemy, new Triple(1.0, 0.0, 0.0))));
            double x = (double)(this.left ? 1 : -1) * range * Math.sin(rotation);
            Triple target = Triple.add(agentLocation, new Triple(x, y, 0.0));
            target.z = lookAt.z;
            if (this.allowDodge && !this.memory.sideWallClose(this.left) && Math.random() < 0.15) {
                body.dodge(Triple.subtract(target, this.memory.getAgentLocation()));
            } else {
                body.strafeToLocation(target, lookAt, 100.0);
            }
            if (enemy.getLocation().getDistance(this.memory.info.getLocation()) > 600.0) {
                this.jumpDecision(body);
            }
        } else if (this.left) {
            body.body.getLocomotion().strafeLeft(100.0);
        } else {
            body.body.getLocomotion().strafeRight(100.0);
        }
    }
}

