/*
 * Decompiled with CFR 0.152.
 */
package utopia.agentmodel.actions;

import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Move;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Item;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import java.util.Collection;
import java.util.Iterator;
import mockcz.cuni.pogamut.Client.AgentBody;
import mockcz.cuni.pogamut.Client.AgentMemory;
import utopia.Utils;
import utopia.agentmodel.actions.OpponentRelativeAction;
import utopia.controllers.scripted.PathController;

public class GotoItemAction
extends OpponentRelativeAction {
    private final Item item;

    public String toString() {
        String name = this.item == null ? "[NONE]" : this.item.getType().getName();
        return "GotoItem:" + name.substring(name.indexOf(".") + 1);
    }

    public GotoItemAction(AgentMemory memory, Item item, boolean shoot, boolean secondary, boolean jump) {
        super(memory, shoot, secondary, jump);
        this.item = item;
    }

    public GotoItemAction(AgentMemory memory, Item item) {
        this(memory, item, false, false, false);
    }

    public static boolean willGoto(AgentMemory memory, Item candidate) {
        return candidate != null && PathController.wantItem(memory, candidate);
    }

    @Override
    public void execute(AgentBody body) {
        Player enemy = this.memory.getCombatTarget();
        if (enemy != null && enemy.getLocation() != null) {
            super.shootDecision(enemy);
        }
        if (this.item == null) {
            System.out.println("Goto Item Failure: Null Item");
            return;
        }
        Location itemLocation = this.item.getLocation();
        Location agentLocation = this.memory.info.getLocation();
        if (itemLocation != null && agentLocation != null) {
            Location second = null;
            Collection<NavPoint> visibleNavs = body.world.getAllVisible(NavPoint.class).values();
            second = !(visibleNavs = GotoItemAction.removeNavWithLocation(visibleNavs, itemLocation)).isEmpty() ? Utils.getFarthest(visibleNavs, (ILocated)agentLocation).getLocation() : itemLocation.sub(this.memory.info.getVelocity().normalize().scale(200.0));
            Move move = new Move().setFirstLocation(itemLocation).setSecondLocation(second);
            if (enemy != null) {
                move.setFocusTarget(enemy.getId());
            }
            this.memory.body.act.act((CommandMessage)move);
        }
        this.jumpDecision(body);
    }

    private static Collection<NavPoint> removeNavWithLocation(Collection<NavPoint> visibleNavs, Location itemLocation) {
        Iterator<NavPoint> itr = visibleNavs.iterator();
        while (itr.hasNext()) {
            if (!itr.next().getLocation().equals(itemLocation, 20.0)) continue;
            itr.remove();
        }
        return visibleNavs;
    }
}

