/*
 * Decompiled with CFR 0.152.
 */
package utopia.agentmodel.actions;

import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.base3d.worldview.object.Velocity;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.Weapon;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Rotate;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import mockcz.cuni.pogamut.Client.AgentBody;
import mockcz.cuni.pogamut.Client.AgentMemory;
import mockcz.cuni.pogamut.MessageObjects.Triple;
import utopia.agentmodel.actions.Action;

public abstract class OpponentRelativeAction
extends Action {
    public static final double AIM_VELOCITY_DIFFERENCE_DISTORTION = 40.0;
    public static final double AIM_RANDOM_DISTORTION = 0.75;
    public static final double DODGE_CHANCE = 0.15;
    public static final double SHOOT_FACING_ALLOWANCE = 30.0;
    private static final double MAX_SHOOT_ANGLE = 70.0;
    private static double RECENT_DODGE_TIME = 0.05;
    private static final double SHOCK_ABORT_CHANCE = 0.35;
    protected final AgentMemory memory;
    protected boolean shoot;
    protected boolean secondary;
    public static final double DO_NOT_SHOOT_FAR_CHANCE = 0.9;
    public static final double JUMP_NEAR_WALL_TOLERANCE = 200.0;
    protected boolean jump;
    protected boolean observing;

    public OpponentRelativeAction(AgentMemory memory, boolean shoot, boolean secondary, boolean jump) {
        this.memory = memory;
        this.shoot = shoot;
        this.secondary = secondary;
        this.jump = jump;
        this.observing = false;
    }

    public OpponentRelativeAction(AgentMemory memory, boolean shoot, boolean secondary) {
        this(memory, shoot, secondary, false);
    }

    public void observe() {
        this.observing = true;
        this.shoot = false;
    }

    public boolean shootDecision(Player enemy) {
        if (this.observing) {
            return false;
        }
        return OpponentRelativeAction.shootDecision(this.memory, enemy, this.shoot, this.secondary);
    }

    private static Triple lobAdjustment(Player enemy, Triple agent) {
        Triple target = Triple.locationToTriple(enemy.getLocation());
        return Triple.subtract(agent, target).multiplyByNumber(Math.random() * 0.3 + 0.3);
    }

    private static Triple slowAdjustment(Player enemy, Triple agent) {
        Triple adjust = Triple.velocityToTriple(enemy.getVelocity()).multiplyByNumber(Math.random() * 0.2 + 0.8);
        adjust.z = enemy.getLocation().z > agent.z ? 0.0 : (adjust.z -= 5.0);
        return adjust;
    }

    public static boolean shootDecision(AgentMemory memory, Player enemy, boolean shoot, boolean secondary) {
        boolean tooSteep;
        double distance = enemy.getLocation().getDistance(memory.info.getLocation());
        double shootingAllowanceAngle = 30.0;
        Weapon w = memory.weaponry.getCurrentWeapon();
        boolean forceNewFire = false;
        boolean perfect = false;
        double chargeTime = 0.0;
        boolean forcedHoldFire = false;
        double aimVelDiffDistortion = 40.0;
        double aimRandomDistortion = 0.75;
        Triple adjust = null;
        if (w != null) {
            ItemType type = w.getType();
            if (type.equals((Object)ItemType.SHIELD_GUN)) {
                perfect = true;
                if (distance < 500.0) {
                    secondary = false;
                    shoot = true;
                } else {
                    secondary = true;
                    shoot = enemy.getFiring() != 0 || memory.senses.seeIncomingProjectile() || memory.weaponry.getSecondaryWeaponAmmo(type) > 20;
                    boolean bl = forceNewFire = memory.info.isSecondaryShooting() == false;
                    if (shoot && forceNewFire) {
                        memory.body.body.getShooting().shootSecondary(enemy);
                        return true;
                    }
                }
            } else if (type.equals((Object)ItemType.ASSAULT_RIFLE)) {
                if (distance >= 2500.0) {
                    memory.body.stopShoot();
                    shoot = false;
                    forcedHoldFire = true;
                    return false;
                }
                int altAmmo = memory.weaponry.getCurrentAlternateAmmo();
                if (altAmmo > 0 && (memory.weaponry.getCurrentPrimaryAmmo() == 0 || enemy.getVelocity().isZero(20.0))) {
                    secondary = true;
                } else if (altAmmo == 0) {
                    secondary = false;
                } else {
                    boolean bl = secondary = Math.random() < 0.25;
                }
                if (memory.info.isSecondaryShooting().booleanValue()) {
                    memory.body.stopShoot(true);
                    return true;
                }
                if (memory.info.isPrimaryShooting().booleanValue()) {
                    secondary = false;
                }
                if (secondary) {
                    adjust = OpponentRelativeAction.lobAdjustment(enemy, memory.getAgentLocation());
                } else {
                    shootingAllowanceAngle = 90.0;
                    forceNewFire = true;
                    perfect = Math.random() < 0.2;
                }
            } else if (type.equals((Object)ItemType.SHOCK_RIFLE)) {
                aimRandomDistortion += Math.random() * 0.25;
                forceNewFire = true;
                boolean bl = secondary = !memory.body.forceShockBeam() && Math.random() < 0.5;
                if (secondary) {
                    adjust = OpponentRelativeAction.slowAdjustment(enemy, memory.getAgentLocation());
                }
                if (distance > 300.0 && Math.random() < 0.35) {
                    shoot = false;
                } else if (Math.random() < 0.5) {
                    shoot = false;
                }
            } else if (type.equals((Object)ItemType.LINK_GUN)) {
                shootingAllowanceAngle = 90.0;
                aimRandomDistortion = 0.1;
                aimVelDiffDistortion = 50.0;
                forceNewFire = false;
                if (distance > 1250.0 || !memory.judgingGunReady()) {
                    memory.body.stopShoot();
                    return false;
                }
                boolean bl = perfect = Math.random() < 0.5;
                if (!perfect) {
                    adjust = OpponentRelativeAction.slowAdjustment(enemy, memory.getAgentLocation());
                }
            } else if (type.equals((Object)ItemType.BIO_RIFLE)) {
                chargeTime = 3.7;
                if (memory.info.isPrimaryShooting().booleanValue() && distance < 900.0) {
                    secondary = false;
                    shoot = true;
                } else {
                    secondary = memory.weaponry.getSecondaryWeaponAmmo(ItemType.BIO_RIFLE) >= 9 && Math.random() < 0.4;
                }
                adjust = OpponentRelativeAction.lobAdjustment(enemy, memory.getAgentLocation());
                if (Math.random() < 0.3) {
                    perfect = true;
                }
                if (!secondary) {
                    forceNewFire = true;
                }
                if (distance < 600.0) {
                    if (memory.info.isSecondaryShooting().booleanValue()) {
                        memory.body.stopShoot(true);
                        return true;
                    }
                    shoot = true;
                    secondary = false;
                } else if (distance >= 1250.0) {
                    memory.body.stopShoot();
                    shoot = false;
                    forcedHoldFire = true;
                }
            } else if (type.equals((Object)ItemType.MINIGUN)) {
                shootingAllowanceAngle = 90.0;
                if (distance >= 2500.0 && memory.isMoving()) {
                    memory.body.stopShoot();
                    shoot = false;
                    forcedHoldFire = true;
                    return false;
                }
                shoot = true;
                forceNewFire = true;
                boolean bl = perfect = Math.random() < 0.2;
                if (memory.info.isPrimaryShooting().booleanValue()) {
                    secondary = false;
                } else if (memory.info.isSecondaryShooting().booleanValue()) {
                    secondary = true;
                }
            } else if (type.equals((Object)ItemType.FLAK_CANNON)) {
                shootingAllowanceAngle = 30.0;
                aimRandomDistortion = 0.2;
                forceNewFire = true;
                if (distance < 900.0) {
                    secondary = false;
                    shoot = true;
                } else if (distance < 2500.0) {
                    boolean bl = secondary = Math.random() < 0.3;
                    if (!secondary) {
                        adjust = OpponentRelativeAction.slowAdjustment(enemy, memory.getAgentLocation());
                    }
                } else {
                    memory.body.stopShoot();
                    shoot = false;
                    forcedHoldFire = true;
                    if (Math.random() < 0.9) {
                        return false;
                    }
                }
                if (secondary) {
                    if (enemy.getLocation().z > memory.info.getLocation().z + 100.0) {
                        memory.body.stopShoot();
                        return true;
                    }
                    adjust = OpponentRelativeAction.lobAdjustment(enemy, memory.getAgentLocation());
                } else {
                    perfect = Math.random() < 0.2;
                }
            } else if (type.equals((Object)ItemType.ROCKET_LAUNCHER)) {
                aimRandomDistortion = 0.1;
                chargeTime = 2.0;
                boolean bl = secondary = distance > 600.0 && memory.weaponry.getSecondaryWeaponAmmo(ItemType.ROCKET_LAUNCHER) >= 3 && Math.random() < 0.4;
                if (memory.info.isSecondaryShooting().booleanValue()) {
                    shoot = true;
                    secondary = true;
                    if (distance < 600.0) {
                        memory.body.stopShoot(true);
                        return true;
                    }
                } else if (distance >= 2500.0) {
                    memory.body.stopShoot();
                    shoot = false;
                    forcedHoldFire = true;
                    if (Math.random() < 0.9) {
                        return false;
                    }
                } else if (!secondary) {
                    forceNewFire = true;
                }
                if (secondary) {
                    perfect = true;
                } else {
                    adjust = OpponentRelativeAction.slowAdjustment(enemy, memory.getAgentLocation());
                }
            } else if (type.equals((Object)ItemType.SNIPER_RIFLE) || type.equals((Object)ItemType.LIGHTNING_GUN)) {
                aimRandomDistortion += 0.25 + Math.random() * 0.5;
                aimVelDiffDistortion -= 10.0;
                secondary = false;
                forceNewFire = true;
                Velocity v = memory.info.getVelocity();
                if (v != null && Math.abs(v.z) > 100.0 && Math.random() < 0.8) {
                    shoot = false;
                }
            }
        }
        if (forcedHoldFire && AgentMemory.isBeneath((ILocated)enemy.getLocation(), (ILocated)memory.info.getLocation())) {
            shoot = true;
        }
        boolean veryClose = distance < 300.0;
        boolean noFocus = !memory.canFocusOn(enemy);
        boolean recentDodge = memory.game.getTime() - memory.body.lastDodgeTime < RECENT_DODGE_TIME;
        boolean notGunReady = !memory.gunReady() && !veryClose;
        boolean intoWall = memory.body.veryCloseFrontWall() || memory.frontWallClose() && memory.body.isSplashDamageWeapon(w);
        boolean notFacing = memory.info.isFacing((ILocated)enemy, shootingAllowanceAngle) == false && !veryClose;
        boolean highGround = memory.botHasHighGround();
        boolean notVisible = !enemy.isVisible();
        boolean bl = tooSteep = !veryClose && enemy.getLocation() != null && memory.info.getLocation() != null && memory.body.verticalAngleToTarget(enemy.getLocation()) > Math.toRadians(70.0);
        if (noFocus || recentDodge || notGunReady || intoWall || notFacing && !highGround || notVisible || tooSteep) {
            System.out.println(memory.info.getName() + ": Shooting disallowed: " + (noFocus ? "noFocus " : "") + (recentDodge ? "recentDodge " : "") + (notGunReady ? "notGunReady " : "") + (intoWall ? "intoWall " : "") + (notFacing ? "notFacing " : "") + (notVisible ? "notVisible " : "") + (tooSteep ? "tooSteep " : "") + (!highGround ? "notHighGround " : ""));
            shoot = false;
        }
        if (shoot) {
            if (secondary && (forceNewFire || !memory.info.isSecondaryShooting().booleanValue())) {
                memory.body.shootAlternate(enemy, perfect, adjust, chargeTime, aimVelDiffDistortion, aimRandomDistortion);
            } else if (!(secondary || !forceNewFire && memory.info.isPrimaryShooting().booleanValue())) {
                memory.body.shoot(enemy, perfect, adjust, aimVelDiffDistortion, aimRandomDistortion);
            }
            return true;
        }
        memory.body.stopShoot();
        return false;
    }

    public void jumpDecision(AgentBody body) {
        Velocity velocity;
        Velocity v;
        Player enemy = this.memory.getCombatTarget();
        double distance = 0.0;
        Location agent = this.memory.info.getLocation();
        if (agent != null && enemy != null) {
            distance = agent.getDistance(enemy.getLocation());
        }
        Velocity velocity2 = v = (velocity = body.info.getVelocity()) == null ? new Velocity(0.0, 0.0, 0.0) : new Velocity(velocity.x, velocity.y, 0.0);
        if (this.jump && !this.memory.senses.isColliding() && distance > 300.0 && this.memory.getShortestTraceToWallDistance() > 200.0 && this.memory.game.getTime() - this.memory.lastCombatJumpTime > 0.08 && !body.usingSnipingWeapon() && v.size() > 50.0) {
            this.memory.lastCombatJumpTime = this.memory.game.getTime();
            body.jump();
        }
    }

    public void turn(AgentBody body, boolean right) {
        body.act.act((CommandMessage)new Rotate().setAmount(Integer.valueOf((right ? 1 : -1) * 32000)));
    }
}

