/*
 * Decompiled with CFR 0.152.
 */
package utopia.agentmodel.sensormodel;

import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.AutoTraceRay;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Item;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import java.util.ArrayList;
import mockcz.cuni.pogamut.Client.AgentBody;
import mockcz.cuni.pogamut.Client.AgentMemory;
import mockcz.cuni.pogamut.MessageObjects.Triple;
import utopia.Utils;
import utopia.agentmodel.sensormodel.SensorModel;

public class BotprizeSensorModel
extends SensorModel {
    public static final double PI = Math.PI;
    private double[] sliceLimits;
    private int secondsHistory;
    private int crosshairID;
    private double rayLength = 5000.0;
    private int levelRaySensors;
    private int airRaySensors;
    private int groundRaySensors;
    protected double frontLeftDist;
    protected double frontRightDist;
    protected boolean playerInCrosshair;

    public BotprizeSensorModel(int levelTraces, int airTraces, int groundTraces, double[] sliceLimits, int secondsHistory) {
        this.levelRaySensors = levelTraces;
        this.airRaySensors = airTraces;
        this.groundRaySensors = groundTraces;
        this.sliceLimits = sliceLimits;
        this.secondsHistory = secondsHistory;
    }

    public BotprizeSensorModel() {
        this(12, 6, 4, new double[]{0.0, 0.02454369260617026, 0.09817477042468103, 0.7853981633974483, 1.5707963267948966, Math.PI}, 3);
    }

    @Override
    public void prepareSensors(AgentBody body) {
        int i;
        double y;
        double x;
        body.removeAllRaysFromAutoTrace();
        this.crosshairID = 0;
        body.addRayToAutoTrace(this.crosshairID, new Triple(1.0, 0.0, 0.0), this.rayLength, false, true);
        int numRays = 1;
        double angle = Math.PI * 2 / (double)this.levelRaySensors;
        for (int i2 = 0; i2 < this.levelRaySensors; ++i2) {
            x = Math.cos(angle * (double)i2);
            y = Math.sin(angle * (double)i2);
            body.addRayToAutoTrace(numRays, new Triple(x, y, 0.0), this.rayLength, false, false);
            ++numRays;
        }
        double liftAngle = 0.7853981633974483;
        double z = Math.sin(liftAngle);
        angle = Math.PI * 2 / (double)this.airRaySensors;
        for (i = 0; i < this.airRaySensors; ++i) {
            x = Math.cos(angle * (double)i);
            y = Math.sin(angle * (double)i);
            body.addRayToAutoTrace(numRays, new Triple(x, y, z), this.rayLength, false, false);
            ++numRays;
        }
        liftAngle = -liftAngle;
        z = Math.sin(liftAngle);
        angle = Math.PI * 2 / (double)this.groundRaySensors;
        for (i = 0; i < this.groundRaySensors; ++i) {
            x = Math.cos(angle * (double)i);
            y = Math.sin(angle * (double)i);
            body.addRayToAutoTrace(numRays, new Triple(x, y, z), this.rayLength, false, false);
            ++numRays;
        }
        body.setAutoTrace(true);
    }

    @Override
    public double[] getSensors(AgentMemory memory) {
        double[] sensors = new double[this.getNumSensors()];
        double[] traces = this.getAllTraces(memory);
        double[] slices = this.getSlices(memory);
        double[] misc = this.getMiscSensors(memory);
        System.arraycopy(traces, 0, sensors, 0, traces.length);
        System.arraycopy(slices, 0, sensors, traces.length, slices.length);
        System.arraycopy(misc, 0, sensors, traces.length + slices.length, misc.length);
        return sensors;
    }

    public double[] getAllTraces(AgentMemory memory) {
        double[] sensors = new double[this.getNumTraces()];
        ArrayList<AutoTraceRay> traces = memory.getAutoTraces();
        for (AutoTraceRay trace : traces) {
            sensors[Integer.parseInt((String)trace.getId().getStringId())] = trace.isResult() ? BotprizeSensorModel.scale(Triple.distanceInSpace(memory.getAgentLocation(), Triple.locationToTriple(trace.getHitLocation())), this.rayLength) : 0.0;
        }
        return sensors;
    }

    public double[] getSlices(AgentMemory memory) {
        double[] slices = new double[this.getNumSlices()];
        ArrayList<Player> seenPlayers = memory.seenPlayers(this.secondsHistory);
        this.frontLeftDist = 0.0;
        this.frontRightDist = 0.0;
        int numPlayers = 0;
        int num = 0;
        UnrealId[] playerIDs = new UnrealId[seenPlayers.size()];
        block0: for (Player seenPlayer : seenPlayers) {
            int i;
            playerIDs[num] = seenPlayer.getId();
            ++num;
            Triple playerLocation = Triple.locationToTriple(seenPlayer.getLocation());
            Triple agentLocation = memory.getAgentLocation();
            if (playerLocation == null || agentLocation == null) continue;
            double distance = BotprizeSensorModel.scaleDistance(Triple.distanceInSpace(agentLocation, playerLocation));
            ++numPlayers;
            double angle = Utils.relativeAngleToTarget(memory.getAgentLocation(), memory.getAgentRotation(), playerLocation);
            if (angle > 0.0) {
                for (i = 0; i < this.sliceLimits.length - 1; ++i) {
                    if (!(this.sliceLimits[i] < angle) || !(angle <= this.sliceLimits[i + 1])) continue;
                    int n = i;
                    slices[n] = slices[n] + 1.0;
                    if (i != 0) continue block0;
                    this.frontLeftDist = distance;
                    continue block0;
                }
                continue;
            }
            for (i = 0; i < this.sliceLimits.length - 1; ++i) {
                if (!(-this.sliceLimits[i + 1] < angle) || !(angle <= -this.sliceLimits[i])) continue;
                int n = i + this.sliceLimits.length - 1;
                slices[n] = slices[n] + 1.0;
                if (i != 0) continue block0;
                this.frontRightDist = distance;
                continue block0;
            }
        }
        AutoTraceRay crosshair = memory.getAutoTrace(this.crosshairID);
        if (crosshair != null && crosshair.isResult()) {
            this.playerInCrosshair = false;
            for (UnrealId playerID : playerIDs) {
                this.playerInCrosshair = this.playerInCrosshair || playerID.equals((Object)crosshair.getHitId());
            }
        }
        return slices;
    }

    public double[] getMiscSensors(AgentMemory memory) {
        double[] sensors = new double[this.getNumMiscSensors()];
        sensors[0] = this.frontLeftDist;
        sensors[1] = this.frontRightDist;
        sensors[2] = memory.isBeingDamaged() ? 1.0 : 0.0;
        ArrayList<Item> healths = memory.seenHealths(this.secondsHistory);
        Item nearest = null;
        double distance = Double.MAX_VALUE;
        if (!healths.isEmpty()) {
            Triple agent = memory.getAgentLocation();
            for (Item h : healths) {
                double d = Triple.distanceInSpace(agent, h.getLocation());
                if (!(d < distance)) continue;
                distance = d;
                nearest = h;
            }
            sensors[3] = BotprizeSensorModel.scaleDistance(nearest.getLocation().x - agent.x);
            sensors[4] = BotprizeSensorModel.scaleDistance(nearest.getLocation().y - agent.y);
            sensors[5] = BotprizeSensorModel.scaleDistance(nearest.getLocation().z - agent.z);
            sensors[6] = BotprizeSensorModel.scaleDistance(distance);
        }
        sensors[7] = this.playerInCrosshair ? 1.0 : 0.0;
        return sensors;
    }

    public int getNumTraces() {
        return 1 + this.levelRaySensors + this.airRaySensors + this.groundRaySensors;
    }

    public int getNumSlices() {
        return (this.sliceLimits.length - 1) * 2;
    }

    public int getNumMiscSensors() {
        return 8;
    }

    public static double scale(double distance, double max) {
        return Math.exp(-distance / max);
    }

    public static double scaleDistance(double value) {
        return BotprizeSensorModel.scale(value, 1000.0);
    }

    @Override
    public int getNumSensors() {
        return this.getNumTraces() + this.getNumSlices() + this.getNumMiscSensors();
    }
}

