/*
 * Decompiled with CFR 0.152.
 */
package utopia.controllers.scripted;

import cz.cuni.amis.pogamut.base.agent.navigation.IPathExecutorState;
import cz.cuni.amis.pogamut.base.agent.navigation.IStuckDetector;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.stuckdetector.UT2004DistanceStuckDetector;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.stuckdetector.UT2004PositionStuckDetector;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.stuckdetector.UT2004TimeStuckDetector;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.AutoTraceRay;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.utils.flag.FlagListener;
import edu.utexas.cs.nn.Constants;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import mockcz.cuni.amis.pogamut.ut2004.agent.navigation.MyUTPathExecutor;
import mockcz.cuni.pogamut.Client.AgentMemory;
import utopia.Utils;
import utopia.agentmodel.Controller;
import utopia.agentmodel.actions.Action;
import utopia.agentmodel.actions.ApproachEnemyAction;
import utopia.agentmodel.actions.EmptyAction;
import utopia.agentmodel.actions.MoveAlongAction;
import utopia.agentmodel.actions.TurnAction;

public class ChasingController
extends Controller {
    public boolean startFollowing = false;
    public static final int MAX_TIMEOUT = 30;
    public int timeOut = -1;
    private Player lastSeenEnemy = null;
    public Player currentSeenEnemy = null;
    private boolean change = false;
    public static final int CLOSE_DISTANCE = 100;
    private int consecutiveTurns = 0;
    public static final int TOO_MANY_TURNS = 5;
    private Boolean turnRight;
    private final MyUTPathExecutor playerPathExecutor;
    public Location myLocationWhenEnemySeen = null;
    private static final double COLLISION_RISK_DISTANCE = 150.0;

    public ChasingController(UT2004Bot bot, final AgentMemory memory) {
        this.playerPathExecutor = memory.playerPathExecutor;
        this.register("Abort/Too Many Turns");
        this.register("Abort/What Direction");
        this.register("Turn To Find");
        this.register("Follow");
        this.register("Start Following");
        this.register("Timeout");
        this.register("Resume Following");
        this.register("Backtrack");
        this.register("Parallel to Wall");
        memory.playerPathExecutor.addStuckDetector((IStuckDetector)new UT2004TimeStuckDetector(bot, 3000.0, 10000.0));
        memory.playerPathExecutor.addStuckDetector((IStuckDetector)new UT2004PositionStuckDetector(bot));
        memory.playerPathExecutor.addStuckDetector((IStuckDetector)new UT2004DistanceStuckDetector(bot));
        memory.playerPathExecutor.getState().addStrongListener((FlagListener)new FlagListener<IPathExecutorState>(){

            public void flagChanged(IPathExecutorState changedValue) {
                String response = null;
                switch (changedValue.getState()) {
                    case PATH_COMPUTATION_FAILED: {
                        ChasingController.this.abort();
                        response = "Abort";
                    }
                    case STUCK: 
                    case TARGET_REACHED: {
                        if (response == null) {
                            memory.body.contMove();
                            response = "Forward";
                        }
                        if (!Constants.PRINT_ACTIONS.getBoolean()) break;
                        System.out.println("CHASE:" + changedValue.getState() + " -> " + response);
                    }
                }
            }
        });
    }

    @Override
    public Action control(AgentMemory memory) {
        if (!memory.playerPathExecutor.isExecuting() && memory.frontWallClose()) {
            System.out.println("\tAbout to crash!");
            AutoTraceRay trace = memory.frontRayTrace();
            if (trace != null) {
                Location wall = trace.getHitLocation();
                Location bot = memory.getAgentLocation().getLocation();
                if (bot != null && wall != null) {
                    Vector3d wallNormal = trace.getHitNormal();
                    Vector3d up = new Vector3d(0.0, 0.0, 1.0);
                    Vector3d cross = new Vector3d(0.0, 0.0, 0.0);
                    cross.cross(wallNormal, up);
                    cross.normalize();
                    cross.scale(500.0);
                    Location target = bot.add(new Location((Tuple3d)cross));
                    this.takeAction("Parallel to Wall");
                    System.out.println("\tParallel to wall! " + bot + " plus " + cross);
                    memory.body.body.getLocomotion().moveTo((ILocated)target);
                }
            }
        }
        if (this.consecutiveTurns > 5) {
            this.takeAction("Abort/Too Many Turns");
            this.reset();
            return null;
        }
        Location enemyLoc = this.lastEnemyLocation();
        Location botLoc = memory.info.getLocation();
        if (enemyLoc != null && botLoc != null && botLoc.getDistance(enemyLoc) < 100.0) {
            if (this.consecutiveTurns == 0) {
                this.turnRight = memory.isToMyRight(enemyLoc);
                if (this.turnRight == null) {
                    this.takeAction("Abort/What Direction");
                    this.abort();
                    return null;
                }
            }
            this.takeAction("Turn To Find");
            ++this.consecutiveTurns;
            return new TurnAction(memory, this.turnRight);
        }
        this.turnRight = null;
        this.consecutiveTurns = 0;
        if (!this.change && this.timeOut >= 0 && this.startFollowing && memory.info.isMoving().booleanValue()) {
            this.takeAction("Follow");
            return new EmptyAction();
        }
        if (!this.startFollowing) {
            if (memory.justLostOpponent(this.lastSeenEnemy) && this.myLocationWhenEnemySeen != null && botLoc != null && enemyLoc != null) {
                double toEnemy;
                double toWhereILastSaw = this.myLocationWhenEnemySeen.getDistance(botLoc);
                if (toWhereILastSaw < (toEnemy = botLoc.getDistance(enemyLoc)) && toWhereILastSaw > 100.0) {
                    this.takeAction("Backtrack");
                    return new MoveAlongAction((ILocated)this.myLocationWhenEnemySeen, (ILocated)enemyLoc, (ILocated)enemyLoc, false);
                }
                System.out.println(memory.info.getName() + ": Distances not right for backtrack");
            }
            this.takeAction("Start Following");
            System.out.println("\tMe:" + botLoc + ":target:" + enemyLoc);
            this.change = false;
            this.timeOut = 30;
            this.startFollowing = true;
            return new ApproachEnemyAction(memory, Utils.randomBool(), false, false, memory.getShortestTraceToWallDistance() < 150.0);
        }
        if (this.startFollowing && this.timeOut >= 0) {
            this.takeAction("Resume Following");
            this.change = false;
            return new ApproachEnemyAction(memory, Utils.randomBool(), false, false, memory.getShortestTraceToWallDistance() < 150.0);
        }
        this.reset();
        this.takeAction("Timeout");
        return null;
    }

    public void countdown() {
        if (this.timeOut > 0) {
            --this.timeOut;
        }
        if (this.timeOut == 0) {
            this.reset();
        }
    }

    @Override
    public synchronized void reset() {
        this.abort();
        this.change = false;
        this.consecutiveTurns = 0;
        this.lastSeenEnemy = null;
        this.myLocationWhenEnemySeen = null;
        this.currentSeenEnemy = null;
    }

    public void abort() {
        this.playerPathExecutor.stop();
        this.wasStuck = false;
        this.startFollowing = false;
        this.timeOut = -1;
    }

    public synchronized boolean enemyAvailable() {
        boolean result = this.lastSeenEnemy != null;
        return result;
    }

    public synchronized void enemyDies(UnrealId dead) {
        if (this.lastSeenEnemy != null && this.lastSeenEnemy.getId().equals((Object)dead)) {
            this.lastSeenEnemy = null;
            this.myLocationWhenEnemySeen = null;
        }
        if (this.currentSeenEnemy != null && this.currentSeenEnemy.getId().equals((Object)dead)) {
            this.currentSeenEnemy = null;
        }
    }

    public synchronized void updateEnemyMemory(AgentMemory memory) {
        this.currentSeenEnemy = memory.getCombatTarget();
        if (this.currentSeenEnemy != null) {
            if (!memory.canFocusOn(this.lastSeenEnemy)) {
                if (this.lastSeenEnemy == null || !this.currentSeenEnemy.getId().equals((Object)this.lastSeenEnemy.getId())) {
                    this.change = true;
                }
                this.lastSeenEnemy = this.currentSeenEnemy;
            }
            this.myLocationWhenEnemySeen = memory.info.getLocation();
        }
    }

    public String chaseTargetName(AgentMemory memory) {
        try {
            Player enemy = memory.players.getNearestEnemy(Constants.MEMORY_TIME.getDouble());
            return enemy.getName();
        }
        catch (NullPointerException e) {
            return "?";
        }
    }

    public synchronized Location lastEnemyLocation() {
        return this.lastSeenEnemy == null ? null : this.lastSeenEnemy.getLocation();
    }

    public synchronized Player getLastEnemy() {
        return this.lastSeenEnemy;
    }
}

