/*
 * Decompiled with CFR 0.152.
 */
package utopia.controllers.scripted;

import cz.cuni.amis.pogamut.base.agent.navigation.IPathExecutorState;
import cz.cuni.amis.pogamut.base.agent.navigation.IPathFuture;
import cz.cuni.amis.pogamut.base.agent.navigation.IStuckDetector;
import cz.cuni.amis.pogamut.base.utils.math.DistanceUtils;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.Weapon;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.stuckdetector.UT2004DistanceStuckDetector;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.stuckdetector.UT2004PositionStuckDetector;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.stuckdetector.UT2004TimeStuckDetector;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Item;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.utils.collections.MyCollections;
import cz.cuni.amis.utils.flag.FlagListener;
import cz.cuni.amis.utils.future.FutureStatus;
import edu.utexas.cs.nn.Constants;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import mockcz.cuni.amis.pogamut.base.agent.navigation.PathPlanner;
import mockcz.cuni.amis.pogamut.ut2004.agent.navigation.MyUTPathExecutor;
import mockcz.cuni.pogamut.Client.AgentMemory;
import utopia.Utils;
import utopia.agentmodel.ActionLog;
import utopia.agentmodel.actions.Action;
import utopia.agentmodel.actions.EmptyAction;
import utopia.agentmodel.actions.OpponentRelativeAction;
import utopia.agentmodel.actions.PathToLocationAction;
import utopia.controllers.scripted.PathController;

public class DistantPathController
extends PathController {
    public static final int ITEM_IGNORE_TIME = 30;
    protected final AgentMemory memory;
    public int currentPlanner = 0;
    public static final int SHORT_REMEAINING_PATH_LENGTH = 0;
    public boolean focused = false;
    private double lastNewPathTime = 0.0;
    public static final double MINIMUM_PATH_CHANCE = 4.0;
    public int[] pathActions = null;
    public static boolean SHOOT_ON_RUN = true;
    public static final int NUM_PATH_PLANNERS = 2;
    public int[] pathPlannerActions = new int[2];
    public static final int PATH_PLANNER_UTASTAR = 0;
    public static final int PATH_PLANNER_FLOYD_WARSHALL = 1;

    public Action getItem(AgentMemory memory, Item item) {
        if (item != null) {
            Action temp = this.newPathAction(item);
            this.focused = true;
            return temp;
        }
        return null;
    }

    public Action getNeededWeapon(AgentMemory memory) {
        Collection linkGuns = memory.items.getAllItems(ItemType.LINK_GUN).values();
        for (Item lg : linkGuns) {
            this.tabooItems.add((Object)lg);
        }
        Set weapons = this.tabooItems.filter(memory.items.getSpawnedItems(ItemType.Category.WEAPON).values());
        Item closest = (Item)DistanceUtils.getNearest((Collection)weapons, (ILocated)memory.info.getLocation());
        if (closest != null) {
            this.takeAction("Needed Weapon");
            Action temp = this.newPathAction(closest);
            this.focused = true;
            return temp;
        }
        return null;
    }

    public Action proceedToNavPoint(String id) {
        Map navs = this.memory.world.getAll(NavPoint.class);
        NavPoint navTarget = (NavPoint)navs.get(UnrealId.get((String)id));
        return this.newPathAction(navTarget);
    }

    protected Action newPathAction(NavPoint current) {
        IPathFuture<NavPoint> path = this.pathPlanner.computePath(current);
        if (path != null && path.getStatus().equals((Object)FutureStatus.FUTURE_IS_READY) && path.get() != null) {
            this.currentPlanner = 1;
            this.pathPlannerActions[1] = this.pathPlannerActions[1] + 1;
            this.lastNewPathTime = this.memory.game.getTime();
            return new PathToLocationAction(this.pathExecutor, path, current.getLocation());
        }
        return this.newPathAction(current.getLocation());
    }

    protected Action newPathAction(Item current) {
        if (!this.wasStuck && current != null && this.item != null && current.getLocation() != null && current.getLocation().equals(this.item.getLocation(), 20.0)) {
            return new EmptyAction();
        }
        this.stop();
        this.item = current;
        this.focused = false;
        if (current.getNavPoint() == null) {
            return this.newPathAction(current.getLocation());
        }
        return this.newPathAction(current.getNavPoint());
    }

    protected Action newPathAction(Location current) {
        if (current == null) {
            System.out.println("Null location in newPathAction()");
            return new EmptyAction();
        }
        this.currentPlanner = 0;
        this.pathPlannerActions[0] = this.pathPlannerActions[0] + 1;
        this.lastNewPathTime = this.memory.game.getTime();
        return new PathToLocationAction(this.pathExecutor, this.pathPlanner, current);
    }

    public void pathEvent(boolean makeTaboo) {
        if (this.item != null && makeTaboo) {
            this.tabooItems.add((Object)this.item, 30.0);
            this.tabooNavPoints.add((Object)this.item.getNavPoint(), 30.0);
        }
        this.reset();
    }

    public DistantPathController(UT2004Bot bot, MyUTPathExecutor pathExecutor, PathPlanner pathPlanner, final AgentMemory memory) {
        super(bot, pathExecutor, pathPlanner);
        this.memory = memory;
        this.register("Needed Weapon");
        this.register("Follow and Shoot");
        this.register("Just Follow");
        this.register("Random Far Item");
        this.register("Failed Path Replan");
        this.register("Path After State Change");
        pathExecutor.addStuckDetector((IStuckDetector)new UT2004TimeStuckDetector(bot, 3000.0, 10000.0));
        pathExecutor.addStuckDetector((IStuckDetector)new UT2004PositionStuckDetector(bot));
        pathExecutor.addStuckDetector((IStuckDetector)new UT2004DistanceStuckDetector(bot));
        pathExecutor.getState().addStrongListener((FlagListener)new FlagListener<IPathExecutorState>(){

            public void flagChanged(IPathExecutorState changedValue) {
                switch (changedValue.getState()) {
                    case PATH_COMPUTATION_FAILED: 
                    case TARGET_REACHED: 
                    case STUCK: {
                        boolean lastPathRecent;
                        DistantPathController.this.focused = false;
                        DistantPathController.this.pathEvent(true);
                        double timeDiff = memory.game.getTime() - DistantPathController.this.lastNewPathTime;
                        boolean bl = lastPathRecent = timeDiff < 4.0;
                        if (lastPathRecent) break;
                        Action a = DistantPathController.this.newPathAction(DistantPathController.this.farthestOfX(3));
                        if (Constants.PRINT_ACTIONS.getBoolean()) {
                            System.out.println("PATH:" + changedValue.getState() + " -> NEXT:" + DistantPathController.this.itemName() + ":" + a);
                        }
                        DistantPathController.this.takeAction("Path After State Change");
                        a.execute(memory.body);
                    }
                }
            }
        });
    }

    @Override
    public String lastActionLabel() {
        String type = "";
        switch (this.currentPlanner) {
            case 0: {
                type = "A*";
                break;
            }
            case 1: {
                type = "FW";
            }
        }
        return (this.focused ? "FOCUSED:" : "") + type + ":" + super.lastActionLabel();
    }

    @Override
    public Action control(AgentMemory memory) {
        boolean isMoving;
        Integer pathLength = this.pathExecutor.remainingPathSize();
        boolean longLengthLeft = pathLength == null || pathLength > 0;
        double timeDiff = memory.game.getTime() - this.lastNewPathTime;
        boolean lastPathRecent = timeDiff < 4.0;
        boolean nullItem = this.getItem() == null;
        boolean bl = isMoving = this.pathExecutor.isMoving() || memory.onElevator();
        if (!this.wasStuck && !this.retraceFailed && !nullItem && (isMoving || lastPathRecent) && (this.focused || longLengthLeft || lastPathRecent)) {
            Player enemy = memory.getCombatTarget();
            Weapon weapon = memory.getCurrentWeapon();
            if (SHOOT_ON_RUN && enemy != null && memory.info.isFacing((ILocated)enemy).booleanValue() && enemy.isVisible() && weapon != null && !weapon.getType().equals((Object)ItemType.LINK_GUN)) {
                this.takeAction("Follow and Shoot");
                this.pathExecutor.setFocus((ILocated)enemy);
                OpponentRelativeAction.shootDecision(memory, enemy, true, false);
            } else {
                this.takeAction("Just Follow");
                this.pathExecutor.setFocus(null);
                if (memory.info.isShooting().booleanValue()) {
                    memory.body.stopShoot();
                }
            }
        } else {
            System.out.println("Need New Path: " + (this.wasStuck ? "wasStuck " : "") + (this.retraceFailed ? "retraceFailed " : "") + (nullItem ? "nullItem " : "") + (!isMoving ? "not moving " : "") + (!this.focused ? "not focused " : "") + (!longLengthLeft ? "not longLengthLeft " : "") + (!lastPathRecent ? "not lastPathRecent " : ""));
            this.lastNewPathTime = memory.game.getTime();
            this.pathExecutor.setFocus(null);
            Action result = this.newPathAction(this.farthestOfX(3));
            if (result instanceof PathToLocationAction) {
                this.takeAction("Random Far Item");
            } else {
                this.takeAction("Failed Path Replan");
            }
            this.wasStuck = false;
            this.retraceFailed = false;
            return result;
        }
        EmptyAction result = new EmptyAction();
        return result;
    }

    @Override
    public void logActionChoices(PrintWriter actionLog) {
        super.logActionChoices(actionLog);
        actionLog.println("PLANNED PATHS");
        int totalPathsPlanned = this.pathPlannerActions[0] + this.pathPlannerActions[1];
        actionLog.println("Total Paths Planned: " + totalPathsPlanned);
        actionLog.println(ActionLog.actionLogLine(null, "UT A Star     ", this.pathPlannerActions[0], totalPathsPlanned));
        actionLog.println(ActionLog.actionLogLine(null, "Floyd Warshall", this.pathPlannerActions[1], totalPathsPlanned));
        actionLog.println();
    }

    @Override
    public void reset() {
        this.focused = false;
        super.reset();
    }

    protected Collection<Item> allGoodItems() {
        Collection spawned = this.memory.items.getSpawnedItems().values();
        Set items = this.tabooItems.filter(spawned);
        Iterator itr = items.iterator();
        while (itr.hasNext()) {
            Item i = (Item)itr.next();
            if (DistantPathController.wantItem(this.memory, i)) continue;
            itr.remove();
        }
        return items;
    }

    protected Collection<Item> goodItems() {
        Collection<Object> items;
        boolean noSafeItems;
        Collection<Object> candidates = this.allGoodItems();
        candidates.remove(this.item);
        boolean emptyCandidates = candidates.isEmpty();
        if (emptyCandidates) {
            candidates = this.memory.items.getAllItems(ItemType.Category.WEAPON).values();
            Iterator<Object> itr = candidates.iterator();
            while (itr.hasNext()) {
                if (!((Item)itr.next()).getType().equals((Object)ItemType.LINK_GUN)) continue;
                itr.remove();
            }
        }
        if (noSafeItems = (items = this.tabooItems.filter(candidates)).isEmpty()) {
            items = candidates;
            System.out.println("\tClear " + this.tabooItems.size() + " taboo items");
            this.tabooItems.clear();
        }
        HashSet<Item> sameLevel = new HashSet<Item>();
        Location botFloorLocation = this.memory.info.getFloorLocation();
        double magicLevel = 20.0;
        for (Item item : items) {
            if (!(botFloorLocation.z - 20.0 < item.getLocation().z)) continue;
            sameLevel.add(item);
        }
        if (!sameLevel.isEmpty()) {
            System.out.println("\tPursue items at current level or higher");
            items = sameLevel;
        }
        HashSet<Item> visible = new HashSet<Item>();
        for (Item item : items) {
            if (!item.isVisible()) continue;
            visible.add(item);
        }
        if (!visible.isEmpty()) {
            System.out.println("\tPursue visible items");
            items = visible;
        }
        System.out.println("\t" + items.size() + " options");
        return items;
    }

    protected Item farthestOfX(int num) {
        Collection<Item> candidates = this.goodItems();
        ArrayList<Item> keepers = new ArrayList<Item>(num);
        for (int i = 0; i < num; ++i) {
            Item option = (Item)MyCollections.getRandom(candidates);
            System.out.println("\tOption:" + option.getType().getName());
            keepers.add(option);
        }
        return Utils.getFarthest(candidates, (ILocated)this.memory.info.getLocation());
    }
}

