/*
 * Decompiled with CFR 0.152.
 */
package utopia.controllers.scripted;

import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.Weapon;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotDamaged;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerDamaged;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerScore;
import java.util.HashMap;
import java.util.Map;
import mockcz.cuni.pogamut.Client.AgentBody;
import mockcz.cuni.pogamut.Client.AgentMemory;
import utopia.agentmodel.Controller;
import utopia.agentmodel.actions.Action;
import utopia.agentmodel.actions.ApproachEnemyAction;

public class JudgingController
extends Controller {
    public static final int REQUIRED_JUDGING_HITS = 1;
    public static final int MIN_INTERACTION_TIME_STEPS = 75;
    public static final int MAX_JUDGING_DISTANCE = 2500;
    public static final double HUMAN_BIAS_FACTOR = 1.35;
    public HashMap<String, Integer> judgments;
    public HashMap<String, Integer> sightings;
    public HashMap<String, String> assignedLabels;
    public HashMap<String, Boolean> pendingJudgement;
    public HashMap<String, Integer> playerScores;
    public final AgentBody body;
    public static final String HUMAN = "Human";
    public static final String BOT = "Bot";
    public static final String UNKNOWN = "Unknown";
    private final Double matchTime;
    public Player judgeTarget = null;
    private boolean judgeAsHuman = false;
    public double lastJudgmentTime;
    public int currentJudgingHits = 0;
    private final Controller battleController;
    IWorldEventListener<PlayerDamaged> playerDamagedHandler = new IWorldEventListener<PlayerDamaged>(){

        public void notify(PlayerDamaged pd) {
            JudgingController.this.onPlayerDamaged(pd);
        }
    };
    IWorldEventListener<BotDamaged> botDamagedHandler = new IWorldEventListener<BotDamaged>(){

        public void notify(BotDamaged bd) {
            if (bd == null || bd.getDamageType() == null) {
                return;
            }
            if (bd.getDamageType().equals("GameBots2004.BotPrizeDamageType")) {
                System.out.println("JUDGE: Opponent Judged Me: " + (bd.getInstigator() == null ? "???" : bd.getInstigator().getStringId()));
            }
        }
    };
    IWorldEventListener<PlayerScore> globalListener = new IWorldEventListener<PlayerScore>(){

        public void notify(PlayerScore event) {
            JudgingController.this.playerScores.put(event.getId().getStringId(), event.getScore());
        }
    };

    private boolean enoughInteractionForAnotherJudgment(int numSightings, int numJudgments) {
        return (double)numSightings >= 75.0 * Math.pow(numJudgments + 1, 2.0);
    }

    public boolean judgingTargetAvailable(AgentMemory memory) {
        if (this.judgeTarget != null) {
            String key = this.judgeTarget.getId().getStringId();
            Integer numJudgments = this.judgments.get(key);
            Integer numSightings = this.sightings.get(key);
            if (numSightings == null || numJudgments == null) {
                return false;
            }
            if (!this.enoughInteractionForAnotherJudgment(numSightings, numJudgments)) {
                return false;
            }
            Player vis = memory.players.getVisiblePlayer(this.judgeTarget.getId());
            if (vis != null) {
                memory.lastPlayerDamaged = vis.getId();
                return true;
            }
            return false;
        }
        return false;
    }

    public JudgingController(AgentMemory memory, Controller battleController) {
        this.battleController = battleController;
        this.body = memory.body;
        this.pendingJudgement = new HashMap();
        this.judgments = new HashMap();
        this.judgments.put("SELF", 1);
        this.sightings = new HashMap();
        this.playerScores = new HashMap();
        this.assignedLabels = new HashMap();
        this.assignedLabels.put("SELF", BOT);
        this.matchTime = memory.game.getTimeLimit();
        this.lastJudgmentTime = 0.0;
        memory.world.addEventListener(PlayerDamaged.class, this.playerDamagedHandler);
        memory.world.addEventListener(BotDamaged.class, this.botDamagedHandler);
        memory.world.addEventListener(PlayerScore.class, this.globalListener);
    }

    public void onPlayerDamaged(PlayerDamaged pd) {
        if (pd == null || pd.getDamageType() == null || this.judgeTarget == null) {
            return;
        }
        if (pd.getDamageType().equals("XWeapons.DamTypeLinkPlasma")) {
            System.out.println("JUDGE: Hit " + pd.getId().getStringId() + " With Judging Gun");
            ++this.currentJudgingHits;
            if (this.currentJudgingHits > 1) {
                System.out.println("JUDGE: Done judging " + pd.getId().getStringId());
                this.currentJudgingHits = 0;
                this.lastJudgmentTime = this.body.game.getTime();
                this.assignLabel(pd.getId(), this.judgeAsHuman ? HUMAN : BOT);
            }
        }
    }

    @Override
    public Action control(AgentMemory memory) {
        this.judgeAsHuman = this.isHuman(memory);
        Weapon w = memory.weaponry.getCurrentWeapon();
        if (w == null || !w.getType().equals((Object)ItemType.LINK_GUN)) {
            memory.changeWeapon(ItemType.LINK_GUN);
            memory.linkGunSwitchTime = memory.game.getTime();
        }
        Player target = this.judgingTargetAvailable(memory) ? this.judgeTarget : memory.getCombatTarget();
        this.setJudgingTarget(memory, target);
        if (memory.info.getLocation() != null && this.judgeTarget != null && this.judgeTarget.getLocation() != null && memory.info.getLocation().getDistance(this.judgeTarget.getLocation()) > 600.0) {
            return new ApproachEnemyAction(memory, true, this.judgeAsHuman, false, false);
        }
        return this.battleController.control(memory);
    }

    public void setJudgingTarget(AgentMemory memory, Player target) {
        this.judgeTarget = target;
        memory.setJudgingTarget(this.judgeTarget);
    }

    @Override
    public void reset() {
        this.judgeTarget = null;
        this.currentJudgingHits = 0;
    }

    private void firstSightingCheck(String key) {
        if (!this.judgments.containsKey(key)) {
            this.judgments.put(key, 0);
        }
        if (!this.sightings.containsKey(key)) {
            this.sightings.put(key, 0);
        }
        if (!this.assignedLabels.containsKey(key)) {
            this.assignedLabels.put(key, UNKNOWN);
        }
    }

    private boolean seeTargetPendingJudgement(AgentMemory memory) {
        Map enemies = memory.players.getVisibleEnemies();
        for (Player e : enemies.values()) {
            String key = e.getId().getStringId();
            Boolean isPending = this.pendingJudgement.get(key);
            if (isPending == null || !isPending.booleanValue()) continue;
            this.setJudgingTarget(memory, e);
            System.out.println(e.getName() + " is pending judgment");
            return true;
        }
        return false;
    }

    public boolean shouldJudge(AgentMemory memory) {
        if (this.seeTargetPendingJudgement(memory)) {
            System.out.println("Target is pending judgment");
            return true;
        }
        Player nearest = memory.info.getNearestVisiblePlayer();
        if (nearest != null) {
            String key = nearest.getId().getStringId();
            String weapon = nearest.getWeapon();
            this.firstSightingCheck(key);
            int numSightings = this.sightings.get(key) + 1;
            this.sightings.put(key, numSightings);
            Location loc = nearest.getLocation();
            if (loc == null || loc.getDistance(memory.info.getLocation()) > 2500.0) {
                return false;
            }
            Integer numJudgments = this.judgments.get(key);
            if (this.enoughInteractionForAnotherJudgment(numSightings, numJudgments)) {
                Double rt = memory.game.getRemainingTime();
                if (rt == null) {
                    System.out.println("Judge because remaining time is null");
                    return true;
                }
                double remainingTime = rt;
                boolean shouldJudge = this.timeForJudgement(numSightings, remainingTime, weapon);
                if (shouldJudge) {
                    System.out.println("Make " + nearest.getName() + " new pending judgment target");
                    this.setJudgingTarget(memory, nearest);
                    this.pendingJudgement.put(key, true);
                }
                return shouldJudge;
            }
        } else if (memory.info.isShooting().booleanValue() && memory.weaponry.getCurrentWeapon().getType().equals((Object)ItemType.LINK_GUN)) {
            this.body.stopShoot();
        }
        return false;
    }

    private boolean timeForJudgement(int numSightings, double remainingTime, String weapon) {
        if (numSightings < 75) {
            return false;
        }
        if (remainingTime == 0.0) {
            return true;
        }
        double pJudge = 1.0 - Math.pow(0.99, numSightings - 75);
        if (this.matchTime != null) {
            double portionTimeLeft = remainingTime / this.matchTime;
            pJudge *= 1.0 - portionTimeLeft;
        }
        if (weapon.equals("XWeapons.LinkGun")) {
            pJudge += (1.0 - pJudge) / 2.0;
        }
        return Math.random() < pJudge;
    }

    private boolean isHuman(AgentMemory memory) {
        Player target;
        double pHuman = this.probabilityTargetIsHuman(memory);
        if (pHuman == 0.0) {
            return false;
        }
        Player player = target = this.judgingTargetAvailable(memory) ? this.judgeTarget : memory.getCombatTarget();
        if (target == null) {
            return false;
        }
        String key = target.getId().getStringId();
        String currentLabel = this.assignedLabels.get(key);
        if (currentLabel != null) {
            if (currentLabel.equals(BOT)) {
                return true;
            }
            if (currentLabel.equals(HUMAN)) {
                return false;
            }
        }
        if (target != null) {
            boolean sniping;
            boolean judgingMeAsBot;
            String weapon = target.getWeapon();
            boolean judging = weapon != null && weapon.equals("XWeapons.LinkGun");
            boolean bl = judgingMeAsBot = target.getFiring() == 1;
            if (judging && judgingMeAsBot) {
                return true;
            }
            boolean notFiring = target.getFiring() == 0;
            boolean notMoving = target.getVelocity() != null && target.getVelocity().isZero();
            boolean bl2 = sniping = weapon != null && (weapon.equals("XWeapons.SniperRifle") || weapon.equals("UTClassic.ClassicSniperRifle"));
            if (notFiring && notMoving && !sniping) {
                return false;
            }
        }
        return Math.random() < pHuman * 1.35;
    }

    private int numberAssigned(String type) {
        int result = 0;
        for (String judgement : this.assignedLabels.values()) {
            if (!judgement.equals(type)) continue;
            ++result;
        }
        return result;
    }

    private int numberAssignedHumans() {
        return this.numberAssigned(HUMAN);
    }

    private int numberAssignedBots() {
        return this.numberAssigned(BOT);
    }

    private int numberPlayers(AgentMemory memory) {
        return memory.players.getPlayers().size();
    }

    private int numberUnassigned(AgentMemory memory) {
        return this.numberPlayers(memory) - (this.numberAssignedHumans() + this.numberAssignedBots());
    }

    private double expectedHumans(AgentMemory memory) {
        return (double)this.numberPlayers(memory) / 2.0;
    }

    private double remainingHumans(AgentMemory memory) {
        double result = this.expectedHumans(memory) - (double)this.numberAssignedHumans();
        return Math.max(result, 0.0);
    }

    private double probabilityTargetIsHuman(AgentMemory memory) {
        return this.remainingHumans(memory) / (1.0 * (double)this.numberUnassigned(memory));
    }

    private void assignLabel(UnrealId id, String classification) {
        this.assignLabel(id.getStringId(), classification);
    }

    private void assignLabel(String key, String classification) {
        int numJudgments = this.judgments.get(key);
        String label = this.assignedLabels.get(key);
        if (!label.equals(classification)) {
            this.judgments.put(key, numJudgments + 1);
            this.assignedLabels.put(key, classification);
        }
        this.pendingJudgement.put(key, false);
    }
}

