/*
 * Decompiled with CFR 0.152.
 */
package utopia.controllers.scripted;

import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import mockcz.cuni.pogamut.Client.AgentMemory;
import utopia.agentmodel.Controller;
import utopia.agentmodel.actions.Action;
import utopia.agentmodel.actions.ApproachEnemyAction;
import utopia.agentmodel.actions.AvoidEnemyAction;
import utopia.agentmodel.actions.OpponentRelativeAction;
import utopia.agentmodel.actions.StillAction;
import utopia.controllers.TWEANN.TWEANNController;

public class ObservingController
extends Controller {
    public static final double ABLE_TO_OBSERVE_DISTANCE = 800.0;
    public static final double TOO_CLOSE_DISTANCE = 400.0;
    private final TWEANNController battleController;

    public ObservingController(TWEANNController battleController) {
        this.battleController = battleController;
    }

    @Override
    public void registerActions() {
        this.register("Approach From Far");
        this.register("Still On High Ground");
        this.register("Retreat Because Close");
        this.register("Battle Action");
    }

    @Override
    public Action control(AgentMemory memory) {
        double nearestDistance;
        Player enemy = memory.getCombatTarget();
        double distance = enemy == null ? Double.MAX_VALUE : memory.info.getLocation().getDistance(enemy.getLocation());
        Player nearest = memory.getSeeEnemy();
        double d = nearestDistance = nearest == null ? Double.MAX_VALUE : memory.info.getLocation().getDistance(nearest.getLocation());
        if (enemy != null && nearestDistance > 900.0 && distance > 800.0 && !memory.botHasHighGround()) {
            this.takeAction("Approach From Far");
            memory.changeWeapon(ItemType.LINK_GUN);
            return new ApproachEnemyAction(memory, false, false, false, false);
        }
        if (memory.botHasHighGround() && !memory.isThreatened()) {
            this.takeAction("Still On High Ground");
            return new StillAction(memory, false, false, false);
        }
        Action action = this.battleController.control(memory);
        if (action instanceof OpponentRelativeAction) {
            OpponentRelativeAction result = (OpponentRelativeAction)action;
            result.observe();
            if (enemy != null && distance < 400.0 && result instanceof ApproachEnemyAction) {
                this.takeAction("Retreat Because Close");
                return new AvoidEnemyAction(memory, false, false, false);
            }
        }
        this.takeAction("Battle Action");
        return action;
    }

    @Override
    public void reset() {
    }
}

