/*
 * Decompiled with CFR 0.152.
 */
package utopia.controllers.scripted;

import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Item;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import mockcz.cuni.pogamut.Client.AgentMemory;
import mockcz.cuni.pogamut.MessageObjects.Triple;
import utopia.agentmodel.Controller;
import utopia.agentmodel.actions.Action;
import utopia.agentmodel.actions.ApproachEnemyAction;
import utopia.agentmodel.actions.AvoidEnemyAction;
import utopia.controllers.scripted.PathController;

public class ShieldGunController
extends Controller {
    Item target = null;
    private final PathController pathController;
    public static final double SHIELD_RUSH_RANGE = 500.0;

    public ShieldGunController(PathController pathController) {
        this.pathController = pathController;
    }

    @Override
    public void registerActions() {
        this.register("Shield Attack");
        this.register("Retreat");
        this.register("Fall Through");
        this.register("Item Path");
    }

    @Override
    public Action control(AgentMemory memory) {
        Player nearest = memory.getSeeEnemy();
        this.target = this.getTarget(memory);
        if (nearest != null && memory.info.getLocation() != null) {
            memory.lastPlayerDamaged = null;
            double enemyDistance = memory.info.getLocation().getDistance(nearest.getLocation());
            double itemDistance = Double.MAX_VALUE;
            if (this.target != null) {
                itemDistance = memory.info.getLocation().getDistance(this.target.getLocation());
            }
            if (itemDistance > enemyDistance) {
                if (enemyDistance < 500.0) {
                    this.takeAction("Shield Attack");
                    return new ApproachEnemyAction(memory, true, false, false, false);
                }
                if (nearest.getFiring() != 0 && enemyDistance < 2500.0 && !memory.senses.isColliding()) {
                    this.takeAction("Retreat");
                    return new AvoidEnemyAction(memory, true, true, Math.random() < 0.6);
                }
            }
        }
        if (this.target == null) {
            this.takeAction("Fall Through");
            return null;
        }
        this.takeAction("Item Path");
        return this.pathController.control(memory);
    }

    public Item getTarget(AgentMemory memory) {
        Triple agentLoc = memory.getAgentLocation();
        if (agentLoc == null) {
            return null;
        }
        Player nearest = memory.getSeeEnemy();
        Triple toEnemy = new Triple(0.0, 0.0, 0.0);
        if (nearest != null) {
            Triple enemyLoc = Triple.locationToTriple(nearest.getLocation());
            toEnemy = Triple.subtract(enemyLoc, agentLoc);
        }
        Item closestWeapon = memory.getNearestWeapon(toEnemy);
        Item closestAmmo = memory.getNearestUsableAmmo(toEnemy);
        Item winner = null;
        if (closestWeapon == null || memory.weaponry.hasWeapon(closestWeapon.getType())) {
            winner = closestAmmo;
        } else if (closestAmmo == null) {
            winner = closestWeapon;
        } else {
            double weaponDistance;
            double ammoDistance;
            Triple ammoLoc = Triple.locationToTriple(closestAmmo.getLocation());
            Triple weaponLoc = Triple.locationToTriple(closestWeapon.getLocation());
            if (nearest != null) {
                ammoLoc = Triple.add(ammoLoc, toEnemy);
                weaponLoc = Triple.add(weaponLoc, toEnemy);
            }
            winner = (ammoDistance = Triple.distanceInSpace(ammoLoc, agentLoc)) < (weaponDistance = Triple.distanceInSpace(weaponLoc, agentLoc)) ? closestAmmo : closestWeapon;
        }
        return winner;
    }

    @Override
    public void reset() {
        this.target = null;
    }
}

