/*
 * Decompiled with CFR 0.152.
 */
package utopia.controllers.scripted;

import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import java.util.ArrayList;
import java.util.Map;
import mockcz.cuni.pogamut.Client.AgentMemory;
import mockcz.cuni.pogamut.MessageObjects.NavLocation;
import utopia.agentmodel.Controller;
import utopia.agentmodel.actions.Action;
import utopia.agentmodel.actions.MoveToLocationAction;
import utopia.agentmodel.actions.OpponentRelativeAction;

public class WaterController
extends Controller {
    private static ArrayList<NavLocation> pseudoNavPoints = null;
    ArrayList<NavLocation> ignoreList;
    NavLocation lastBestNav;
    int bestNavRepeats;
    int collisionsFromPath;
    private static final int SAME_NAV_TOLERANCE = 10;
    private static final int COLLISION_TOLERANCE = 5;

    private static ArrayList<NavLocation> getGoatswoodPseudoNavs() {
        if (pseudoNavPoints == null) {
            pseudoNavPoints = new ArrayList(40);
            pseudoNavPoints.add(new NavLocation(2351.0, 3464.0, -117.0));
            pseudoNavPoints.add(new NavLocation(2538.0, 3572.0, -110.0));
            pseudoNavPoints.add(new NavLocation(3271.0, 3202.0, -190.0));
            pseudoNavPoints.add(new NavLocation(3713.0, 3320.0, -169.0));
            pseudoNavPoints.add(new NavLocation(3995.0, 3282.0, -90.0));
            pseudoNavPoints.add(new NavLocation(4222.0, 4635.0, -170.0));
            pseudoNavPoints.add(new NavLocation(195.0, 2263.0, -145.0));
            pseudoNavPoints.add(new NavLocation(909.0, 2470.0, -138.0));
            pseudoNavPoints.add(new NavLocation(478.0, 2321.0, -131.0));
            pseudoNavPoints.add(new NavLocation(1260.0, 2644.0, -190.0));
            pseudoNavPoints.add(new NavLocation(1529.0, 2301.0, -190.0));
            pseudoNavPoints.add(new NavLocation(1756.0, 1945.0, -190.0));
            pseudoNavPoints.add(new NavLocation(2622.0, 2544.0, -190.0));
            pseudoNavPoints.add(new NavLocation(2336.0, 2911.0, -190.0));
            pseudoNavPoints.add(new NavLocation(2112.0, 3200.0, -190.0));
            pseudoNavPoints.add(new NavLocation(5474.0, 4369.0, -190.0));
            pseudoNavPoints.add(new NavLocation(5932.0, 3956.0, -191.0));
            pseudoNavPoints.add(new NavLocation(5606.0, 3653.0, -150.0));
            pseudoNavPoints.add(new NavLocation(-2799.0, -6752.0, -150.0));
            pseudoNavPoints.add(new NavLocation(-3400.0, -6558.0, -150.0));
            pseudoNavPoints.add(new NavLocation(-3865.0, -6196.0, -150.0));
            pseudoNavPoints.add(new NavLocation(-4108.0, -5706.0, -150.0));
            pseudoNavPoints.add(new NavLocation(-4229.0, -4957.0, -150.0));
            pseudoNavPoints.add(new NavLocation(-4068.0, -4243.0, -150.0));
            pseudoNavPoints.add(new NavLocation(-3288.0, -3852.0, -116.0));
            pseudoNavPoints.add(new NavLocation(-4264.0, -3734.0, -101.0));
            pseudoNavPoints.add(new NavLocation(-3634.0, -3826.0, -154.0));
            pseudoNavPoints.add(new NavLocation(-3999.0, -3787.0, -155.0));
            pseudoNavPoints.add(new NavLocation(-3772.0, -3300.0, -150.0));
            pseudoNavPoints.add(new NavLocation(-4496.0, -2039.0, -171.0));
            pseudoNavPoints.add(new NavLocation(-4525.0, -1320.0, -188.0));
            pseudoNavPoints.add(new NavLocation(-4059.0, 318.0, -185.0));
            pseudoNavPoints.add(new NavLocation(-4449.0, -858.0, -189.0));
            pseudoNavPoints.add(new NavLocation(-4227.0, -117.0, -190.0));
            pseudoNavPoints.add(new NavLocation(-3337.0, 1835.0, -187.0));
            pseudoNavPoints.add(new NavLocation(-3120.0, 2380.0, -173.0));
            pseudoNavPoints.add(new NavLocation(-2815.0, 2904.0, -121.0));
            pseudoNavPoints.add(new NavLocation(-1942.0, 2969.0, -106.0));
            pseudoNavPoints.add(new NavLocation(-1289.0, 2587.0, -162.0));
            pseudoNavPoints.add(new NavLocation(-624.0, 2093.0, -191.0));
            pseudoNavPoints.add(new NavLocation(4340.0, 4718.0, -187.0));
            pseudoNavPoints.add(new NavLocation(4117.0, 4664.0, -121.0));
        }
        return pseudoNavPoints;
    }

    public WaterController() {
        this.reset();
    }

    public Controller create() {
        return new WaterController();
    }

    @Override
    public Action control(AgentMemory memory) {
        Location loc = memory.info.getLocation();
        Location floor = memory.info.getFloorLocation();
        if (loc != null && floor != null) {
            double nearestDistance = Double.MAX_VALUE;
            NavLocation bestNav = null;
            Map navPoints = memory.world.getAll(NavPoint.class);
            ArrayList<NavLocation> navLocations = this.mergeWithPseudoNavs(memory, navPoints, floor.z, loc.z);
            for (NavLocation np : navLocations) {
                double navDis = np.getLocation().getDistance(loc);
                if (navDis < 50.0) {
                    this.ignoreList.add(np);
                    continue;
                }
                if (!(navDis < nearestDistance) || this.ignoreList.contains(np)) continue;
                nearestDistance = navDis;
                bestNav = np;
            }
            if (bestNav == null) {
                return null;
            }
            if (this.lastBestNav != null && bestNav.equals(this.lastBestNav)) {
                ++this.bestNavRepeats;
                if (memory.senses.isCollidingOnce()) {
                    ++this.collisionsFromPath;
                }
                if (this.bestNavRepeats > 10 || !memory.isMoving() || this.collisionsFromPath > 5) {
                    this.ignoreList.add(bestNav);
                    this.bestNavRepeats = 0;
                    this.collisionsFromPath = 0;
                }
            }
            System.out.println("Best nav: " + this.bestNavRepeats);
            this.lastBestNav = bestNav;
            Player enemy = memory.info.getNearestVisiblePlayer();
            if (enemy != null) {
                OpponentRelativeAction.shootDecision(memory, enemy, true, false);
            } else if (memory.info.isShooting().booleanValue()) {
                memory.body.stopShoot();
            }
            return new MoveToLocationAction(memory, bestNav.getLocation(), enemy);
        }
        return null;
    }

    @Override
    public void reset() {
        this.ignoreList = new ArrayList();
        this.lastBestNav = null;
        this.bestNavRepeats = 0;
        this.collisionsFromPath = 0;
    }

    private ArrayList<NavLocation> mergeWithPseudoNavs(AgentMemory memory, Map<WorldObjectId, NavPoint> navPoints, double floor_z, double loc_z) {
        ArrayList<NavLocation> navs = memory.game.getMapName().toLowerCase().equals("DM-GoatswoodPlay".toLowerCase()) ? WaterController.getGoatswoodPseudoNavs() : new ArrayList();
        for (NavPoint np : navPoints.values()) {
            if (WaterController.navHasName(np, "DM-GoatswoodPlay.PathNode186") || WaterController.navHasName(np, "DM-GoatswoodPlay.PathNode109") || WaterController.navHasName(np, "DM-GoatswoodPlay.PathNode94") || WaterController.navHasName(np, "DM-IceHenge.PathNode71") || WaterController.navHasName(np, "DM-IceHenge.InventorySpot100") || WaterController.navHasName(np, "DM-IceHenge.PlayerStart6") || WaterController.navHasName(np, "DM-IceHenge.PathNode93") || !(np.getLocation().z > floor_z) || !(np.getLocation().z < loc_z + 125.0)) continue;
            navs.add(new NavLocation(np));
        }
        return navs;
    }

    private static boolean navHasName(NavPoint np, String name) {
        return np.getId().getStringId().toLowerCase().equals(name.toLowerCase());
    }
}

