/*
 * Decompiled with CFR 0.152.
 */
package wox.serial;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.jdom.Element;
import wox.serial.EncodeBase64;
import wox.serial.ObjectReader;
import wox.serial.Serial;
import wox.serial.Util;

public class SimpleReader
implements ObjectReader {
    HashMap map = new HashMap();
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Class;

    public Object read(Element xob) {
        if (this.empty(xob)) {
            return null;
        }
        if (this.reference(xob)) {
            return this.map.get(xob.getAttributeValue("idref"));
        }
        Object ob = null;
        String id = xob.getAttributeValue("id");
        ob = this.primitiveArray(xob) ? this.readPrimitiveArray(xob, id) : (this.array(xob) ? this.readObjectArray(xob, id) : (Util.stringable(xob.getAttributeValue("type")) ? this.readStringObject(xob, id) : this.readObject(xob, id)));
        return ob;
    }

    public boolean empty(Element xob) {
        return !xob.getAttributes().iterator().hasNext() && !xob.getContent().iterator().hasNext();
    }

    public boolean reference(Element xob) {
        boolean ret = xob.getAttribute("idref") != null;
        return ret;
    }

    public boolean primitiveArray(Element xob) {
        if (!xob.getName().equals("array")) {
            return false;
        }
        String arrayType = xob.getAttributeValue("type");
        int i = 0;
        while (i < Serial.primitives.length) {
            if (Serial.primitives[i].getName().equals(arrayType)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean array(Element xob) {
        return xob.getName().equals("array");
    }

    public Object readPrimitiveArray(Element xob, Object id) {
        try {
            Class type = this.getPrimitiveType(xob.getAttributeValue("type"));
            Class wrapperType = this.getWrapperType(type);
            Constructor cons = wrapperType.getDeclaredConstructor(class$java$lang$String == null ? (class$java$lang$String = SimpleReader.class$("java.lang.String")) : class$java$lang$String);
            Object[] args = new Object[1];
            int len = Integer.parseInt(xob.getAttributeValue("length"));
            Object array = Array.newInstance(type, len);
            this.map.put(id, array);
            if (type.equals(Integer.TYPE)) {
                Object intArray = this.readIntArray((int[])array, xob);
                return intArray;
            }
            if (type.equals(Byte.TYPE)) {
                Object byteArray = this.readByteArray((byte[])array, xob);
                return byteArray;
            }
            StringTokenizer st = new StringTokenizer(xob.getText());
            int index = 0;
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                args[0] = s;
                Object value = cons.newInstance(args);
                Array.set(array, index++, value);
            }
            return array;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public Class getPrimitiveType(String name) {
        int i = 0;
        while (i < Serial.primitives.length) {
            if (Serial.primitives[i].getName().equals(name)) {
                return Serial.primitives[i];
            }
            ++i;
        }
        return null;
    }

    public Class getWrapperType(Class type) {
        int i = 0;
        while (i < Serial.primitives.length) {
            if (Serial.primitives[i].equals(type)) {
                return Serial.primitiveWrappers[i];
            }
            ++i;
        }
        return null;
    }

    public Class getWrapperType(String type) {
        int i = 0;
        while (i < Serial.primitives.length) {
            if (Serial.primitives[i].getName().equals(type)) {
                return Serial.primitiveWrappers[i];
            }
            ++i;
        }
        return null;
    }

    public Object readIntArray(int[] a, Element xob) {
        StringTokenizer st = new StringTokenizer(xob.getText());
        int index = 0;
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            a[index++] = Integer.parseInt(s);
        }
        return a;
    }

    public Object readByteArray(byte[] a, Element xob) {
        String strByte = xob.getText();
        a = strByte.getBytes();
        byte[] decodedArray = EncodeBase64.decode(a);
        return decodedArray;
    }

    public Object readObjectArray(Element xob, Object id) {
        try {
            String arrayTypeName = xob.getAttributeValue("type");
            int len = Integer.parseInt(xob.getAttributeValue("length"));
            Class componentType = this.getObjectArrayComponentType(arrayTypeName);
            Object array = Array.newInstance(componentType, len);
            this.map.put(id, array);
            List children = xob.getChildren();
            int index = 0;
            Iterator i = children.iterator();
            while (i.hasNext()) {
                Object childArray = this.read((Element)i.next());
                Array.set(array, index++, childArray);
            }
            return array;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public Class getObjectArrayComponentType(String arrayTypeName) throws Exception {
        return Class.forName(arrayTypeName);
    }

    public Object readStringObject(Element xob, Object id) {
        try {
            Class<?> type = Class.forName(xob.getAttributeValue("type"));
            if (type.equals(class$java$lang$Class == null ? (class$java$lang$Class = SimpleReader.class$("java.lang.Class")) : class$java$lang$Class)) {
                return Class.forName(xob.getText());
            }
            Class[] st = new Class[]{class$java$lang$String == null ? (class$java$lang$String = SimpleReader.class$("java.lang.String")) : class$java$lang$String};
            Constructor<?> cons = type.getDeclaredConstructor(st);
            Object ob = this.makeObject(cons, new String[]{xob.getText()}, id);
            return ob;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Object readObject(Element xob, Object id) {
        try {
            Class<?> type = Class.forName(xob.getAttributeValue("type"));
            Constructor cons = Util.forceDefaultConstructor(type);
            cons.setAccessible(true);
            Object ob = this.makeObject(cons, new Object[0], id);
            this.setFields(ob, xob);
            return ob;
        }
        catch (Exception e) {
            System.out.println(e);
            return null;
        }
    }

    public void setFields(Object ob, Element xob) {
        Class<?> type = ob.getClass();
        Iterator i = xob.getChildren().iterator();
        while (i.hasNext()) {
            Element fe = (Element)i.next();
            String name = fe.getAttributeValue("name");
            String declaredType = fe.getAttributeValue("declaredClass");
            try {
                Class<?> declaringType = declaredType != null ? Class.forName(declaredType) : type;
                Field field = this.getField(declaringType, name);
                field.setAccessible(true);
                Object value = null;
                if (Util.primitive(field.getType())) {
                    value = this.makeWrapper(field.getType(), fe.getAttributeValue("value"));
                } else {
                    Element child = (Element)fe.getChildren().iterator().next();
                    value = this.read(child);
                }
                field.set(ob, value);
            }
            catch (Exception e) {
                System.out.println(name + " : " + e);
            }
        }
    }

    public Object makeObject(Constructor cons, Object[] args, Object key) throws Exception {
        cons.setAccessible(true);
        Object value = cons.newInstance(args);
        this.map.put(key, value);
        return value;
    }

    public Object makeWrapper(Class type, String value) throws Exception {
        Class wrapperType = this.getWrapperType(type);
        Constructor cons = wrapperType.getDeclaredConstructor(class$java$lang$String == null ? (class$java$lang$String = SimpleReader.class$("java.lang.String")) : class$java$lang$String);
        return cons.newInstance(value);
    }

    public Field getField(Class type, String name) throws Exception {
        if (type == null) {
            return null;
        }
        try {
            return type.getDeclaredField(name);
        }
        catch (Exception e) {
            return this.getField(type.getSuperclass(), name);
        }
    }

    public void print(Constructor[] cons) {
        int i = 0;
        while (i < cons.length) {
            System.out.println(i + " : " + cons[i]);
            ++i;
        }
    }

    public Class getComponentType(String type) {
        int i = 0;
        while (i < Serial.primitiveArrays.length) {
            if (Serial.primitiveArrays[i].getName().equals(type)) {
                return Serial.primitives[i];
            }
            ++i;
        }
        return null;
    }

    public Class getArrayType(String type) {
        int i = 0;
        while (i < Serial.primitiveArrays.length) {
            if (Serial.primitiveArrays[i].getName().equals(type)) {
                return Serial.primitiveArrays[i];
            }
            ++i;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

