/*
 * Decompiled with CFR 0.152.
 */
package wox.serial;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Vector;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.Element;
import wox.serial.EncodeBase64;
import wox.serial.ObjectWriter;
import wox.serial.Serial;
import wox.serial.Util;

public class SimpleWriter
implements ObjectWriter {
    HashMap map = new HashMap();
    int count = 0;
    boolean writePrimitiveTypes = true;
    boolean doStatic = true;
    boolean doFinal = false;

    public Element write(Object ob) {
        Element el2;
        if (ob == null) {
            return new Element("object");
        }
        if (this.map.get(ob) != null) {
            Element el2 = new Element("object");
            el2.setAttribute("idref", this.map.get(ob).toString());
            return el2;
        }
        this.map.put(ob, new Integer(this.count++));
        if (Util.stringable(ob)) {
            el2 = new Element("object");
            el2.setAttribute("type", ob.getClass().getName());
            el2.setText(SimpleWriter.stringify(ob));
        } else if (ob.getClass().isArray()) {
            el2 = this.writeArray(ob);
        } else {
            el2 = new Element("object");
            el2.setAttribute("type", ob.getClass().getName());
            this.writeFields(ob, el2);
        }
        el2.setAttribute("id", this.map.get(ob).toString());
        return el2;
    }

    public Element writeArray(Object ob) {
        if (this.isPrimitiveArray(ob.getClass())) {
            return this.writePrimitiveArray(ob);
        }
        return this.writeObjectArray(ob);
    }

    public Element writeObjectArray(Object ob) {
        Element el = new Element("array");
        el.setAttribute("type", ob.getClass().getComponentType().getName());
        int len = Array.getLength(ob);
        el.setAttribute("length", "" + len);
        int i = 0;
        while (i < len) {
            el.addContent((Content)this.write(Array.get(ob, i)));
            ++i;
        }
        return el;
    }

    public Element writePrimitiveArray(Object ob) {
        Element el = new Element("array");
        el.setAttribute("type", ob.getClass().getComponentType().getName());
        int len = Array.getLength(ob);
        if (ob instanceof byte[]) {
            el.setText(this.byteArrayString((byte[])ob, el));
        } else {
            el.setAttribute("length", "" + len);
            el.setText(this.arrayString(ob, len));
        }
        return el;
    }

    public String byteArrayString(byte[] a, Element e) {
        byte[] target = EncodeBase64.encode(a);
        e.setAttribute("length", "" + target.length);
        String strTarget = new String(target);
        return strTarget;
    }

    public String arrayString(Object ob, int len) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < len) {
            if (i > 0) {
                sb.append(" ");
            }
            sb.append(Array.get(ob, i).toString());
            ++i;
        }
        return sb.toString();
    }

    public void writeFields(Object o, Element parent) {
        Class<?> cl = o.getClass();
        Field[] fields = SimpleWriter.getFields(cl);
        String name = null;
        int i = 0;
        while (i < fields.length) {
            if (!(!this.doStatic && Modifier.isStatic(fields[i].getModifiers()) || !this.doFinal && Modifier.isFinal(fields[i].getModifiers()))) {
                try {
                    fields[i].setAccessible(true);
                    name = fields[i].getName();
                    Object value = fields[i].get(o);
                    Element field = new Element("field");
                    field.setAttribute("name", name);
                    if (this.shadowed(fields, name)) {
                        field.setAttribute("declaredClass", fields[i].getDeclaringClass().getName());
                    }
                    if (fields[i].getType().isPrimitive()) {
                        if (this.writePrimitiveTypes) {
                            field.setAttribute("type", fields[i].getType().getName());
                        }
                        field.setAttribute("value", value.toString());
                    } else {
                        field.addContent((Content)this.write(value));
                    }
                    parent.addContent((Content)field);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.out.println(e);
                    parent.addContent((Content)new Comment(e.toString()));
                }
            }
            ++i;
        }
    }

    private boolean shadowed(Field[] fields, String fieldName) {
        int count = 0;
        int i = 0;
        while (i < fields.length) {
            if (fieldName.equals(fields[i].getName())) {
                ++count;
            }
            ++i;
        }
        return count > 1;
    }

    public static String stringify(Object ob) {
        if (ob instanceof Class) {
            return ((Class)ob).getName();
        }
        return ob.toString();
    }

    public static Field[] getFields(Class c) {
        int i;
        Vector<Field> v = new Vector<Field>();
        while (c != null) {
            Field[] fields = c.getDeclaredFields();
            i = 0;
            while (i < fields.length) {
                v.addElement(fields[i]);
                ++i;
            }
            c = c.getSuperclass();
        }
        Field[] f = new Field[v.size()];
        i = 0;
        while (i < f.length) {
            f[i] = (Field)v.get(i);
            ++i;
        }
        return f;
    }

    public static Object[] getValues(Object o, Field[] fields) {
        Object[] values = new Object[fields.length];
        int i = 0;
        while (i < fields.length) {
            try {
                fields[i].setAccessible(true);
                values[i] = fields[i].get(o);
                System.out.println(fields[i].getName() + "\t " + values[i]);
            }
            catch (Exception e) {
                System.out.println(e);
            }
            ++i;
        }
        return values;
    }

    public boolean isPrimitiveArray(Class c) {
        int i = 0;
        while (i < Serial.primitiveArrays.length) {
            if (c.equals(Serial.primitiveArrays[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

