/* File: globals.c
 *
 * Defines global variables for SPEC.
 *
 * Copyright (C) 1994 Risto Miikkulainen
 *
 *  This software can be copied, modified and distributed freely for
 *  educational and research purposes, provided that this notice is included
 *  in the code, and the author is acknowledged in any materials and reports
 *  that result from its use. It may not be used for commercial purposes
 *  without expressed permission from the author.
 *
 * $Id: globals.c,v 1.41 1994/09/05 02:23:25 risto Exp $
 */

#ifdef DEFINE_GLOBALS		/* Defined in the main.c file */
/* these definitions are in effect in main.c */

/* simulation parameters */
int displaying,			/* display on/off */
  testing,			/* testing or training */
  chain,			/* whether modules feed input to each other */
  seed,				/* random number seed */
  parseronly,			/* only parser or full spec */
  stacknouns,			/* stack training with all/occurring sentens */
  running[NMODULES],		/* which modules are actually included */
  fgrepping[NMODULES],		/* whether fgrep is done on this module */
  shuffling,			/* shuffled or fixed sentence order */
  simulationendepoch;		/* last epoch for the simulation */

/* learning rates: weights, words */
double eta, wordeta;

/* stack pointer */
int top;

/* actual table dimensions */
int nwordrep,			/* dimension of word reps */
  ninprep[NMODULES],		/* input layer dimension */
  nhidrep[NMODULES],		/* hidden layer dimension */
  noutrep[NMODULES],		/* output layer dimension */
  ninputs[NMODULES],		/* number of slots in the input layer */
  noutputs[NMODULES],		/* number of slots in the output layer */
  nwords = 0,			/* number of words in lexicon */
  nnouns = 0,			/* number of nouns (for stack training) */
  nsents = 0,			/* number of sentences */
  ncase = NONE;			/* number of cases */

/* lexicon */
WORDSTRUCT *words;		/* lexicon */
int whoindex = BLANKINDEX,	/* index of "who" */
  theindex = BLANKINDEX;	/* index of "the" */

/* input data */
SENTSTRUCT sents[MAXSENTS];	/* sentence input data */
int nouns[MAXWORDS];		/* noun list */
int inputs[NMODULES][MAXFRAGS],	/* indices of current input items */
  targets[NMODULES][MAXFRAGS];	/* indices of current target items */
int shuffletable[MAXSENTS];	/* order of sentence presentations */

/* units and weights */
double
  inprep[NMODULES][MAXLAYER],		/* input units (includes prevhidrep) */
  hidrep[NMODULES][MAXLAYER],		/* hidden units */
  outrep[NMODULES][MAXLAYER],		/* output units */
  tgtrep[NMODULES][MAXLAYER],		/* target values */
  wih[NMODULES][MAXLAYER][MAXLAYER],	/* input to hidden weights */
  who[NMODULES][MAXLAYER][MAXLAYER];	/* hidden to output weights */

/* file names */
char simufile[MAXFILENAMEL + 1],	/* simulation specifications */
  current_inpfile[MAXFILENAMEL + 1],	/* name of the actual input file */
  inputfile[MAXFILENAMEL + 1];		/* input file specified in simufile */

/* graphics data */
XtAppContext app_con;			/* application context */
Display *theDisplay;			/* display pointer */
Visual *visual;				/* type of display */
Colormap colormap;			/* colormap definition */
Widget main_widget, form;		/* main widget and organization */
NETSTRUCT net[NMODULES];		/* outline of network geometry etc. */
RESOURCE_DATA data;			/* resource data structure */


/************ end definitions *************/

#else
/* these definitions are in effect in all other files except main.c */

extern int displaying,
  testing,
  chain,
  seed,
  parseronly,
  stacknouns,
  running[NMODULES],
  fgrepping[NMODULES],
  shuffling,
  simulationendepoch;
extern int top;
extern double eta, wordeta;
extern int nwordrep,
  ninprep[NMODULES],
  nhidrep[NMODULES],
  noutrep[NMODULES],
  ninputs[NMODULES],
  noutputs[NMODULES],
  nwords,
  nnouns,
  nsents,
  ncase;
extern WORDSTRUCT *words;
extern int nouns[MAXWORDS];
extern int whoindex, theindex;
extern SENTSTRUCT sents[MAXSENTS];
extern int inputs[NMODULES][MAXFRAGS],
  targets[NMODULES][MAXFRAGS];
extern int shuffletable[MAXSENTS];
extern double
  inprep[NMODULES][MAXLAYER],
  hidrep[NMODULES][MAXLAYER],
  outrep[NMODULES][MAXLAYER],
  tgtrep[NMODULES][MAXLAYER],
  wih[NMODULES][MAXLAYER][MAXLAYER],
  who[NMODULES][MAXLAYER][MAXLAYER];
extern char simufile[MAXFILENAMEL + 1],
  current_inpfile[MAXFILENAMEL + 1],
  inputfile[MAXFILENAMEL + 1];
extern XtAppContext app_con;
extern Display *theDisplay;
extern Visual *visual;
extern Colormap colormap;
extern Widget main_widget, form;
extern NETSTRUCT net[NMODULES];
extern RESOURCE_DATA data;

#endif /*  #ifdef DEFINE_GLOBALS */
