/* File: prototypes.h
 *
 * Prototypes for global functions.
 *
 * Copyright (C) 1994 Risto Miikkulainen
 *
 *  This software can be copied, modified and distributed freely for
 *  educational and research purposes, provided that this notice is included
 *  in the code, and the author is acknowledged in any materials and reports
 *  that result from its use. It may not be used for commercial purposes
 *  without expressed permission from the author.
 *
 * $Id: prototypes.h,v 1.20 1994/09/20 10:48:27 risto Exp $
 */

/********* defined in main.c *************/
int find_nearest __P ((double rep[], WORDSTRUCT words[],
		       int nrep, int nwords));
int imin __P ((int a, int b));
int imax __P ((int a, int b));

/********* defined in nets.c ***********/
void iterate_sentences __P ((void));
void run_stack_all __P ((void));
void iterate_weights __P ((void (*dofun) (FILE *, double *, double, double),
			   FILE * fp, double par1, double par2));
void clear_network __P ((int modi));

/********* defined in stats.c ***********/
void init_stats __P ((void));
void pars_cumulate_stats __P ((int senti, int fragi));
void seg_cumulate_stats __P ((int fragi, int seqi));
void cont_cumulate_stats __P ((int fragi, int seqi));
void stack_cumulate_stats __P ((int fragi));
void write_error __P ((FILE * fp));
void print_summary __P ((int epoch));
void print_through_sentence __P ((void));

/********* defined in graph.c ***********/
void display_init __P ((void));
void wait_and_handle_events __P ((void));
void wait_for_run __P ((void));
void display_current_parser __P ((int modi, int weights_included));
void display_current_segmenter __P ((int modi, int weights_included));
void display_current_stack __P ((int modi, int weights_included));
void display_all_weights __P ((void));
