#include "mpi.h"

void my_allgather( void *send_buf, int send_size, MPI_Datatype send_datatype,
	        void *recv_buf, int recv_size, MPI_Datatype recv_datatype,
                MPI_Comm comm )
{
  int
    me, nprocs, left, right, index, index_next, i, typesize;

  char 
    **recv_location;

  MPI_Status
    status;

  MPI_Request
    request;
  
  if ( send_datatype != recv_datatype ){
    printf(" send_datatype != recv_datatype not yet implemented\n" );
    exit ( 0 );
  }

  MPI_Comm_rank( comm, &me );
  MPI_Comm_size( comm, &nprocs );

  MPI_Type_size( send_datatype, &typesize );

  recv_location = ( char ** ) malloc( ( nprocs + 1 ) * sizeof( char * ) );

  recv_location[ 0 ] = ( char * ) recv_buf;

  for ( i = 0; i<nprocs; i++ )
    recv_location[ i+1 ] = recv_location[ i ] + recv_size * typesize;

  memcpy( recv_location[ me ], send_buf, recv_size * typesize );

  left = ( me-1+nprocs )%nprocs;
  right = ( me+1 )%nprocs;
  
  index = me;
  for ( i=1; i<nprocs; i++ ){
    index_next = ( index+1 ) %nprocs;
    MPI_Irecv( recv_location[ index_next ],
	     recv_location[ index_next+1 ] - recv_location[ index_next ],
	     MPI_CHAR, right, MPI_ANY_TAG, comm, &request );

    MPI_Send( recv_location[ index ],
	     recv_location[ index+1 ] - recv_location[ index ],
	     MPI_CHAR, left, 0, comm );

    index = index_next;

    MPI_Wait( &request, &status );
  }
    
  free ( recv_location );

  return;
}


void my_allgather_x( char **recv_location, int me, int nprocs, MPI_Comm comm )
{
  int left, right, index, index_next, i;

  MPI_Request
    request;

  MPI_Status
    status;
  
  left = ( me-1+nprocs )%nprocs;
  right = ( me+1 )%nprocs;
  
  index = me;
  for ( i=1; i<nprocs; i++ ){
    index_next = ( index+1 ) %nprocs;
    MPI_Irecv( recv_location[ index_next ],
	     recv_location[ index_next+1 ] - recv_location[ index_next ],
	     MPI_CHAR, right, MPI_ANY_TAG, comm, &request );

    MPI_Send( recv_location[ index ],
	     recv_location[ index+1 ] - recv_location[ index ],
	     MPI_CHAR, left, 0, comm );

    index = index_next;

    MPI_Wait( &request, &status );
  }

  return;
}
