#include "mpi.h"

void my_gather_x( char **, int, int, int, int, MPI_Comm );


void my_gather( void *send_buf, int send_size, MPI_Datatype send_datatype,
	        void *recv_buf, int recv_size, MPI_Datatype recv_datatype,
                int root, MPI_Comm comm )
{
  int
    me, nprocs, i, typesize;

  char 
    **recv_location;

  void *recv_buffer;

  if ( send_datatype != recv_datatype ){
    printf(" send_datatype != recv_datatype not yet implemented\n" );
    exit ( 0 );
  }

  MPI_Comm_rank( comm, &me );
  MPI_Comm_size( comm, &nprocs );

  MPI_Type_size( send_datatype, &typesize );

  if ( me == root )
    recv_buffer = recv_buf;
  else{
    if ( recv_size != 0 )
      recv_buffer = ( void * ) malloc( typesize * recv_size * nprocs );
    else
      recv_buffer = ( int * ) 1;
  }

  recv_location = ( char ** ) malloc( ( nprocs + 1 ) * sizeof( char * ) );

  recv_location[ 0 ] = ( char * ) recv_buffer;

  for ( i = 0; i<nprocs; i++ )
    recv_location[ i+1 ] = recv_location[ i ] + recv_size * typesize;

  memcpy( recv_location[ me ], send_buf, recv_size * typesize );

  my_gather_x( recv_location, me, root, 0, nprocs-1, comm );

  free ( recv_location );

  if ( recv_size != 0 && me != root ) 
    free( recv_buffer );

  return;
}

void my_gather_x( char **recv_location, int me, int root, 
		  int first, int last, MPI_Comm comm )
{
  int 
    middle, new_root;
  MPI_Status
    status;

  if ( first == last ) return;

  middle = ( first + last ) / 2;

  if ( root <= middle ) {
    new_root = last;
    if ( me <= middle )
      my_gather_x( recv_location, me, root, first, middle, comm );
    else
      my_gather_x( recv_location, me, new_root, middle+1, last, comm );

    if ( me == root )
      MPI_Recv( recv_location[ middle+1 ], 
	        recv_location[ last+1 ] - recv_location[ middle+1 ],
	        MPI_CHAR, new_root, MPI_ANY_TAG, comm, &status );
    if ( me == new_root )
      MPI_Send( recv_location[ middle+1 ], 
	         recv_location[ last+1 ] - recv_location[ middle+1 ],
	         MPI_CHAR, root, 0, comm );
  }
  else {
    new_root = first;
    if ( me <= middle )
      my_gather_x( recv_location, me, new_root, first, middle, comm );
    else
      my_gather_x( recv_location, me, root, middle+1, last, comm );

    if ( me == root )
      MPI_Recv( recv_location[ first ], 
	        recv_location[ middle+1 ] - recv_location[ first ],
	        MPI_CHAR, new_root, MPI_ANY_TAG, comm, &status );
    if ( me == new_root )
      MPI_Send( recv_location[ first ],
	        recv_location[ middle+1 ] - recv_location[ first ],
	        MPI_CHAR, root, 0, comm );
  }

  return;
}



