#include "mpi.h"

void my_scatter_x( char **, int, int, int, int, MPI_Comm );


void my_scatter( void *send_buf, int send_size, MPI_Datatype send_datatype,
	        void *recv_buf, int recv_size, MPI_Datatype recv_datatype,
                int root, MPI_Comm comm )
{
  int
    me, nprocs, i, typesize;

  char 
    **send_location;

  void *send_buffer;

  if ( send_datatype != recv_datatype ){
    printf(" send_datatype != recv_datatype not yet implemented\n" );
    exit ( 0 );
  }

  MPI_Comm_rank( comm, &me );
  MPI_Comm_size( comm, &nprocs );

  MPI_Type_size( send_datatype, &typesize );

  if ( me == root )
    send_buffer = send_buf;
  else
    send_buffer = ( void * ) malloc( typesize * recv_size * nprocs );

  send_location = ( char ** ) malloc( ( nprocs + 1 ) * sizeof( char * ) );

  send_location[ 0 ] = ( char * ) send_buffer;

  for ( i = 0; i<nprocs; i++ )
    send_location[ i+1 ] = send_location[ i ] + recv_size * typesize;

  my_scatter_x( send_location, me, root, 0, nprocs-1, comm );

  memcpy( recv_buf, send_location[ me ], recv_size * typesize );

  free ( send_location );
  if ( me != root ) free( send_buffer );

  return;
}

void my_scatter_x( char **send_location, int me, int root, 
		  int first, int last, MPI_Comm comm )
{
  int 
    middle, new_root;
  MPI_Status
    status;

  if ( first == last ) return;

  middle = ( first + last ) / 2;

  if ( root <= middle ) {
    new_root = last;

    if ( me == new_root )
      MPI_Recv( send_location[ middle+1 ], 
	        send_location[ last+1 ] - send_location[ middle+1 ],
	        MPI_CHAR, root, MPI_ANY_TAG, comm, &status );

    if ( me == root )
      MPI_Send( send_location[ middle+1 ], 
	         send_location[ last+1 ] - send_location[ middle+1 ],
	         MPI_CHAR, new_root, 0, comm );

    if ( me <= middle )
      my_scatter_x( send_location, me, root, first, middle, comm );
    else
      my_scatter_x( send_location, me, new_root, middle+1, last, comm );
  }
  else {
    new_root = first;

    if ( me == new_root )
      MPI_Recv( send_location[ first ], 
	        send_location[ middle+1 ] - send_location[ first ],
	        MPI_CHAR, root, MPI_ANY_TAG, comm, &status );
    if ( me == root )
      MPI_Send( send_location[ first ],
	        send_location[ middle+1 ] - send_location[ first ],
	        MPI_CHAR, new_root, 0, comm );

    if ( me <= middle )
      my_scatter_x( send_location, me, new_root, first, middle, comm );
    else
      my_scatter_x( send_location, me, root, middle+1, last, comm );
}

  return;
}



