#include "mpi.h"

double sqrt( double );

void new_mpi_bcast( void *send_buf, int send_size, MPI_Datatype send_datatype,
		    int root, MPI_Comm comm )
{
  int
    me, nprocs, i, typesize, recv_size, nprocs1;
  int
    *recv_buf;

  MPI_Comm_rank( comm, &me );
  MPI_Comm_size( comm, &nprocs );

  MPI_Type_size( send_datatype, &typesize );

  recv_buf = (int *) malloc ( typesize * send_size );

  MPI_Scatter( send_buf, send_size / nprocs, send_datatype,
	       recv_buf, send_size / nprocs, send_datatype,
	       root, comm );

  MPI_Allgather( recv_buf, send_size / nprocs, send_datatype,
	         send_buf, send_size / nprocs, send_datatype,
                 comm );

  free ( recv_buf );

  return;
}
