#include "mpi.h"

#define NULL 0
#define BF(x) ( ( x ) == NULL ? ( int *) 1 : ( x ) )

void new_mpi_reduce( void * send_buf, void * recv_buf, int count, MPI_Datatype datatype,
		     MPI_Op op, int root, MPI_Comm comm)
{
  int
    me, i, nprocs, typesize;
  int
    *recv_count;

  int
    *temp_buf;

  MPI_Comm_rank( comm, &me );
  MPI_Comm_size( comm, &nprocs );

  MPI_Type_size( datatype, &typesize );

  if ( count/nprocs != 0 )
    temp_buf = (int *) malloc ( count/nprocs * typesize );
  else
    temp_buf = (int *) 1;

  recv_count = (int *) malloc( ( nprocs + 1 ) * sizeof( int ));

  for ( i = 0; i < nprocs; i++ )
    {
      recv_count[i] = count/nprocs;
    }

  MPI_Reduce_scatter( BF( send_buf ), BF( temp_buf ), 
		      recv_count, datatype, op, comm);

  MPI_Gather( BF( temp_buf ), count/nprocs, datatype, 
	      BF( recv_buf ), count/nprocs, datatype, root, comm);

  free( recv_count );
  if ( count/nprocs != 0 )
    free( temp_buf );

  return;
}
