#include "mpi.h"

#define TRUE 1
#define MAX_MESSAGE_LENGTH 1000000

void time_bcast( MPI_Datatype datatype,    /* datatype to time              */
                 int ntrials,              /* number of trials              */
                 int *lengths,             /* vector lengths to try         */
                 int root,                 /* root of broadcast             */
		 double *timings,          /* timings                       */
                 MPI_Comm comm,            /* communicator                  */
		 int version )
{
  int  
    me, trial, i, j, k, n, np, typesize;
  int 
    *data;
  double 
    time;
  MPI_Status
    status;

  /* me = this node's index in the communicator */
  MPI_Comm_rank( comm, &me );
  MPI_Comm_size( comm, &np );

  MPI_Type_size( datatype, &typesize );

  data = ( int * ) malloc( lengths[ntrials-1] * typesize );

  for ( trial=0; trial<ntrials; trial++ ){
    n = lengths[ trial ];
    /* Execute each trial twice, timing the second one */
    for ( j=0; j<2; j++ ){
      /* Initialize data */
      if ( root == me ) 
	for ( i=0; i<n; i++ ) data[i] = i;
      else 
	for ( i=0; i<n; i++ ) data[i] = -1;

      /* start timing */
      MPI_Barrier( comm );
      time = MPI_Wtime();

      switch ( version ){
      case 0:
	MPI_Bcast( data, n, datatype, root, comm );
	break;
      case 1:
	my_bcast( data, n, datatype, root, comm );
	break;
      case 2:
	my_bcast2( data, n, datatype, root, comm );
        break;
      case 3:
	new_mpi_bcast( data, n, datatype, root, comm );
      }

      /* stop timing */
      time = MPI_Wtime() - time;

      /* check if result is correct */
#ifndef NOCHECK      
      for ( i=0; i<n; i++ )
	if ( ( data[i] != i ) && ( n % np == 0 ) ){
	  printf( "error in broadcast\n" );
	  exit( 0 );
	}
#endif
    }

    /* determine max time spent in bcast over all nodes */
    MPI_Allreduce( &time, &timings[ trial ], 1, MPI_DOUBLE, MPI_MAX, 
		   comm );
  }

  free( data );

  return;
}
