#!/bin/tcsh

# This script starts a team of AustinVilla03 coachable players. 
# When player numbers are supplied before the (optional) host-name 
# and team-name arguments only these players are started, otherwise 
# all players are started.
# Usage:   start.sh <player-numbers> <host-name> <team-name>
#
# Example: start.sh                  all players default host and name
# Example: start.sh machine          all players on host 'machine'
# Example: start.sh localhost UTAV   all players on localhost and name 'UTAV'
# Example: start.sh 1 2 3 4          players 1-4 on default host and name
# Example: start.sh 1 2 remote       players 1,2 on host 'remote'
# Example: start.sh 9 10 remote UTAV players 9,10 on host 'remote' and name 'UTAV'

set wait  = 0
set host  = "localhost"
set team  = "UTAustinVilla" 
set prog  = "./villa_player"
set coach = ""
set conf  = "utav.conf"

echo "*************************************************************"
echo "* UT Austin Villa 2003 - University of Texas at Austin, USA *"
echo "* Team Members:                                             *"
echo "*   Gregory Kuhlmann                                        *" 
echo "*   Peter Stone                                             *" 
echo "*   Justin Lallinger                                        *" 
echo "* Copyright 2003.  All rights reserved.                     *"
echo "*************************************************************"

#first check if the last two supplied arguments are no numbers and represent
#<host-name> or <host-name> <team-name>
#then if first argument is a number, start only the players with the numbers
#as supplied on the prompt, otherwise start all players.
if( $#argv > 0 && $argv[$#argv] !~ [0123456789]* ) then
  @ second_last = $#argv - 1
  if( $#argv > 1 && $argv[$second_last] !~ [0123456789]*) then
      set host = $argv[$second_last]
      set team = $argv[$#argv]
  else
      set host = $argv[$#argv]
  endif
endif

if( $1 =~ [0123456789]* ) then
  foreach arg ($argv)
    if( $arg =~ [123456789]*) then
      ${prog} -number ${arg} -host ${host} -team ${team} -a ${conf} &

      sleep $wait
#    else if($arg =~ [0]* ) then
#      ${coach} -host ${host} -team ${team}
    endif
  end
else
  set i = 2


  villa_player -number 1 -host ${host} -team ${team} -a ${conf} &

  while ( ${i} < 12 )
       ${prog} -number ${i} -host ${host} -team ${team} -a ${conf} &

    sleep $wait
    @ i++
  end
#    ${coach} -host ${host} -team ${team}
endif

