/*
 * Decompiled with CFR 0.152.
 */
package rcssjava;

import java.io.Serializable;
import rcssjava.BallObject;
import rcssjava.PlayerObject;
import rcssjava.ServerParams;
import rcssjava.Utils;
import rcssjava.VecPosition;

public class WorldState
implements Serializable {
    private ServerParams SP;
    private int time;
    private int playMode;
    private String[] teamNames;
    private int[] scores;
    private PlayerObject[] players;
    private BallObject ball;
    private int ourSide;
    private int oppSide;

    public WorldState(ServerParams serverParams) {
        this(serverParams, -1);
    }

    public WorldState(ServerParams serverParams, int n) {
        this.SP = serverParams;
        this.setPlayMode(0);
        this.setSide(n);
        this.scores = new int[2];
        this.teamNames = new String[2];
        this.teamNames[0] = new String();
        this.teamNames[1] = new String();
        this.players = new PlayerObject[22];
        for (int i = 0; i < 22; ++i) {
            this.players[i] = new PlayerObject();
            int n2 = i < 11 ? -3 : 3;
            this.players[i].setPosition(new VecPosition(n2 * (i % 11 + 1), -37.0));
        }
        this.ball = new BallObject();
    }

    public WorldState copy(WorldState worldState) {
        int n;
        this.SP = worldState.SP;
        this.updateTime(worldState.getTime());
        this.setPlayMode(worldState.getPlayMode());
        this.setSide(worldState.getOurSide());
        for (n = 0; n < 2; ++n) {
            this.setScore(n, worldState.getScore(n));
            this.setTeamName(n, worldState.getTeamName(n));
        }
        for (n = 0; n < 22; ++n) {
            this.players[n].copy(worldState.players[n]);
        }
        this.ball.copy(worldState.ball);
        return this;
    }

    public void updateTime(int n) {
        this.time = n;
    }

    public int getTime() {
        return this.time;
    }

    public void setPlayMode(int n) {
        this.playMode = n;
    }

    public int getPlayMode() {
        return this.playMode;
    }

    public String getPlayModeString() {
        return Utils.getPlayModeString(this.getPlayMode());
    }

    public void setSide(int n) {
        if (n == 0) {
            this.ourSide = 0;
            this.oppSide = 1;
        } else if (n == 1) {
            this.ourSide = 1;
            this.oppSide = 0;
        } else {
            this.ourSide = -1;
            this.oppSide = -1;
        }
    }

    public int getOurSide() {
        return this.ourSide;
    }

    public int getOppSide() {
        return this.oppSide;
    }

    public int getSideFromTeamName(String string) {
        if (string.equals(this.teamNames[0])) {
            return 0;
        }
        if (string.equals(this.teamNames[1])) {
            return 1;
        }
        return -1;
    }

    public void setSideFromTeamName(String string) {
        this.setSide(this.getSideFromTeamName(string));
    }

    public void setTeamName(int n, String string) {
        this.teamNames[n] = string;
    }

    public void setLeftTeamName(String string) {
        this.setTeamName(0, string);
    }

    public void setRightTeamName(String string) {
        this.setTeamName(1, string);
    }

    public void setOurTeamName(String string) {
        this.setTeamName(this.getOurSide(), string);
    }

    public void setOppTeamName(String string) {
        this.setTeamName(this.getOppSide(), string);
    }

    public String getTeamName(int n) {
        return this.teamNames[n];
    }

    public String getLeftTeamName() {
        return this.getTeamName(0);
    }

    public String getRightTeamName() {
        return this.getTeamName(1);
    }

    public String getOurTeamName() {
        return this.getTeamName(this.getOurSide());
    }

    public String getOppTeamName() {
        return this.getTeamName(this.getOppSide());
    }

    public String getTeamNameFromPlayer(int n) {
        return this.getTeamName(Utils.getSideFromID(n));
    }

    public void setScore(int n, int n2) {
        this.scores[n] = n2;
    }

    public void setLeftScore(int n) {
        this.setScore(0, n);
    }

    public void setRightScore(int n) {
        this.setScore(1, n);
    }

    public void setOurScore(int n) {
        this.setScore(this.getOurSide(), n);
    }

    public void setOppScore(int n) {
        this.setScore(this.getOppSide(), n);
    }

    public int getScore(int n) {
        return this.scores[n];
    }

    public int getLeftScore() {
        return this.getScore(0);
    }

    public int getRightScore() {
        return this.getScore(1);
    }

    public int getOurScore() {
        return this.getScore(this.getOurSide());
    }

    public int getOppScore() {
        return this.getScore(this.getOppSide());
    }

    public int getGoalDifference() {
        return this.getOurScore() - this.getOppScore();
    }

    public boolean isTeammate(int n) {
        return Utils.isPlayer(n) && Utils.getSideFromID(n) == this.getOurSide();
    }

    public boolean isOpponent(int n) {
        return Utils.isPlayer(n) && Utils.getSideFromID(n) == this.getOppSide();
    }

    public int getTeammateID(int n) {
        return Utils.getPlayerID(this.getOurSide(), n);
    }

    public int getOpponentID(int n) {
        return Utils.getPlayerID(this.getOppSide(), n);
    }

    public boolean isOnSidelines(int n) {
        return this.getPlayerPosition(n).getY() == -37.0;
    }

    public void updateBall(VecPosition vecPosition, VecPosition vecPosition2) {
        this.ball.setTimeLastSeen(this.getTime());
        this.ball.setPosition(vecPosition);
        this.ball.setVelocity(vecPosition2);
    }

    public void updatePlayer(int n, VecPosition vecPosition, VecPosition vecPosition2, double d, double d2) {
        PlayerObject playerObject = this.players[n];
        playerObject.setTimeLastSeen(this.getTime());
        playerObject.setPosition(vecPosition);
        playerObject.setVelocity(vecPosition2);
        playerObject.setBodyAngle(d);
        playerObject.setNeckAngle(d2);
    }

    public VecPosition getBallPosition() {
        return this.ball.getPosition();
    }

    public int getTimeSinceSeenBall() {
        return this.getTime() - this.ball.getTimeLastSeen();
    }

    public VecPosition getPlayerPosition(int n) {
        return this.players[n].getPosition();
    }

    public int getTimeSinceSeenPlayer(int n) {
        return this.getTime() - this.players[n].getTimeLastSeen();
    }

    public VecPosition getPosition(int n) {
        if (Utils.isBall(n)) {
            return this.getBallPosition();
        }
        if (Utils.isPlayer(n)) {
            return this.getPlayerPosition(n);
        }
        if (Utils.isLeftGoal(n)) {
            return new VecPosition(-52.5, 0.0);
        }
        if (Utils.isRightGoal(n)) {
            return new VecPosition(52.5, 0.0);
        }
        return null;
    }

    public VecPosition getBallVelocity() {
        return this.ball.getVelocity();
    }

    public VecPosition getPlayerVelocity(int n) {
        return this.players[n].getVelocity();
    }

    public VecPosition getVelocity(int n) {
        if (Utils.isBall(n)) {
            return this.getBallVelocity();
        }
        if (Utils.isPlayer(n)) {
            return this.getPlayerVelocity(n);
        }
        if (Utils.isGoal(n)) {
            return new VecPosition();
        }
        return null;
    }

    public double getPlayerBodyAngle(int n) {
        return this.players[n].getBodyAngle();
    }

    public double getPlayerNeckAngle(int n) {
        return this.players[n].getNeckAngle();
    }

    public int getHeteroPlayerType(int n) {
        return this.players[n].getHeteroPlayerType();
    }

    public boolean isBallKickableBy(int n) {
        return this.getBallPosition().getDistanceTo(this.getPlayerPosition(n)) < this.SP.kickable_margin + this.SP.player_size + this.SP.ball_size;
    }
}

