/*
 * Decompiled with CFR 0.152.
 */
package rcssjava.coach;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import rcssjava.VecPosition;
import rcssjava.coach.InsufficientDataException;
import rcssjava.coach.LinearRegression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BallAttractionModel
implements Serializable {
    LinearRegression m_lrX;
    LinearRegression m_lrY;
    public ArrayList<VecPosition> playerPositionsList = new ArrayList();

    public BallAttractionModel() {
        this.m_lrX = new LinearRegression();
        this.m_lrY = new LinearRegression();
    }

    public void addData(VecPosition vecPosition, VecPosition vecPosition2) {
        VecPosition vecPosition3 = new VecPosition(vecPosition.getX(), vecPosition2.getX());
        VecPosition vecPosition4 = new VecPosition(vecPosition.getY(), vecPosition2.getY());
        this.m_lrX.addPoint(vecPosition3);
        this.m_lrY.addPoint(vecPosition4);
        this.playerPositionsList.add(vecPosition2);
    }

    public VecPosition getHomePosition() {
        try {
            return new VecPosition(this.m_lrX.getBestFitLine().getYIntercept(), this.m_lrY.getBestFitLine().getYIntercept());
        }
        catch (InsufficientDataException insufficientDataException) {
            System.err.println(insufficientDataException);
            return new VecPosition(-1000.0, -1000.0);
        }
    }

    public VecPosition getBallAttraction() {
        try {
            return new VecPosition(this.m_lrX.getBestFitLine().getSlope(), this.m_lrY.getBestFitLine().getSlope());
        }
        catch (InsufficientDataException insufficientDataException) {
            System.err.println(insufficientDataException);
            return new VecPosition(-1000.0, -1000.0);
        }
    }

    public double getError() throws InsufficientDataException {
        return this.m_lrX.getRMSError() + this.m_lrY.getRMSError();
    }

    public double getError(List<VecPosition> list, List<VecPosition> list2) throws InsufficientDataException {
        int n = list.size();
        ArrayList<VecPosition> arrayList = new ArrayList<VecPosition>(n);
        ArrayList<VecPosition> arrayList2 = new ArrayList<VecPosition>(n);
        for (int i = 0; i < n; ++i) {
            VecPosition vecPosition = list.get(i);
            VecPosition vecPosition2 = list2.get(i);
            arrayList.add(new VecPosition(vecPosition.getX(), vecPosition2.getX()));
            arrayList2.add(new VecPosition(vecPosition.getY(), vecPosition2.getY()));
        }
        return this.m_lrX.getRMSError(arrayList) + this.m_lrY.getRMSError(arrayList2);
    }
}

