/*
 * Decompiled with CFR 0.152.
 */
package rcssjava.coach;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import rcssjava.ServerParams;
import rcssjava.VecPosition;
import rcssjava.WorldState;
import rcssjava.coach.BallAttractionModel;
import rcssjava.coach.ConditionsStorage;
import rcssjava.coach.FeatureCollector;
import rcssjava.coach.FeaturesStorage;
import rcssjava.coach.FormFix;
import rcssjava.coach.InsufficientDataException;
import rcssjava.coach.Pattern;
import rcssjava.coach.WeightStorage;
import rcssjava.comm.CoachCommandHandler;
import rcssjava.comm.Connection;
import rcssjava.comm.RCSSParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Coach {
    int cyclesToAnalyze = 6000;
    ServerParams SP;
    WorldState WS;
    CoachCommandHandler CMD;
    Connection C;
    RCSSParser parser;
    String teamName;
    boolean launchMonitor;
    private static String patternListFile = null;
    private static Pattern[] patterns;
    private static String clangFile;
    private ConditionsStorage onlineConditions = new ConditionsStorage();
    private static int sideBeingModeled;
    private FeatureCollector onlineCollector;
    private ArrayList<FeaturesStorage> onlineFeatStorArray;
    int[] pattDecCycle = new int[6];
    ArrayList<Pattern> pattDecOrder = new ArrayList();
    int patternsDec;
    boolean allPatsDec = false;
    static int nPats;
    String currPattName;
    FormFix f;

    public Coach(Connection connection, String string, boolean bl) {
        this.SP = new ServerParams();
        this.WS = new WorldState(this.SP);
        this.C = connection;
        this.CMD = new CoachCommandHandler(this.C, this.WS);
        this.parser = new RCSSParser(this.WS, this.SP);
        this.teamName = string;
        this.launchMonitor = bl;
    }

    public void mainLoop() {
        this.CMD.init(this.teamName, 9.0);
        String string = this.C.receive();
        this.parser.analyzeMessage(string);
        if (this.WS.getOurSide() == -1) {
            System.err.println("Unable to init: " + string);
            System.exit(1);
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(clangFile));
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.length() <= 0 || string2.charAt(0) != '(') continue;
                this.C.send(string2);
                System.out.println("Sending: " + string2);
            }
            Thread.currentThread();
            Thread.sleep(5000L);
        }
        catch (Exception exception) {
            System.err.println("Unable to send CLang: " + exception);
            System.exit(1);
        }
        this.retrievePatterns();
        this.onlineFeatStorArray = this.makeFeatStorArray(this.onlineConditions);
        sideBeingModeled = this.WS.getOppSide();
        this.f = new FormFix(sideBeingModeled);
        this.onlineCollector = new FeatureCollector(sideBeingModeled, this.SP);
        this.CMD.eye(true);
        int n = 0;
        do {
            string = this.C.receive();
            this.parser.analyzeMessage(string);
            if (this.WS.getTime() <= n) continue;
            n = this.WS.getTime();
            this.processCycle();
            if (this.SP.synch_mode != 1) continue;
            this.CMD.done();
        } while (this.WS.getPlayMode() != 2 && this.WS.getTime() < this.cyclesToAnalyze);
        this.C.disconnect();
        System.out.println("Shutting down coach.");
        System.out.println("Pattern Scores: ");
        int n2 = 0;
        while (true) {
            if (n2 >= patterns.length) break;
            System.out.println("Pattern " + Coach.patterns[n2].patternName + ": " + Coach.patterns[n2].patternScore);
            ++n2;
        }
        System.out.println("\n\n");
        System.out.println("Patterns declared at end of game: ");
        for (n2 = 0; n2 < this.patternsDec; ++n2) {
            System.out.println(this.pattDecOrder.get((int)n2).patternName + " at cycle " + this.pattDecCycle[n2]);
        }
        System.out.println("\n\n\n\n\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retrievePatterns() {
        String[] stringArray;
        Closeable closeable;
        Object object;
        System.out.println("\n\nPlease wait while patterns deserialize\n\n");
        String string = "";
        boolean bl = new File(patternListFile).exists();
        if (bl) {
            object = new File(patternListFile);
            try {
                closeable = new BufferedReader(new FileReader((File)object));
                stringArray = null;
                while ((stringArray = ((BufferedReader)closeable).readLine()) != null) {
                    string = string + (String)stringArray + ".ser\n";
                }
                ((BufferedReader)closeable).close();
            }
            catch (IOException iOException) {
                System.err.println(iOException);
                System.exit(1);
            }
        } else {
            System.out.println(patternListFile + " does not exist in this directory.");
            System.exit(1);
        }
        object = null;
        closeable = null;
        System.out.println("To be deserialized " + patternListFile + ". patternFileNames:\n" + string);
        stringArray = string.split("\n");
        patterns = new Pattern[stringArray.length];
        int n = stringArray.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            try {
                object = new FileInputStream(stringArray[i]);
                closeable = new ObjectInputStream((InputStream)object);
                Coach.patterns[i - n2] = (Pattern)((ObjectInputStream)closeable).readObject();
                System.out.println("Deserialized " + Coach.patterns[i - n2].patternName + ".");
                continue;
            }
            catch (IOException iOException) {
                System.out.println("-----------------------------------------------");
                System.out.println("Pattern " + stringArray[i] + " not found. It will not be considered as a possible choice.\n");
                System.out.println("-----------------------------------------------");
                iOException.printStackTrace();
                stringArray[i] = "Missing Pattern";
                ++n2;
                Pattern[] patternArray = new Pattern[patterns.length - 1];
                for (int j = 0; j < patternArray.length; ++j) {
                    patternArray[j] = patterns[j];
                }
                patterns = patternArray;
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
                stringArray[i] = null;
                continue;
            }
            finally {
                try {
                    ((ObjectInputStream)closeable).close();
                    ((FileInputStream)object).close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                catch (NullPointerException nullPointerException) {
                    nullPointerException.printStackTrace();
                    System.out.println("HERE IS THE ERROR!");
                }
            }
        }
        if (patterns[patterns.length - 1] == null) {
            System.out.println("\n\nError! Number of patterns does not match size of pattern array\n\n");
            System.exit(1);
        }
        System.out.println("\n\npatternNames: ");
        int n3 = 0;
        while (true) {
            if (n3 >= patterns.length) break;
            System.out.println(Coach.patterns[n3].patternName);
            ++n3;
        }
        System.out.println("\n                   --Ready for Kickoff--\n\n");
    }

    private ArrayList<FeaturesStorage> makeFeatStorArray(ConditionsStorage conditionsStorage) {
        ArrayList<FeaturesStorage> arrayList = new ArrayList<FeaturesStorage>();
        arrayList.add(conditionsStorage.trueFeatures);
        return arrayList;
    }

    private void processCycle() {
        this.onlineCollector.processCycle(this.WS, this.featuresStorageLinkedList());
        int n = this.WS.getTime();
        if (n == 800 || n == 2500) {
            this.getAllPatternScores();
            this.rankAndDeclarePatterns(n);
        }
    }

    private LinkedList<FeaturesStorage> featuresStorageLinkedList() {
        LinkedList<FeaturesStorage> linkedList = new LinkedList<FeaturesStorage>();
        linkedList.add(this.onlineConditions.trueFeatures);
        return linkedList;
    }

    private void getAllPatternScores() {
        int n = 0;
        while (true) {
            if (n >= patterns.length) break;
            this.currPattName = Coach.patterns[n].patternName;
            Coach.patterns[n].patternScore = this.getAPatternScore(patterns[n]);
            ++n;
        }
    }

    private double getAPatternScore(Pattern pattern) {
        if (pattern.baseFeatStorArray.size() != pattern.patternFeatStorArray.size() || pattern.patternFeatStorArray.size() != pattern.weightStorArray.size() || pattern.weightStorArray.size() != this.onlineFeatStorArray.size()) {
            System.out.println("Base, Pattern, Online, and Weight ArrayLists do not all have same # FeatureStorage/WeightStorage objects.");
            System.out.println("Base: " + pattern.baseFeatStorArray.size());
            System.out.println("Pattern: " + pattern.weightStorArray.size());
            System.out.println("Online: " + this.onlineFeatStorArray.size());
            System.out.println("Weight: " + pattern.weightStorArray.size());
            System.exit(1);
        }
        System.out.println("Scoring " + pattern.patternName);
        double d = 0.0;
        for (int i = 0; i < pattern.size(); ++i) {
            FeaturesStorage featuresStorage = pattern.baseFeatStorArray.get(i);
            FeaturesStorage featuresStorage2 = pattern.patternFeatStorArray.get(i);
            WeightStorage weightStorage = pattern.weightStorArray.get(i);
            FeaturesStorage featuresStorage3 = this.onlineFeatStorArray.get(i);
            featuresStorage3.calcPassPerc();
            featuresStorage3.calcKickDPerc();
            d += this.getFeatStorScore(featuresStorage, featuresStorage2, weightStorage, featuresStorage3, pattern.pattTotFWt);
        }
        return d;
    }

    private double getFeatStorScore(FeaturesStorage featuresStorage, FeaturesStorage featuresStorage2, WeightStorage weightStorage, FeaturesStorage featuresStorage3, double d) {
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < featuresStorage.formation.length; ++i) {
            double d4;
            double d5;
            double d6 = this.getRatioXY(featuresStorage.formation[i], featuresStorage3.formation[i], featuresStorage.ballPositions.get(i), featuresStorage3.ballPositions.get(i));
            double d7 = d6 - 1.0;
            double d8 = d7 + (d5 = (d4 = this.getRatioXY(featuresStorage2.formation[i], featuresStorage3.formation[i], featuresStorage2.ballPositions.get(i), featuresStorage3.ballPositions.get(i))) - 1.0) == 0.0 ? 0.0 : d7 / (d7 + d5);
            double d9 = 100.0 / d;
            d3 += d8 * weightStorage.formationError[i] * d9;
        }
        return d2 += d3;
    }

    private double getRatioXY(BallAttractionModel ballAttractionModel, BallAttractionModel ballAttractionModel2, ArrayList<VecPosition> arrayList, ArrayList<VecPosition> arrayList2) {
        double d;
        try {
            double d2 = ballAttractionModel.getError();
            double d3 = ballAttractionModel2.getError();
            double d4 = ballAttractionModel.getError(arrayList2, ballAttractionModel2.playerPositionsList);
            double d5 = ballAttractionModel2.getError(arrayList, ballAttractionModel.playerPositionsList);
            d = (d4 + d5) / (d2 + d3);
        }
        catch (InsufficientDataException insufficientDataException) {
            System.out.println("Insufficient data in " + this.currPattName);
            d = -1000.0;
        }
        return d;
    }

    private void rankAndDeclarePatterns(int n) {
        int n2;
        System.out.println("Cycle: " + n);
        boolean bl = true;
        Arrays.sort(patterns);
        for (n2 = 0; n2 < patterns.length; ++n2) {
            if (Coach.patterns[n2].patternScore > 0.0) continue;
            bl = false;
        }
        if (n == 800 && bl && !this.allPatsDec) {
            for (n2 = 1; this.patternsDec <= nPats && n2 <= 2; ++n2) {
                this.sayPattern(patterns[patterns.length - n2]);
                this.pattDecOrder.add(patterns[patterns.length - n2]);
                ++this.patternsDec;
                this.pattDecCycle[n2 - 1] = n;
            }
        }
        if (n >= 2500 && bl && !this.allPatsDec) {
            n2 = 1;
            while (this.patternsDec <= nPats) {
                if (!patterns[patterns.length - n2].equals(this.pattDecOrder.get(0))) {
                    if (!patterns[patterns.length - n2].equals(this.pattDecOrder.get(1))) {
                        this.sayPattern(patterns[patterns.length - n2]);
                        this.pattDecOrder.add(patterns[patterns.length - n2]);
                        ++this.patternsDec;
                        this.pattDecCycle[n2 - 1] = n;
                    }
                }
                ++n2;
            }
        }
        if (this.patternsDec == nPats) {
            this.allPatsDec = true;
        }
        System.out.println("\nPattern Scores: \n");
        n2 = 0;
        while (true) {
            if (n2 >= patterns.length) break;
            System.out.println(Coach.patterns[n2].patternName + ": " + Coach.patterns[n2].patternScore);
            ++n2;
        }
        System.out.println("Patterns declared thus far: ");
        for (n2 = 0; n2 < this.patternsDec; ++n2) {
            System.out.println(this.pattDecOrder.get((int)n2).patternName + " at cycle " + this.pattDecCycle[n2]);
        }
        if (this.patternsDec == 0) {
            System.out.println("None");
        }
    }

    private void sayPattern(Pattern pattern) {
        this.CMD.say("(freeform \"(pattern-detected " + pattern.patternName + ")\" )");
        System.out.println("Detected Pattern: " + pattern.patternName + "\n\n\n");
    }

    public static void main(String[] stringArray) {
        String string = "localhost";
        int n = 6002;
        boolean bl = false;
        String string2 = "Coachable";
        try {
            for (int i = 0; i < stringArray.length; i += 2) {
                if (stringArray[i].equals("-host")) {
                    string = stringArray[i + 1];
                    continue;
                }
                if (stringArray[i].equals("-port")) {
                    n = Integer.parseInt(stringArray[i + 1]);
                    continue;
                }
                if (stringArray[i].equals("-monitor")) {
                    bl = stringArray[i + 1].equals("1");
                    continue;
                }
                if (stringArray[i].equals("-team")) {
                    string2 = stringArray[i + 1];
                    continue;
                }
                if (stringArray[i].equals("-clang")) {
                    clangFile = stringArray[i + 1];
                    continue;
                }
                if (stringArray[i].equals("-npats")) {
                    nPats = Integer.parseInt(stringArray[i + 1]);
                    continue;
                }
                System.err.println("Unknown option: " + stringArray[i]);
            }
        }
        catch (Exception exception) {
            System.err.println("Unable to parse commandline options: " + exception);
            System.exit(1);
        }
        patternListFile = "patterns.list";
        if (nPats == 0) {
            System.out.println("-npats <int> required in command line");
            System.exit(0);
        }
        Connection connection = new Connection(string, n);
        Coach coach = new Coach(connection, string2, bl);
        coach.mainLoop();
    }

    static {
        sideBeingModeled = -1;
        nPats = 0;
    }
}

