/*
 * Decompiled with CFR 0.152.
 */
package rcssjava.coach;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import rcssjava.ServerParams;
import rcssjava.VecPosition;
import rcssjava.WorldState;
import rcssjava.coach.BallAttractionModel;
import rcssjava.coach.ConditionsStorage;
import rcssjava.coach.FeatureCollector;
import rcssjava.coach.FeaturesStorage;
import rcssjava.coach.FormFix;
import rcssjava.coach.InsufficientDataException;
import rcssjava.coach.Pattern;
import rcssjava.coach.WeightStorage;
import rcssjava.gamelog.GameLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Normalize {
    ServerParams SP;
    WorldState WS;
    static String teamName;
    private static Pattern[] patterns;
    private Vector<WorldState> baseStates;
    private static String patternListFile;
    private ConditionsStorage onlineConditions = new ConditionsStorage();
    private static int sideBeingModeled;
    private FeatureCollector onlineCollector;
    private ArrayList<FeaturesStorage> onlineFeatStorArray;
    FormFix f;

    public Normalize() {
        this.SP = new ServerParams();
        this.WS = new WorldState(this.SP);
    }

    public void mainLoop() {
        int n;
        this.retrievePatterns();
        for (n = 0; n < patterns.length; ++n) {
            Normalize.patterns[n].scoreSum = 0.0;
        }
        for (n = 0; n < patterns.length; ++n) {
            this.baseStates = this.parseGameLog(Normalize.patterns[(n + 1) % Normalize.patterns.length].patternName + ".rcg");
            System.out.println("baseStates.size: " + this.baseStates.size());
            this.analyzeBase();
            System.out.println("Pattern score sums:");
            for (int i = 0; i < patterns.length; ++i) {
                System.out.println(Normalize.patterns[i].patternName + ": " + Normalize.patterns[i].scoreSum);
            }
        }
        System.out.println("Pattern total formation weights:");
        for (n = 0; n < patterns.length; ++n) {
            Normalize.patterns[n].pattTotFWt = Normalize.patterns[n].scoreSum / (double)patterns.length;
            System.out.println(Normalize.patterns[n].patternName + ": " + Normalize.patterns[n].pattTotFWt);
        }
        this.reserializePatterns();
        System.out.println("\n\n\n\n\nNormalization complete\n\n");
    }

    private Vector<WorldState> parseGameLog(String string) {
        Vector<WorldState> vector = new Vector<WorldState>();
        System.out.print("Parsing game log: " + string);
        GameLog gameLog = new GameLog(string);
        int n = -1;
        WorldState worldState = new WorldState(this.SP);
        gameLog.setWorldState(worldState);
        while (worldState.getPlayMode() != 2 && gameLog.readNext()) {
            if (worldState.getTime() <= n) continue;
            vector.add(worldState);
            worldState = new WorldState(this.SP).copy(worldState);
            gameLog.setWorldState(worldState);
            if (worldState.getTime() % 100 == 0) {
                System.out.print(".");
            }
            n = worldState.getTime();
        }
        System.out.println("...done");
        return vector;
    }

    private void analyzeBase() {
        sideBeingModeled = this.baseStates.get(5).getSideFromTeamName("Coachable");
        if (sideBeingModeled == -1) {
            System.err.println("sideBeingModeled cannot equal -1 (SIDE_ILLEGAL)");
            System.exit(1);
        }
        System.out.println("Side 0 TeamName: " + this.baseStates.get(5).getTeamName(0));
        System.out.println("Side 1 TeamName: " + this.baseStates.get(5).getTeamName(1) + "\n\n\n");
        this.onlineFeatStorArray = this.makeFeatStorArray(this.onlineConditions);
        this.f = new FormFix(sideBeingModeled);
        this.onlineCollector = new FeatureCollector(sideBeingModeled, this.SP);
        Iterator<WorldState> iterator = this.baseStates.iterator();
        while (iterator.hasNext()) {
            WorldState worldState;
            this.WS = worldState = iterator.next();
            if (this.WS.getTime() % 1000 == 0) {
                System.out.println("Cycle: " + this.WS.getTime());
            }
            this.processCycle();
        }
        this.getAllPatternScores();
        this.rankPatterns();
        System.out.println("\n\nNext Base rcg");
        System.out.println("\n\n");
        System.out.println("\n\n\n\n\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retrievePatterns() {
        int n;
        String[] stringArray;
        Closeable closeable;
        Object object;
        System.out.println("\n\nPlease wait while patterns deserialize\n\n");
        String string = "";
        boolean bl = new File(patternListFile).exists();
        if (bl) {
            object = new File(patternListFile);
            try {
                closeable = new BufferedReader(new FileReader((File)object));
                stringArray = null;
                while ((stringArray = ((BufferedReader)closeable).readLine()) != null) {
                    string = string + (String)stringArray + ".ser\n";
                }
                ((BufferedReader)closeable).close();
            }
            catch (IOException iOException) {
                System.err.println(iOException);
                System.exit(1);
            }
        } else {
            System.out.println(patternListFile + " does not exist in this directory.");
            System.exit(1);
        }
        object = null;
        closeable = null;
        System.out.println("To be deserialized " + patternListFile + ". patternFileNames:\n" + string);
        stringArray = string.split("\n");
        patterns = new Pattern[stringArray.length];
        for (n = 0; n < stringArray.length; ++n) {
            try {
                object = new FileInputStream(stringArray[n]);
                closeable = new ObjectInputStream((InputStream)object);
                Normalize.patterns[n] = (Pattern)((ObjectInputStream)closeable).readObject();
                Normalize.patterns[n].patternName = stringArray[n].substring(0, stringArray[n].length() - 4);
                System.out.println("Deserialized " + Normalize.patterns[n].patternName + ".");
                continue;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
                continue;
            }
            finally {
                try {
                    ((ObjectInputStream)closeable).close();
                    ((FileInputStream)object).close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        if (patterns[patterns.length - 1] == null) {
            System.out.println("\n\nError! Number of patterns does not match size of pattern array\n\n");
            System.exit(1);
        }
        System.out.println("\n\npatternNames: ");
        n = 0;
        while (true) {
            if (n >= patterns.length) break;
            System.out.println(Normalize.patterns[n].patternName);
            ++n;
        }
    }

    private ArrayList<FeaturesStorage> makeFeatStorArray(ConditionsStorage conditionsStorage) {
        ArrayList<FeaturesStorage> arrayList = new ArrayList<FeaturesStorage>();
        arrayList.add(conditionsStorage.trueFeatures);
        return arrayList;
    }

    private void processCycle() {
        this.onlineCollector.processCycle(this.WS, this.featuresStorageLinkedList());
    }

    private LinkedList<FeaturesStorage> featuresStorageLinkedList() {
        LinkedList<FeaturesStorage> linkedList = new LinkedList<FeaturesStorage>();
        linkedList.add(this.onlineConditions.trueFeatures);
        return linkedList;
    }

    private void getAllPatternScores() {
        int n = 0;
        while (true) {
            if (n >= patterns.length) break;
            Normalize.patterns[n].patternScore = this.getAPatternScore(patterns[n]);
            ++n;
        }
    }

    private double getAPatternScore(Pattern pattern) {
        System.out.println("Scoring " + pattern.patternName);
        double d = 0.0;
        FeaturesStorage featuresStorage = pattern.baseFeatStorArray.get(0);
        FeaturesStorage featuresStorage2 = pattern.patternFeatStorArray.get(0);
        WeightStorage weightStorage = pattern.weightStorArray.get(0);
        FeaturesStorage featuresStorage3 = this.onlineFeatStorArray.get(0);
        d += this.getFeatStorScore(featuresStorage, featuresStorage2, weightStorage, featuresStorage3, pattern.pattTotFWt);
        for (int i = 0; i < pattern.size(); ++i) {
            featuresStorage3.calcPassPerc();
            featuresStorage3.calcKickDPerc();
        }
        return d;
    }

    private double getFeatStorScore(FeaturesStorage featuresStorage, FeaturesStorage featuresStorage2, WeightStorage weightStorage, FeaturesStorage featuresStorage3, double d) {
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < featuresStorage.formation.length; ++i) {
            double d4;
            double d5;
            double d6 = this.getRatioXY(featuresStorage.formation[i], featuresStorage3.formation[i], featuresStorage.ballPositions.get(i), featuresStorage3.ballPositions.get(i));
            double d7 = d6 - 1.0;
            double d8 = d7 + (d5 = (d4 = this.getRatioXY(featuresStorage2.formation[i], featuresStorage3.formation[i], featuresStorage2.ballPositions.get(i), featuresStorage3.ballPositions.get(i))) - 1.0) == 0.0 ? 0.0 : d7 / (d7 + d5);
            d3 += d8 * weightStorage.formationError[i];
        }
        return d2 += d3;
    }

    private double getRatioXY(BallAttractionModel ballAttractionModel, BallAttractionModel ballAttractionModel2, ArrayList<VecPosition> arrayList, ArrayList<VecPosition> arrayList2) {
        double d;
        try {
            double d2 = ballAttractionModel.getError();
            double d3 = ballAttractionModel2.getError();
            double d4 = ballAttractionModel.getError(arrayList2, ballAttractionModel2.playerPositionsList);
            double d5 = ballAttractionModel2.getError(arrayList, ballAttractionModel.playerPositionsList);
            d = (d4 + d5) / (d2 + d3);
        }
        catch (InsufficientDataException insufficientDataException) {
            System.out.println("Insufficient data at Normalize class level");
            d = -1000.0;
        }
        return d;
    }

    private void rankPatterns() {
        boolean bl = true;
        Arrays.sort(patterns);
        System.out.println("\nPattern Scores: ");
        int n = 0;
        while (true) {
            if (n >= patterns.length) break;
            System.out.println(Normalize.patterns[n].patternName + ": " + Normalize.patterns[n].patternScore);
            ++n;
        }
        System.out.println("\n\n");
        n = 0;
        while (true) {
            if (n >= patterns.length) break;
            Normalize.patterns[n].scoreSum += Normalize.patterns[n].patternScore;
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reserializePatterns() {
        for (int i = 0; i < patterns.length; ++i) {
            FileOutputStream fileOutputStream = null;
            ObjectOutputStream objectOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(Normalize.patterns[i].patternName + ".ser");
                objectOutputStream = new ObjectOutputStream(fileOutputStream);
                objectOutputStream.writeObject(patterns[i]);
                System.out.println("Pattern serialized into " + Normalize.patterns[i].patternName + ".ser");
                continue;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                continue;
            }
            finally {
                try {
                    objectOutputStream.flush();
                    objectOutputStream.close();
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    public static void main(String[] stringArray) {
        teamName = "Coachable";
        for (int i = 0; i < stringArray.length; i += 2) {
            System.err.println("Unknown option: " + stringArray[i]);
            System.exit(1);
        }
        patternListFile = "patterns.list";
        Normalize normalize = new Normalize();
        normalize.mainLoop();
    }

    private void printFeatures(FeaturesStorage featuresStorage) {
        int n;
        int n2;
        System.out.println("\n\n\n\npassMatrix");
        for (n2 = 0; n2 < 11; ++n2) {
            System.out.println("");
            for (n = 0; n < 22; ++n) {
                System.out.print(featuresStorage.passMatrix[n2][n] + " ");
            }
        }
        System.out.println("\n\n");
        System.out.println("kickDirCount");
        for (n2 = 0; n2 < 11; ++n2) {
            System.out.println("");
            for (n = 0; n < 15; ++n) {
                System.out.print(featuresStorage.kickDirCount[n2][n] + " ");
            }
            System.out.print(" -- " + featuresStorage.totalKickCount[n2]);
        }
        System.out.println("\n\n");
        System.out.println("formation\n");
        for (n2 = 0; n2 < 11; ++n2) {
            System.out.println("HP Player: " + n2 + ":  " + featuresStorage.formation[n2].getHomePosition().toString());
            System.out.println("BA Player " + n2 + ":  " + featuresStorage.formation[n2].getBallAttraction().toString());
        }
        System.out.println("\n\nm_lrX.m_numPoints\n");
        System.out.println(featuresStorage.formation[1].m_lrX.m_numPoints);
        try {
            System.out.println(featuresStorage.formation[1].getError());
        }
        catch (InsufficientDataException insufficientDataException) {
            System.out.println("Insufficient data");
        }
    }

    static {
        patternListFile = "patterns.list";
        sideBeingModeled = -1;
    }
}

