/*
 * Decompiled with CFR 0.152.
 */
package rcssjava.coach;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Random;
import rcssjava.ServerParams;
import rcssjava.VecPosition;
import rcssjava.WorldState;
import rcssjava.coach.BallAttractionModel;
import rcssjava.coach.ConditionsStorage;
import rcssjava.coach.FeatureCollector;
import rcssjava.coach.FeaturesStorage;
import rcssjava.coach.FormFix;
import rcssjava.coach.InsufficientDataException;
import rcssjava.coach.Pattern;
import rcssjava.coach.PatternAnalyzer;
import rcssjava.coach.WeightStorage;
import rcssjava.gamelog.GameLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NormalizeM {
    ServerParams SP = new ServerParams();
    WorldState WS = new WorldState(this.SP);
    static String teamName;
    private Pattern currPatt;
    String rcgFile;
    private static String patternListFile;
    private static String patternDir;
    String[] parsedPattFNames;
    static String patternName;
    private ConditionsStorage onlineConditions = new ConditionsStorage();
    private static int sideBeingModeled;
    private FeatureCollector onlineCollector;
    private ArrayList<FeaturesStorage> onlineFeatStorArray;
    static boolean weightNegligible;
    FormFix f;
    static int normAttempts;
    boolean firstRun = true;

    public NormalizeM(int n) {
        weightNegligible = false;
        normAttempts = n;
    }

    public void mainLoop() {
        double d;
        int n;
        int n2;
        this.retrievePatternNames();
        Random random = new Random();
        for (n2 = 0; n2 < this.parsedPattFNames.length; ++n2) {
            n = random.nextInt(this.parsedPattFNames.length);
            if (n2 == n) continue;
            String string = this.parsedPattFNames[n2];
            this.parsedPattFNames[n2] = this.parsedPattFNames[n];
            this.parsedPattFNames[n] = string;
        }
        n2 = 20;
        n = Math.min(n2, this.parsedPattFNames.length);
        this.retrievePattern();
        this.currPatt.scoreSum = 0.0;
        for (int i = 0; i < n; ++i) {
            this.rcgFile = patternDir + "/" + this.parsedPattFNames[i] + ".rcg";
            this.scoreGameLog();
            System.out.print(this.currPatt.patternName + " score sum: ");
            System.out.println(this.currPatt.scoreSum);
        }
        this.currPatt.pattTotFWt = d = weightNegligible ? 1000000.0 : this.currPatt.scoreSum / (double)n;
        if (weightNegligible) {
            System.out.println("Weight being set to 1000000 to make pattern score negligible.");
        }
        System.out.println(this.currPatt.patternName + " total formation weights (pattTotFWt):" + this.currPatt.pattTotFWt);
        this.reserializePattern();
        System.out.println("\nNormalization complete\n\n\n");
    }

    private void scoreGameLog() {
        System.out.print("Parsing game log and collecting features: " + this.rcgFile);
        GameLog gameLog = new GameLog(this.rcgFile);
        System.out.println("parsed: " + this.rcgFile + " successfully");
        int n = -1;
        WorldState worldState = new WorldState(this.SP);
        gameLog.setWorldState(worldState);
        this.WS = worldState;
        while (worldState.getPlayMode() != 2 && gameLog.readNext()) {
            if (worldState.getTime() <= n || worldState.getTime() <= 2) continue;
            worldState = new WorldState(this.SP).copy(worldState);
            gameLog.setWorldState(worldState);
            this.WS = worldState;
            if (worldState.getTime() == 3) {
                this.initBase();
            }
            this.processCycle();
            if (worldState.getTime() % 300 == 0) {
                System.out.print(".");
            }
            n = worldState.getTime();
        }
        this.getPatternScore();
        System.out.println("...done");
        System.out.println(this.currPatt.patternName + " score: " + this.currPatt.patternScore);
        this.currPatt.scoreSum += this.currPatt.patternScore;
    }

    private void initBase() {
        sideBeingModeled = this.WS.getSideFromTeamName("Coachable");
        if (sideBeingModeled == -1) {
            System.err.println("sideBeingModeled cannot equal -1 (SIDE_ILLEGAL)");
            System.exit(1);
        }
        this.onlineFeatStorArray = this.makeFeatStorArray(this.onlineConditions);
        this.f = new FormFix(sideBeingModeled);
        this.onlineCollector = new FeatureCollector(sideBeingModeled, this.SP);
    }

    private void retrievePatternNames() {
        String string = "";
        boolean bl = new File(patternListFile).exists();
        if (bl) {
            File file = new File(patternListFile);
            try {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                String string2 = null;
                while ((string2 = bufferedReader.readLine()) != null) {
                    string = string + string2 + "\n";
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                System.err.println(iOException);
                System.exit(1);
            }
        } else {
            System.out.println(patternListFile + " does not exist in this directory.");
            System.exit(1);
        }
        this.parsedPattFNames = string.split("\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retrievePattern() {
        FileInputStream fileInputStream = null;
        ObjectInputStream objectInputStream = null;
        System.out.println("Deserializing " + patternName);
        try {
            fileInputStream = new FileInputStream(patternName + ".ser");
            objectInputStream = new ObjectInputStream(fileInputStream);
            this.currPatt = (Pattern)objectInputStream.readObject();
            System.out.println("Deserialized " + this.currPatt.patternName + ".");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        finally {
            try {
                objectInputStream.close();
                fileInputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        System.out.println("\nNormalizing " + this.currPatt.patternName);
    }

    private ArrayList<FeaturesStorage> makeFeatStorArray(ConditionsStorage conditionsStorage) {
        ArrayList<FeaturesStorage> arrayList = new ArrayList<FeaturesStorage>();
        arrayList.add(conditionsStorage.trueFeatures);
        return arrayList;
    }

    private void processCycle() {
        this.onlineCollector.processCycle(this.WS, this.featuresStorageLinkedList());
    }

    private LinkedList<FeaturesStorage> featuresStorageLinkedList() {
        LinkedList<FeaturesStorage> linkedList = new LinkedList<FeaturesStorage>();
        linkedList.add(this.onlineConditions.trueFeatures);
        return linkedList;
    }

    private void getPatternScore() {
        this.currPatt.patternScore = this.getAPatternScore();
    }

    private double getAPatternScore() {
        if (this.currPatt.baseFeatStorArray.size() != this.currPatt.patternFeatStorArray.size() || this.currPatt.patternFeatStorArray.size() != this.currPatt.weightStorArray.size() || this.currPatt.weightStorArray.size() != this.onlineFeatStorArray.size()) {
            System.out.println("Base, Pattern, Online, and Weight ArrayLists do not all have same # FeatureStorage/WeightStorage objects.");
            System.out.println("Base: " + this.currPatt.baseFeatStorArray.size());
            System.out.println("Pattern: " + this.currPatt.weightStorArray.size());
            System.out.println("Online: " + this.onlineFeatStorArray.size());
            System.out.println("Weight: " + this.currPatt.weightStorArray.size());
            System.exit(1);
        }
        System.out.print("scoring " + this.currPatt.patternName);
        double d = 0.0;
        for (int i = 0; i < this.currPatt.size(); ++i) {
            FeaturesStorage featuresStorage = this.currPatt.baseFeatStorArray.get(i);
            FeaturesStorage featuresStorage2 = this.currPatt.patternFeatStorArray.get(i);
            WeightStorage weightStorage = this.currPatt.weightStorArray.get(i);
            FeaturesStorage featuresStorage3 = this.onlineFeatStorArray.get(i);
            featuresStorage3.calcPassPerc();
            featuresStorage3.calcKickDPerc();
            d += this.getFeatStorScore(featuresStorage, featuresStorage2, weightStorage, featuresStorage3, this.currPatt.pattTotFWt);
        }
        return d;
    }

    private double getFeatStorScore(FeaturesStorage featuresStorage, FeaturesStorage featuresStorage2, WeightStorage weightStorage, FeaturesStorage featuresStorage3, double d) {
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < featuresStorage.formation.length; ++i) {
            double d4;
            double d5;
            double d6 = this.getRatioXY(featuresStorage.formation[i], featuresStorage3.formation[i], featuresStorage.ballPositions.get(i), featuresStorage3.ballPositions.get(i));
            double d7 = d6 - 1.0;
            double d8 = d7 + (d5 = (d4 = this.getRatioXY(featuresStorage2.formation[i], featuresStorage3.formation[i], featuresStorage2.ballPositions.get(i), featuresStorage3.ballPositions.get(i))) - 1.0) == 0.0 ? 0.0 : d7 / (d7 + d5);
            d3 += d8 * weightStorage.formationError[i];
        }
        return d2 += d3;
    }

    private double getRatioXY(BallAttractionModel ballAttractionModel, BallAttractionModel ballAttractionModel2, ArrayList<VecPosition> arrayList, ArrayList<VecPosition> arrayList2) {
        double d;
        block2: {
            try {
                double d2 = ballAttractionModel.getError();
                double d3 = ballAttractionModel2.getError();
                double d4 = ballAttractionModel.getError(arrayList2, ballAttractionModel2.playerPositionsList);
                double d5 = ballAttractionModel2.getError(arrayList, ballAttractionModel.playerPositionsList);
                d = (d4 + d5) / (d2 + d3);
            }
            catch (InsufficientDataException insufficientDataException) {
                d = -1000.0;
                System.out.println("Insufficient data at Normalize class level");
                if (normAttempts >= 1 || !this.firstRun) break block2;
                this.firstRun = false;
                System.out.println("CALL FROM NORMALIZE. NormAttempts: " + normAttempts);
                weightNegligible = true;
                String string = this.rcgFile.substring(0, this.rcgFile.length() - 4);
                String string2 = string + "-nopattern.rcg";
                String string3 = string + ".rcg";
                PatternAnalyzer patternAnalyzer = new PatternAnalyzer(string2, string3, string, 0);
                patternAnalyzer.mainLoop();
            }
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reserializePattern() {
        FileOutputStream fileOutputStream = null;
        ObjectOutputStream objectOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(this.currPatt.patternName + ".ser");
            objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(this.currPatt);
            System.out.println("Pattern serialized into " + this.currPatt.patternName + ".ser");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            try {
                objectOutputStream.flush();
                objectOutputStream.close();
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static void main(String[] stringArray) {
        teamName = "Coachable";
        patternName = stringArray[0];
        patternDir = stringArray[1];
        patternListFile = patternDir + "/patterns.list";
        NormalizeM normalizeM = new NormalizeM(0);
        normalizeM.mainLoop();
        if (weightNegligible) {
            normalizeM = new NormalizeM(normAttempts + 1);
            normalizeM.mainLoop();
        }
    }

    private void printFeatures(FeaturesStorage featuresStorage) {
        int n;
        int n2;
        System.out.println("\n\n\n\npassMatrix");
        for (n2 = 0; n2 < 11; ++n2) {
            System.out.println("");
            for (n = 0; n < 22; ++n) {
                System.out.print(featuresStorage.passMatrix[n2][n] + " ");
            }
        }
        System.out.println("\n\n");
        System.out.println("kickDirCount");
        for (n2 = 0; n2 < 11; ++n2) {
            System.out.println("");
            for (n = 0; n < 15; ++n) {
                System.out.print(featuresStorage.kickDirCount[n2][n] + " ");
            }
            System.out.print(" -- " + featuresStorage.totalKickCount[n2]);
        }
        System.out.println("\n\n");
        System.out.println("formation\n");
        for (n2 = 0; n2 < 11; ++n2) {
            System.out.println("HP Player: " + n2 + ":  " + featuresStorage.formation[n2].getHomePosition().toString());
            System.out.println("BA Player " + n2 + ":  " + featuresStorage.formation[n2].getBallAttraction().toString());
        }
        System.out.println("\n\nm_lrX.m_numPoints\n");
        System.out.println(featuresStorage.formation[1].m_lrX.m_numPoints);
        try {
            System.out.println(featuresStorage.formation[1].getError());
        }
        catch (InsufficientDataException insufficientDataException) {
            System.out.println("Insufficient data");
        }
    }

    static {
        sideBeingModeled = -1;
    }
}

