/*
 * Decompiled with CFR 0.152.
 */
package rcssjava.gamelog;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;

abstract class Struct {
    private static int remaining = 0;
    private static byte[] buffer = new byte[4];
    private Field[] fields;

    Struct() {
    }

    public static int s2i(short s) {
        return s;
    }

    public static int l2i(long l) {
        return (int)Math.round(Struct.l2d(l));
    }

    public static double l2d(long l) {
        return (double)l / 65536.0;
    }

    public static byte readByte(InputStream inputStream) {
        try {
            inputStream.read(buffer, 0, 1);
            byte by = buffer[0];
            return by;
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            return -1;
        }
    }

    public static short readShort(InputStream inputStream, boolean bl) {
        try {
            short s;
            if (bl) {
                inputStream.read(buffer, 0, 4);
                s = (short)(buffer[0] << 8 & 0xFF00 | buffer[1] & 0xFF);
                remaining = 2;
            } else if (remaining == 2) {
                s = (short)(buffer[2] << 8 & 0xFF00 | buffer[3] & 0xFF);
                remaining = 0;
            } else {
                inputStream.read(buffer, 0, 2);
                s = (short)(buffer[0] << 8 & 0xFF00 | buffer[1] & 0xFF);
            }
            return s;
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            return -1;
        }
    }

    public static long readLong(InputStream inputStream) {
        try {
            byte[] byArray = new byte[4];
            inputStream.read(byArray, 0, 4);
            long l = byArray[0] << 24 & 0xFF000000 | byArray[1] << 16 & 0xFF0000 | byArray[2] << 8 & 0xFF00 | byArray[3] & 0xFF;
            return l;
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            return -1L;
        }
    }

    public static void readFields(Struct struct, InputStream inputStream) {
        boolean bl = true;
        try {
            Field[] fieldArray = struct.getFields();
            for (int i = 0; i < fieldArray.length; ++i) {
                Class<?> clazz = fieldArray[i].getType();
                if (clazz.equals(Byte.TYPE)) {
                    byte by = Struct.readByte(inputStream);
                    fieldArray[i].setByte(struct, by);
                    continue;
                }
                if (clazz.equals(Short.TYPE)) {
                    short s = Struct.readShort(inputStream, bl);
                    fieldArray[i].setShort(struct, s);
                    bl = !bl;
                    continue;
                }
                if (clazz.equals(Long.TYPE)) {
                    long l = Struct.readLong(inputStream);
                    fieldArray[i].setLong(struct, l);
                    bl = true;
                    continue;
                }
                if (clazz.isArray()) {
                    Class<?> clazz2 = clazz.getComponentType();
                    Object object = fieldArray[i].get(struct);
                    int n = Array.getLength(object);
                    for (int j = 0; j < n; ++j) {
                        if (clazz2.equals(Byte.TYPE)) {
                            byte by = Struct.readByte(inputStream);
                            Array.setByte(object, j, by);
                            bl = false;
                            continue;
                        }
                        if (clazz2.equals(Short.TYPE)) {
                            short s = Struct.readShort(inputStream, bl);
                            Array.setShort(object, j, s);
                            bl = !bl;
                            continue;
                        }
                        if (clazz2.equals(Long.TYPE)) {
                            long l = Struct.readLong(inputStream);
                            Array.setLong(object, j, l);
                            bl = true;
                            continue;
                        }
                        if (clazz2.isPrimitive()) continue;
                        Struct.readFields((Struct)Array.get(object, j), inputStream);
                    }
                    continue;
                }
                if (!clazz.isPrimitive()) {
                    Struct.readFields((Struct)fieldArray[i].get(struct), inputStream);
                    continue;
                }
                System.err.println("Struct: Unsupported field type: " + clazz);
            }
            if (!bl) {
                Struct.readShort(inputStream, false);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println(illegalAccessException);
        }
    }

    public void read(InputStream inputStream) {
        Struct.readFields(this, inputStream);
    }

    public Field[] getFields() {
        if (this.fields == null) {
            this.fields = this.getClass().getFields();
        }
        return this.fields;
    }

    public String toString() {
        String string = new String();
        try {
            Field[] fieldArray = this.getFields();
            for (int i = 0; i < fieldArray.length; ++i) {
                string = string + fieldArray[i] + " = " + fieldArray[i].get(this) + "\n";
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }
}

