/*
 * Decompiled with CFR 0.152.
 */
package rcssjava.geom;

import rcssjava.VecPosition;
import rcssjava.geom.LineSegment;

public class Line {
    private double a;
    private double b;
    private double c;

    public Line(double d, double d2, double d3) {
        this.a = d;
        this.b = d2;
        this.c = d3;
    }

    public double getA() {
        return this.a;
    }

    public double getB() {
        return this.b;
    }

    public double getC() {
        return this.c;
    }

    public double getSlope() {
        return -this.getB() / this.getA();
    }

    public double getYIntercept() {
        return -this.getC() / this.getA();
    }

    public VecPosition getIntersection(LineSegment lineSegment) {
        return lineSegment.getIntersection(this);
    }

    public VecPosition getIntersection(Line line) {
        double d;
        double d2;
        if (this.a / this.b == line.getA() / line.getB()) {
            return null;
        }
        if (this.a == 0.0) {
            d2 = -this.c / this.b;
            d = line.getYGivenX(d2);
        } else if (line.getA() == 0.0) {
            d2 = -line.getC() / line.getB();
            d = this.getYGivenX(d2);
        } else {
            d2 = (this.a * line.getC() - line.getA() * this.c) / (line.getA() * this.b - this.a * line.getB());
            d = this.getYGivenX(d2);
        }
        return new VecPosition(d2, d);
    }

    public Line getTangentLine(VecPosition vecPosition) {
        return new Line(this.b, -this.a, this.a * vecPosition.getX() - this.b * vecPosition.getY());
    }

    public VecPosition getPointOnLineClosestTo(VecPosition vecPosition) {
        Line line = this.getTangentLine(vecPosition);
        return this.getIntersection(line);
    }

    public double getDistanceToPoint(VecPosition vecPosition) {
        return vecPosition.getDistanceTo(this.getPointOnLineClosestTo(vecPosition));
    }

    public double getYGivenX(double d) {
        if (this.a == 0.0) {
            System.err.println("getYGivenX(): Cannot calculate Y coordinate");
            return 0.0;
        }
        return -(this.b * d + this.c) / this.a;
    }

    public double getXGivenY(double d) {
        if (this.b == 0.0) {
            System.err.println("getXGivenY(): Cannot calculate X coordinate");
            return 0.0;
        }
        return -(this.a * d + this.c) / this.b;
    }

    public static Line makeLineFromTwoPoints(VecPosition vecPosition, VecPosition vecPosition2) {
        double d;
        double d2;
        double d3 = vecPosition2.getX() - vecPosition.getX();
        if (Math.abs(d3) < 1.0E-5) {
            d2 = 0.0;
            d = 1.0;
        } else {
            d2 = 1.0;
            d = -(vecPosition2.getY() - vecPosition.getY()) / d3;
        }
        double d4 = -d2 * vecPosition2.getY() - d * vecPosition2.getX();
        return new Line(d2, d, d4);
    }

    public String toString() {
        String string;
        if (this.a == 0.0) {
            string = "x = " + -this.c / this.b;
        } else {
            string = "y = ";
            if (this.b != 0.0) {
                string = string + -this.b / this.a + "x ";
            }
            if (this.c > 0.0) {
                string = string + "- " + Math.abs(this.c / this.a);
            } else if (this.c < 0.0) {
                string = string + "+ " + Math.abs(this.c / this.a);
            }
        }
        return string;
    }
}

