#!/bin/sh

# Keepaway startup script
# 
# No commandline parameters.  All options are set in this file.
#

# Top-level keepaway directory  **SET THIS OPTION**
keepaway_dir=/home/kuhlmann/keepaway

############################################################
# Keeper options                                           #
############################################################

num_keepers=3
keeper_load=0
keeper_load_dir=
keeper_learn=0
#keeper_policy="learned"
#keeper_policy="hold"
#keeper_policy="hand"
keeper_policy="rand"

############################################################
# Taker options                                            #
############################################################

num_takers=2
taker_load=0
taker_load_dir=
taker_learn=0
#taker_policy="learned"
taker_policy="hand"

############################################################
# Client options                                           #
############################################################

save_weights=0
weight_dir=$keepaway_dir/weights

save_client_log=0
log_level="1..1000"
save_client_draw_log=0
client_log_dir=$keepaway_dir/logs

client_dir=$keepaway_dir/player
client=keepaway_player

############################################################
# Server options                                           #
############################################################

ka_width=20
ka_length=$ka_width

unrestricted_vision=0
synch_mode=0

save_kwy_log=1
save_rcg_log=0
save_rcl_log=0
log_dir=$keepaway_dir/logs

port=5800
sleep_time=8

############################################################
#                                                          #
############################################################

date=`date +%Y%m%d%H%M`
machine=`hostname`

proc_name=$date-$machine
save_dir=$weight_dir/$proc_name
log_save_dir=$client_log_dir/$proc_name

s="server"

keepaway_opts="$s::keepaway=1 $s::keepaway_start=$sleep_time $s::keepaway_width=$ka_width $s::keepaway_length=$ka_length"

kwy_log_opts="$s::keepaway_logging=$save_kwy_log $s::keepaway_log_dir=$log_dir $s::keepaway_log_fixed=1 $s::keepaway_log_fixed_name=$proc_name"
rcg_log_opts="$s::game_logging=$save_rcg_log $s::game_log_dir=$log_dir $s::game_log_compression=0 $s::game_log_version=3 $s::game_log_fixed=1 $s::game_log_fixed_name=$proc_name"
rcl_log_opts="$s::text_logging=$save_rcl_log $s::text_log_dir=$log_dir $s::text_log_compression=0 $s::text_log_fixed=1 $s::text_log_fixed_name=$proc_name"
log_opts="$kwy_log_opts $rcg_log_opts $rcl_log_opts"

if (( $unrestricted_vision )); then
#  vision_opts="$s::visible_angle=360 $s::quantize_step=.00001 $s::quantize_step_l=.00001"
  vision_opts="$s::visible_angle=360"
fi

server_opts="$s::port=$port $s::half_time=-1 $s::forbid_kick_off_offside=0 $s::use_offside=0 $s::stamina_inc_max=3500 $s::synch_mode=$synch_mode $keepaway_opts $log_opts $vision_opts"

keeper_opts="-t keepers -e $keeper_learn -q $keeper_policy"
taker_opts="-t takers -e $taker_learn -q $taker_policy"

client_opts="-p $port -k $num_keepers -j $num_takers"

if (( $save_weights && ( $keeper_learn || $taker_learn ) )); then
  echo Creating weights directory: $save_dir
  mkdir $save_dir
  if [ ! -d $save_dir ]; then
    echo Unable to create weight directory: $save_dir
    exit
  fi
fi

if (( $save_client_log || $save_client_draw_log )); then
  mkdir -p $log_save_dir
  if [ ! -d $log_save_dir ]; then
    echo Unable to create client log directory: $log_save_dir
    exit
  fi
fi

if (( $save_kwy_log || $save_rcg_log || $save_rcl_log )); then
  mkdir -p $log_dir
  if [ ! -d $log_dir ]; then
    echo Unable to find log directory: $log_dir
    exit
  fi
fi
  
echo Starting Server....
#echo rcssserver $server_opts
rcssserver $server_opts &

sleep 2
echo Starting Clients....
pushd $client_dir

for (( i=1; i<=$num_keepers; i++ ))
do
  if (( $save_client_log )); then
    klog_opts="-l $log_level -o $log_save_dir/k$i.log"
  fi
  if (( $save_client_draw_log )); then
    kdraw_opts="-d 1 -a $log_save_dir/k$i-draw.log"
  fi
  if (( $save_weights && $keeper_learn )); then
    kweight_opts="-f $save_dir/k$i-weights.dat"
  fi
  if (( $keeper_load )); then
    kweight_opts="$kweight_opts -w $weight_dir/$keeper_load_dir/k$i-weights.dat"
  fi
  kcmd_line="./$client $client_opts $keeper_opts $klog_opts $kdraw_opts $kweight_opts"
  echo Starting Keeper \#$i...
  #echo $kcmd_line
  $kcmd_line &
done

sleep 2
for (( i=1; i<=$num_takers; i++ ))
do
  if (( $save_client_log )); then
    tlog_opts="-l $log_level -o $log_save_dir/t$i.log"
  fi
  if (( $save_client_draw_log )); then
    tdraw_opts="-d 1 -a $log_save_dir/t$i-draw.log"
  fi
  if (( $save_weights && $taker_learn )); then
    tweight_opts="-f $save_dir/t$i-weights.dat"
  fi
  if (( $taker_load )); then
    tweight_opts="$tweight_opts -w $weight_dir/$taker_load_dir/t$i-weights.dat"
  fi
  tcmd_line="./$client $client_opts $taker_opts $tlog_opts $tdraw_opts $tweight_opts"
  echo Starting Taker \#$i...
  #echo $tcmd_line
  $tcmd_line &
done

sleep $sleep_time
popd













