/*
 * Decompiled with CFR 0.152.
 */
package rcssjava;

import java.text.StringCharacterIterator;
import java.util.StringTokenizer;
import rcssjava.SoccerTypes;

public class Utils {
    private Utils() {
    }

    public static double cosDeg(double d) {
        return Math.cos(Math.toRadians(d));
    }

    public static double sinDeg(double d) {
        return Math.sin(Math.toRadians(d));
    }

    public static double tanDeg(double d) {
        return Math.tan(Math.toRadians(d));
    }

    public static double atanDeg(double d) {
        return Math.toDegrees(Math.atan(d));
    }

    public static double atan2Deg(double d, double d2) {
        if (Math.abs(d2) < 1.0E-5 && Math.abs(d) < 1.0E-5) {
            return 0.0;
        }
        return Math.toDegrees(Math.atan2(d, d2));
    }

    public static double acosDeg(double d) {
        if (d >= 1.0) {
            return 0.0;
        }
        if (d <= -1.0) {
            return 180.0;
        }
        return Math.toDegrees(Math.acos(d));
    }

    public static double asinDeg(double d) {
        if (d >= 1.0) {
            return 90.0;
        }
        if (d <= -1.0) {
            return -90.0;
        }
        return Math.toDegrees(Math.asin(d));
    }

    public static double normalizeAngle(double d) {
        while (d > 180.0) {
            d -= 360.0;
        }
        while (d < -180.0) {
            d += 360.0;
        }
        return d;
    }

    public static int sign(double d) {
        return d > 0.0 ? 1 : -1;
    }

    public static double getBisectorTwoAngles(double d, double d2) {
        return Utils.normalizeAngle(Utils.atan2Deg(Utils.sinDeg(d) + Utils.sinDeg(d2), Utils.cosDeg(d) + Utils.cosDeg(d2)));
    }

    public static boolean isLeftPlayer(int n) {
        return n >= 0 && n <= 10;
    }

    public static boolean isRightPlayer(int n) {
        return n >= 11 && n <= 21;
    }

    public static boolean isPlayer(int n) {
        return Utils.isLeftPlayer(n) || Utils.isRightPlayer(n);
    }

    public static boolean isLeftGoal(int n) {
        return n == 23;
    }

    public static boolean isRightGoal(int n) {
        return n == 24;
    }

    public static boolean isGoal(int n) {
        return Utils.isLeftGoal(n) || Utils.isRightGoal(n);
    }

    public static boolean isBall(int n) {
        return n == 22;
    }

    public static int getUnumFromID(int n) {
        if (Utils.isLeftPlayer(n)) {
            return n - 0 + 1;
        }
        if (Utils.isRightPlayer(n)) {
            return n - 11 + 1;
        }
        return 0;
    }

    public static int getSideFromID(int n) {
        if (Utils.isLeftPlayer(n) || Utils.isLeftGoal(n)) {
            return 0;
        }
        if (Utils.isRightPlayer(n) || Utils.isRightGoal(n)) {
            return 1;
        }
        return -1;
    }

    public static int getBallID() {
        return 22;
    }

    public static int getLeftPlayerID(int n) {
        return 0 + n - 1;
    }

    public static int getRightPlayerID(int n) {
        return 11 + n - 1;
    }

    public static int getPlayerID(int n, int n2) {
        if (n == 0) {
            return Utils.getLeftPlayerID(n2);
        }
        if (n == 1) {
            return Utils.getRightPlayerID(n2);
        }
        return -1;
    }

    public static String getPlayModeString(int n) {
        return SoccerTypes.PLAYMODE_STRINGS[n];
    }

    public static String stripPath(String string) {
        String string2 = new String();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
        }
        return string2;
    }

    public static String unescape(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        char c = stringCharacterIterator.current();
        boolean bl = false;
        while (c != '\uffff') {
            if (bl) {
                switch (c) {
                    case 'n': {
                        stringBuffer.append('\n');
                        break;
                    }
                    default: {
                        stringBuffer.append(c);
                    }
                }
                bl = false;
            } else {
                switch (c) {
                    case '\\': {
                        bl = true;
                        break;
                    }
                    case '\"': {
                        break;
                    }
                    default: {
                        stringBuffer.append(c);
                    }
                }
            }
            c = stringCharacterIterator.next();
        }
        return stringBuffer.toString();
    }
}

