/*
 * Decompiled with CFR 0.152.
 */
package rcssjava.comm;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;

public class Connection {
    public static final int MAX_MSG = 4096;
    private DatagramSocket socket;
    private InetAddress hostIP;
    private int hostPort;

    public Connection() {
        try {
            this.socket = new DatagramSocket();
            this.socket.setSoTimeout(5000);
        }
        catch (SocketException socketException) {
            System.err.println("Connection: Could not bind local UDP socket");
            System.exit(1);
        }
    }

    public Connection(String string, int n) {
        this();
        if (!this.connect(string, n)) {
            System.err.println("Connection: Could not create connection with " + string + ":" + n);
            System.exit(1);
        }
    }

    public boolean connect(String string, int n) {
        try {
            this.hostIP = InetAddress.getByName(string);
            this.hostPort = n;
        }
        catch (UnknownHostException unknownHostException) {
            System.err.println("Connection: Unknown host: " + string);
            return false;
        }
        return true;
    }

    public void disconnect() {
        this.socket.close();
    }

    public boolean isConnected() {
        return this.hostIP != null;
    }

    public String receive() {
        byte[] byArray = new byte[4096];
        DatagramPacket datagramPacket = new DatagramPacket(byArray, 4096);
        try {
            this.socket.receive(datagramPacket);
            this.hostPort = datagramPacket.getPort();
            return new String(datagramPacket.getData(), datagramPacket.getOffset(), datagramPacket.getLength() - 1);
        }
        catch (SocketTimeoutException socketTimeoutException) {
            System.err.println("Connection: server timeout: " + socketTimeoutException);
            System.exit(-1);
            return null;
        }
        catch (IOException iOException) {
            System.err.println("Connection: receive error: " + iOException);
            return null;
        }
    }

    public boolean send(String string) {
        string = string + '\u0000';
        DatagramPacket datagramPacket = new DatagramPacket(string.getBytes(), string.length(), this.hostIP, this.hostPort);
        try {
            this.socket.send(datagramPacket);
        }
        catch (IOException iOException) {
            System.err.println("Connection: send error: " + iOException);
            return false;
        }
        return true;
    }
}

