/*
 * Decompiled with CFR 0.152.
 */
package rcssjava.comm;

import rcssjava.ServerParams;
import rcssjava.SoccerTypes;
import rcssjava.Utils;
import rcssjava.VecPosition;
import rcssjava.WorldState;

public class RCSSParser {
    private WorldState WS;
    private ServerParams SP;

    public RCSSParser(WorldState worldState, ServerParams serverParams) {
        this.WS = worldState;
        this.SP = serverParams;
    }

    public boolean analyzeMessage(String string) {
        if (string == null || string.length() < 2) {
            return false;
        }
        switch (string.charAt(1)) {
            case 'c': {
                return this.analyzeCLangVersionMessage(string);
            }
            case 'o': {
                return true;
            }
            case 's': {
                switch (string.charAt(3)) {
                    case 'e': {
                        return this.analyzeSeeGlobalMessage(string);
                    }
                    case 'r': {
                        return this.analyzeServerParamMessage(string);
                    }
                }
            }
            case 'i': {
                return this.analyzeInitMessage(string);
            }
            case 'h': {
                return this.analyzeHearMessage(string);
            }
            case 'p': {
                if (string.charAt(8) == 't') {
                    return this.analyzePlayerTypeMessage(string);
                }
                return this.analyzePlayerParamMessage(string);
            }
            case 'e': {
                System.err.println(string);
                break;
            }
            case 't': {
                break;
            }
            default: {
                System.err.println("Ignored message: " + string);
                return false;
            }
        }
        return true;
    }

    private boolean analyzeCLangVersionMessage(String string) {
        return true;
    }

    private boolean analyzeSeeGlobalMessage(String string) {
        int n = 12;
        int n2 = string.indexOf(32, n);
        int n3 = Integer.parseInt(string.substring(n, n2));
        n = n2;
        this.WS.updateTime(n3);
        block5: while (string.charAt(n) != ')') {
            switch (string.charAt(n += 3)) {
                case 'b': {
                    n2 = string.indexOf(32, n += 3);
                    double d = Double.parseDouble(string.substring(n, n2));
                    n = n2 + 1;
                    n2 = string.indexOf(32, n);
                    double d2 = Double.parseDouble(string.substring(n, n2));
                    n = n2 + 1;
                    n2 = string.indexOf(32, n);
                    double d3 = Double.parseDouble(string.substring(n, n2));
                    n = n2 + 1;
                    n2 = string.indexOf(41, n);
                    double d4 = Double.parseDouble(string.substring(n, n2));
                    n = n2 + 1;
                    this.WS.updateBall(new VecPosition(d, d2), new VecPosition(d3, d4));
                    continue block5;
                }
                case 'p': {
                    boolean bl;
                    int n4;
                    n2 = string.indexOf(34, n += 3);
                    String string2 = string.substring(n, n2);
                    int n5 = this.WS.getSideFromTeamName(string2);
                    if (n5 == -1) {
                        if (this.WS.getTeamName(0).equals("")) {
                            n5 = 0;
                        } else if (this.WS.getTeamName(1).equals("")) {
                            n5 = 1;
                        }
                        this.WS.setTeamName(n5, string2);
                    }
                    n = n2 + 2;
                    int n6 = string.indexOf(32, n);
                    int n7 = string.indexOf(41, n);
                    if (n6 != -1 && n6 < n7) {
                        n4 = Integer.parseInt(string.substring(n, n6));
                        n = string.indexOf(41, n6) + 2;
                        bl = true;
                    } else {
                        n4 = Integer.parseInt(string.substring(n, n7));
                        n = n7 + 2;
                        bl = false;
                    }
                    n2 = string.indexOf(32, n);
                    double d = Double.parseDouble(string.substring(n, n2));
                    n = n2 + 1;
                    n2 = string.indexOf(32, n);
                    double d2 = Double.parseDouble(string.substring(n, n2));
                    n = n2 + 1;
                    n2 = string.indexOf(32, n);
                    double d3 = Double.parseDouble(string.substring(n, n2));
                    n = n2 + 1;
                    n2 = string.indexOf(32, n);
                    double d4 = Double.parseDouble(string.substring(n, n2));
                    n = n2 + 1;
                    n2 = string.indexOf(32, n);
                    double d5 = Double.parseDouble(string.substring(n, n2));
                    n = n2 + 1;
                    n2 = string.indexOf(41, n);
                    double d6 = Double.parseDouble(string.substring(n, n2));
                    n = n2 + 1;
                    this.WS.updatePlayer(Utils.getPlayerID(n5, n4), new VecPosition(d, d2), new VecPosition(d3, d4), d5, d6);
                    continue block5;
                }
                case 'g': {
                    n = string.indexOf(41, n);
                    n = string.indexOf(41, n + 1);
                    ++n;
                    continue block5;
                }
            }
            System.err.println("Error parsing see global message at: " + string.substring(n, string.length()));
            return false;
        }
        return true;
    }

    private boolean analyzeServerParamMessage(String string) {
        int n = 14;
        while (string.charAt(n) != ')') {
            int n2 = string.indexOf(32, ++n);
            String string2 = string.substring(n, n2);
            n = n2 + 1;
            n2 = string.indexOf(41, n);
            String string3 = string.substring(n, n2);
            n = n2 + 1;
            this.SP.setParam(string2, string3);
        }
        return true;
    }

    private boolean analyzeInitMessage(String string) {
        if (string.charAt(6) == 'l') {
            this.WS.setSide(0);
        } else if (string.charAt(6) == 'r') {
            this.WS.setSide(1);
        } else {
            this.WS.setSide(-1);
            return false;
        }
        return true;
    }

    private boolean analyzeHearMessage(String string) {
        int n = 6;
        int n2 = string.indexOf(32, n);
        int n3 = Integer.parseInt(string.substring(n, n2));
        n = n2 + 1;
        switch (string.charAt(n)) {
            case '(': {
                break;
            }
            case 'r': {
                n = string.indexOf(32, n) + 1;
                n2 = string.indexOf(41, n);
                String string2 = string.substring(n, n2);
                this.WS.setPlayMode(this.getPlayModeFromString(string2));
                break;
            }
            default: {
                System.err.println("Error parsing hear message: " + string);
                return false;
            }
        }
        return true;
    }

    private int getPlayModeFromString(String string) {
        for (int i = 0; i < 50; ++i) {
            if (!string.equals(SoccerTypes.PLAYMODE_STRINGS[i])) continue;
            return i;
        }
        return 0;
    }

    private boolean analyzePlayerTypeMessage(String string) {
        return true;
    }

    private boolean analyzePlayerParamMessage(String string) {
        int n = 14;
        while (string.charAt(n) != ')') {
            int n2 = string.indexOf(32, ++n);
            String string2 = string.substring(n, n2);
            n = n2 + 1;
            n2 = string.indexOf(41, n);
            String string3 = string.substring(n, n2);
            n = n2 + 1;
            this.SP.setParam(string2, string3);
        }
        return true;
    }
}

