/*
 * Decompiled with CFR 0.152.
 */
package rcssjava.gamelog;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import rcssjava.VecPosition;
import rcssjava.WorldState;
import rcssjava.gamelog.BallT;
import rcssjava.gamelog.PlayerParamsT;
import rcssjava.gamelog.PlayerT;
import rcssjava.gamelog.PlayerTypeT;
import rcssjava.gamelog.ServerParamsT;
import rcssjava.gamelog.ShortShowinfoT2;
import rcssjava.gamelog.Struct;
import rcssjava.gamelog.TeamT;

public class GameLog {
    final int REC_VERSION_NONE = 0;
    final int REC_VERSION_OLD = 1;
    final int REC_VERSION_2 = 2;
    final int REC_VERSION_3 = 3;
    final int NO_INFO = 0;
    final int SHOW_MODE = 1;
    final int MSG_MODE = 2;
    final int DRAW_MODE = 3;
    final int BLANK_MODE = 4;
    final int PM_MODE = 5;
    final int TEAM_MODE = 6;
    final int PT_MODE = 7;
    final int PARAM_MODE = 8;
    final int PPARAM_MODE = 9;
    private WorldState WS;
    private InputStream logFile;
    private int logVersion;
    private BallT ballT;
    private PlayerParamsT playerParamsT;
    private PlayerT playerT;
    private PlayerTypeT playerTypeT;
    private ServerParamsT serverParamsT;
    private ShortShowinfoT2 shortShowinfoT2;
    private TeamT[] teams;

    public GameLog(String string) {
        try {
            this.logFile = new FileInputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("GameLog: File not found: " + string);
            System.exit(1);
        }
        this.logVersion = 0;
        this.readVersion();
        this.ballT = new BallT();
        this.playerParamsT = new PlayerParamsT();
        this.playerT = new PlayerT();
        this.playerTypeT = new PlayerTypeT();
        this.serverParamsT = new ServerParamsT();
        this.shortShowinfoT2 = new ShortShowinfoT2();
        this.teams = new TeamT[2];
        for (int i = 0; i < 2; ++i) {
            this.teams[i] = new TeamT();
        }
    }

    public void setWorldState(WorldState worldState) {
        this.WS = worldState;
    }

    private int s2i(short s) {
        return s;
    }

    private int l2i(long l) {
        return (int)Math.round(this.l2d(l));
    }

    private double l2d(long l) {
        return (double)l / 65536.0;
    }

    private void readVersion() {
        byte[] byArray = new byte[128];
        try {
            this.logFile.read(byArray, 0, 4);
        }
        catch (IOException iOException) {
            System.err.println("GameLog: Unable to read version number");
            System.exit(1);
        }
        String string = new String(byArray, 0, 4);
        this.logVersion = string.substring(0, 3).equals("ULG") ? byArray[3] : 1;
    }

    private void readPlayMode() {
        byte by = Struct.readByte(this.logFile);
        this.updatePlayMode(by);
    }

    private void readTeams() {
        for (int i = 0; i < 2; ++i) {
            this.teams[i].read(this.logFile);
        }
        this.updateTeams(this.teams);
    }

    private void readShowInfo() {
        this.shortShowinfoT2.read(this.logFile);
        this.updateShowInfo(this.shortShowinfoT2);
    }

    private void readMessage() {
        short s = Struct.readShort(this.logFile, false);
        short s2 = Struct.readShort(this.logFile, false);
        byte[] byArray = new byte[2048];
        try {
            this.logFile.read(byArray, 0, this.s2i(s2));
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            return;
        }
        this.updateMessage(s, byArray, s2);
    }

    private void readServerParams() {
        this.serverParamsT.read(this.logFile);
        this.updateServerParams(this.serverParamsT);
    }

    private void readPlayerParams() {
        this.playerParamsT.read(this.logFile);
        this.updatePlayerParams(this.playerParamsT);
    }

    private void readHeteroPlayerType() {
        this.playerTypeT.read(this.logFile);
        Struct.readShort(this.logFile, false);
        this.updateHeteroPlayerType(this.playerTypeT);
    }

    public boolean readNext() {
        if (this.logVersion == 3) {
            short s = Struct.readShort(this.logFile, false);
            if (s == 0) {
                s = Struct.readShort(this.logFile, false);
            }
            switch (this.s2i(s)) {
                case 5: {
                    this.readPlayMode();
                    break;
                }
                case 6: {
                    this.readTeams();
                    break;
                }
                case 1: {
                    this.readShowInfo();
                    break;
                }
                case 2: {
                    this.readMessage();
                    break;
                }
                case 8: {
                    this.readServerParams();
                    break;
                }
                case 9: {
                    this.readPlayerParams();
                    break;
                }
                case 7: {
                    this.readHeteroPlayerType();
                    break;
                }
                default: {
                    if (this.s2i(s) != this.WS.getTime()) {
                        System.err.println("GameLog: Invalid mode: " + this.s2i(s));
                    }
                    return false;
                }
            }
        } else {
            System.err.println("GameLog: Bad log version: " + this.logVersion);
            return false;
        }
        return true;
    }

    private void updateServerParams(ServerParamsT serverParamsT) {
    }

    private void updatePlayerParams(PlayerParamsT playerParamsT) {
    }

    private void updateHeteroPlayerType(PlayerTypeT playerTypeT) {
    }

    private void updatePlayMode(byte by) {
        this.WS.setPlayMode(by);
    }

    private void updateTeams(TeamT[] teamTArray) {
        this.WS.setLeftTeamName(new String(teamTArray[0].name).trim());
        this.WS.setRightTeamName(new String(teamTArray[1].name).trim());
        this.WS.setLeftScore(this.s2i(teamTArray[0].score));
        this.WS.setRightScore(this.s2i(teamTArray[1].score));
    }

    private void updateShowInfo(ShortShowinfoT2 shortShowinfoT2) {
        this.WS.updateTime(this.s2i(shortShowinfoT2.time));
        BallT ballT = shortShowinfoT2.ball;
        VecPosition vecPosition = new VecPosition(this.l2d(ballT.x), this.l2d(ballT.y));
        VecPosition vecPosition2 = new VecPosition(this.l2d(ballT.deltax), this.l2d(ballT.deltay));
        this.WS.updateBall(vecPosition, vecPosition2);
        for (int i = 0; i < 22; ++i) {
            PlayerT playerT = shortShowinfoT2.pos[i];
            VecPosition vecPosition3 = new VecPosition(this.l2d(playerT.x), this.l2d(playerT.y));
            VecPosition vecPosition4 = new VecPosition(this.l2d(playerT.deltax), this.l2d(playerT.deltay));
            double d = Math.toDegrees(this.l2d(playerT.body_angle));
            double d2 = Math.toDegrees(this.l2d(playerT.head_angle));
            this.WS.updatePlayer(i, vecPosition3, vecPosition4, d, d2);
        }
    }

    private void updateMessage(short s, byte[] byArray, short s2) {
    }
}

