/*
 * Decompiled with CFR 0.152.
 */
package rcssjava.logplayer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import rcssjava.Utils;
import rcssjava.WorldState;
import rcssjava.gamelog.GameLog;
import rcssjava.logplayer.LogDrawInfo;
import rcssjava.logplayer.LogDrawLexer;
import rcssjava.logplayer.LogDrawParser;
import rcssjava.monitor.FieldShape;
import rcssjava.monitor.Monitor;
import rcssjava.monitor.MonitorParams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogPlayer
implements ActionListener {
    private static final int MAX_CYCLES = 6002;
    private static final int NORMAL_DELAY = 90;
    private static final int FAST_DELAY = 30;
    private static final String imgDir = "/pngs/";
    private JFrame frame;
    private JLabel timeLabel;
    private JTextField goTextField;
    private JPanel listPanel;
    private Vector<WorldState> worldStates;
    private GameLog gl;
    private Monitor monitor;
    private Vector<String> drawLogs;
    private Map<String, LogDrawInfo> logInfo;
    private Map<String, Vector<JCheckBox>> checkBoxes;
    private JComboBox logList;
    private String rcgLog;
    private String stateLog;
    private int cycle;
    private int cycleInc;
    private Timer timer;

    LogPlayer(String string, String string2, Vector<String> vector) {
        this.rcgLog = string;
        this.stateLog = string2;
        this.drawLogs = vector;
        this.logInfo = new HashMap<String, LogDrawInfo>();
        this.worldStates = new Vector();
        this.cycle = 1;
        if (string != null) {
            this.gl = new GameLog(string);
        }
    }

    private void createControls() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/pngs/fastreverse.png"));
        ImageIcon imageIcon2 = new ImageIcon(this.getClass().getResource("/pngs/reverse.png"));
        ImageIcon imageIcon3 = new ImageIcon(this.getClass().getResource("/pngs/stepreverse.png"));
        ImageIcon imageIcon4 = new ImageIcon(this.getClass().getResource("/pngs/stop.png"));
        ImageIcon imageIcon5 = new ImageIcon(this.getClass().getResource("/pngs/step.png"));
        ImageIcon imageIcon6 = new ImageIcon(this.getClass().getResource("/pngs/play.png"));
        ImageIcon imageIcon7 = new ImageIcon(this.getClass().getResource("/pngs/fastforward.png"));
        Dimension dimension = new Dimension(25, 24);
        JButton jButton = new JButton(imageIcon);
        jButton.setActionCommand("Fast Reverse");
        jButton.addActionListener(this);
        jButton.setPreferredSize(dimension);
        JButton jButton2 = new JButton(imageIcon2);
        jButton2.setActionCommand("Reverse");
        jButton2.addActionListener(this);
        jButton2.setPreferredSize(dimension);
        JButton jButton3 = new JButton(imageIcon3);
        jButton3.setActionCommand("Step Reverse");
        jButton3.addActionListener(this);
        jButton3.setPreferredSize(dimension);
        JButton jButton4 = new JButton(imageIcon4);
        jButton4.setActionCommand("Stop");
        jButton4.addActionListener(this);
        jButton4.setPreferredSize(dimension);
        JButton jButton5 = new JButton(imageIcon5);
        jButton5.setActionCommand("Step");
        jButton5.addActionListener(this);
        jButton5.setPreferredSize(dimension);
        JButton jButton6 = new JButton(imageIcon6);
        jButton6.setActionCommand("Play");
        jButton6.addActionListener(this);
        jButton6.setPreferredSize(dimension);
        JButton jButton7 = new JButton(imageIcon7);
        jButton7.setActionCommand("Fast Forward");
        jButton7.addActionListener(this);
        jButton7.setPreferredSize(dimension);
        jPanel.add(jButton);
        jPanel.add(jButton2);
        jPanel.add(jButton3);
        jPanel.add(jButton4);
        jPanel.add(jButton5);
        jPanel.add(jButton6);
        jPanel.add(jButton7);
        this.frame.getContentPane().add(jPanel);
    }

    private void initializeFrame() {
        JFrame.setDefaultLookAndFeelDecorated(false);
        this.frame = new JFrame("JARCS Log Player");
        this.frame.setDefaultCloseOperation(3);
        this.frame.getContentPane().setLayout(new BoxLayout(this.frame.getContentPane(), 1));
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.white);
        this.timeLabel = new JLabel("time");
        jPanel.add(this.timeLabel);
        this.frame.getContentPane().add(jPanel);
        JPanel jPanel2 = new JPanel();
        JLabel jLabel = this.rcgLog != null ? new JLabel(Utils.stripPath(this.rcgLog)) : new JLabel(Utils.stripPath(this.stateLog));
        jPanel2.add(jLabel);
        this.frame.getContentPane().add(jPanel2);
        this.createControls();
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        this.goTextField = new JTextField(6);
        this.goTextField.setFont(new Font("Monospaced", 1, 14));
        this.goTextField.setHorizontalAlignment(4);
        jPanel3.add(this.goTextField);
        JButton jButton = new JButton("Jump");
        jButton.addActionListener(this);
        jPanel3.add(jButton);
        this.frame.getContentPane().add(jPanel3);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        if (this.logInfo != null) {
            AbstractButton abstractButton;
            Serializable serializable;
            Object object;
            Object object2;
            JPanel jPanel5 = new JPanel(new BorderLayout());
            Border border = BorderFactory.createEtchedBorder();
            TitledBorder titledBorder = BorderFactory.createTitledBorder(border, "Log File");
            titledBorder.setTitleJustification(3);
            jPanel5.setBorder(titledBorder);
            TreeSet<String> treeSet = new TreeSet<String>(this.logInfo.keySet());
            Object[] objectArray = treeSet.toArray(new String[0]);
            Arrays.sort(objectArray);
            this.logList = new JComboBox<Object>(objectArray);
            this.logList.addActionListener(this);
            jPanel5.add(this.logList);
            jPanel4.add(jPanel5);
            this.checkBoxes = new HashMap<String, Vector<JCheckBox>>();
            for (int i = 0; i < objectArray.length; ++i) {
                object2 = this.logInfo.get(objectArray[i]);
                object = ((LogDrawInfo)object2).getIdents();
                Arrays.sort((Object[])object);
                serializable = new Vector<JCheckBox>();
                for (int j = 0; j < ((Object)object).length; ++j) {
                    abstractButton = new JCheckBox((String)object[j]);
                    abstractButton.setSelected(true);
                    abstractButton.addActionListener(this);
                    ((Vector)serializable).add(abstractButton);
                }
                this.checkBoxes.put((String)objectArray[i], (Vector<JCheckBox>)serializable);
            }
            JPanel jPanel6 = new JPanel(new BorderLayout());
            object2 = BorderFactory.createEtchedBorder();
            object = BorderFactory.createTitledBorder((Border)object2, "Log Data");
            ((TitledBorder)object).setTitleJustification(3);
            jPanel6.setBorder((Border)object);
            this.listPanel = new JPanel();
            this.listPanel.setLayout(new BoxLayout(this.listPanel, 1));
            this.updateCheckBoxes();
            serializable = new JScrollPane(this.listPanel);
            ((JComponent)serializable).setPreferredSize(new Dimension(100, 200));
            jPanel6.add((Component)serializable);
            jPanel4.add(jPanel6);
            JPanel jPanel7 = new JPanel();
            jPanel7.setLayout(new BoxLayout(jPanel7, 0));
            abstractButton = new JButton("All");
            abstractButton.addActionListener(this);
            jPanel7.add(abstractButton);
            JButton jButton2 = new JButton("None");
            jButton2.addActionListener(this);
            jPanel7.add(jButton2);
            jPanel4.add(jPanel7);
            this.frame.getContentPane().add((Component)jPanel4, "West");
        }
        this.frame.pack();
        this.frame.setVisible(true);
    }

    private void selectAll(boolean bl) {
        Component[] componentArray = this.listPanel.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            JCheckBox jCheckBox = (JCheckBox)componentArray[i];
            jCheckBox.setSelected(bl);
        }
    }

    private void updateCheckBoxes() {
        this.listPanel.removeAll();
        String string = (String)this.logList.getSelectedItem();
        Vector<JCheckBox> vector = this.checkBoxes.get(string);
        if (vector != null) {
            for (JCheckBox jCheckBox : vector) {
                this.listPanel.add(jCheckBox);
            }
            Dimension dimension = this.frame.getSize();
            int n = (int)dimension.getWidth();
            int n2 = (int)dimension.getHeight();
            this.frame.setSize(n + 1, n2 + 1);
            this.frame.setSize(n, n2);
            this.frame.repaint();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Fast Reverse")) {
            this.timer.setDelay(30);
            this.cycleInc = -1;
            this.timer.start();
        } else if (string.equals("Reverse")) {
            this.timer.setDelay(90);
            this.cycleInc = -1;
            this.timer.start();
        } else if (string.equals("Step Reverse")) {
            this.cycleInc = -1;
            this.timer.stop();
            this.step();
        } else if (string.equals("Stop")) {
            this.timer.stop();
        } else if (string.equals("Step")) {
            this.cycleInc = 1;
            this.timer.stop();
            this.step();
        } else if (string.equals("Play")) {
            this.timer.setDelay(90);
            this.cycleInc = 1;
            this.timer.start();
        } else if (string.equals("Fast Forward")) {
            this.timer.setDelay(30);
            this.cycleInc = 1;
            this.timer.start();
        } else if (string.equals("Jump")) {
            try {
                this.cycle = Integer.parseInt(this.goTextField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                this.goTextField.setText("Error");
            }
        } else if (string.equals("All")) {
            this.selectAll(true);
        } else if (string.equals("None")) {
            this.selectAll(false);
        } else {
            this.updateCheckBoxes();
        }
        this.updateCycle();
    }

    private void parseDrawLog(String string) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            LogDrawLexer logDrawLexer = new LogDrawLexer(bufferedReader);
            LogDrawParser logDrawParser = new LogDrawParser(logDrawLexer);
            LogDrawInfo logDrawInfo = new LogDrawInfo(6002);
            this.logInfo.put(Utils.stripPath(string), logDrawInfo);
            logDrawParser.info = logDrawInfo;
            System.out.print("Parsing log: " + string);
            logDrawParser.file();
            System.out.println("...done");
        }
        catch (Exception exception) {
            System.err.println("Error parsing " + string + ": " + exception);
        }
    }

    private void parseGameLog() {
        if (this.rcgLog != null) {
            System.out.print("Parsing game log");
            int n = -1;
            WorldState worldState = new WorldState(null);
            this.gl.setWorldState(worldState);
            while (worldState.getPlayMode() != 2 && this.gl.readNext()) {
                if (worldState.getTime() <= n) continue;
                this.worldStates.add(worldState);
                worldState = new WorldState(null).copy(worldState);
                this.gl.setWorldState(worldState);
                if (worldState.getTime() % 100 == 0) {
                    System.out.print(".");
                }
                n = worldState.getTime();
            }
        } else {
            System.out.print("Parsing state log");
            try {
                ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(this.stateLog));
                int n = 0;
                for (WorldState worldState : (LinkedList)objectInputStream.readObject()) {
                    if (n++ % 100 == 0) {
                        System.out.print(".");
                    }
                    this.worldStates.add(worldState);
                }
            }
            catch (Exception exception) {
                System.err.println("Couldn't parse state log: " + exception);
                System.exit(1);
            }
        }
        System.out.println("...done");
    }

    private Vector<FieldShape> getShapes(int n) {
        Vector<FieldShape> vector = new Vector<FieldShape>();
        LogDrawInfo logDrawInfo = this.logInfo.get(this.logList.getSelectedItem());
        Component[] componentArray = this.listPanel.getComponents();
        if (logDrawInfo != null) {
            for (int i = 0; i < componentArray.length; ++i) {
                Vector<FieldShape> vector2;
                JCheckBox jCheckBox = (JCheckBox)componentArray[i];
                if (!jCheckBox.isSelected() || (vector2 = logDrawInfo.getInfo(n, jCheckBox.getText())) == null) continue;
                vector.addAll(vector2);
            }
        }
        return vector;
    }

    private WorldState getCycle(int n) {
        return this.worldStates.elementAt(n);
    }

    private void step() {
        this.updateCycle();
        this.cycle += this.cycleInc;
    }

    private void updateCycle() {
        if (this.cycle >= this.worldStates.size()) {
            this.cycle = this.worldStates.size() - 1;
            this.timer.stop();
        } else if (this.cycle < 1) {
            this.cycle = 1;
            this.timer.stop();
        }
        this.timeLabel.setText("time: " + this.cycle);
        this.monitor.update(this.getCycle(this.cycle), this.getShapes(this.cycle));
    }

    private void mainLoop() {
        for (String string : this.drawLogs) {
            this.parseDrawLog(string);
        }
        this.parseGameLog();
        this.initializeFrame();
        MonitorParams monitorParams = new MonitorParams();
        this.monitor = new Monitor(monitorParams);
        this.timer = new Timer(90, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LogPlayer.this.step();
            }
        });
    }

    private static void printUsageAndExit() {
        System.out.println("RCSSJava Log Player\n");
        System.out.println("Usage: java rcssjava.logplayer.LogPlayer [options] <-s cyclequeue.log>|<gamelog.rcg>");
        System.out.println("Commandline Options:");
        System.out.println("-d <drawlog>    Add LogDraw file");
        System.out.println("-s <cyclelog>   Use state queue file");
        System.out.println();
        System.exit(0);
    }

    public static void main(String[] stringArray) {
        String string = null;
        String string2 = null;
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].charAt(0) != '-') {
                string = stringArray[n];
                ++n;
                continue;
            }
            if (stringArray[n].equals("-d")) {
                vector.add(stringArray[n + 1]);
                n += 2;
                continue;
            }
            if (stringArray[n].equals("-s")) {
                string2 = stringArray[n + 1];
                n += 2;
                continue;
            }
            LogPlayer.printUsageAndExit();
        }
        if (string == null && string2 == null) {
            LogPlayer.printUsageAndExit();
        }
        LogPlayer logPlayer = new LogPlayer(string, string2, vector);
        logPlayer.mainLoop();
    }
}

